* TRUE windowing for force.
* ALBERT ALEXANDER BUKOSKI
* RELEASED TO THE PUBLIC DOMAIN
*
* This code was going to be part of the DFORCE.LIB. But the darn .EXE
* file was just to big. This is NOT the fault of FORCE. The coding is quilty.
* There are a massive amount of array handling functions. This results in
* alot of allocation in the stack of sometimes empty vars. This method of
* windowing is not stack based but header based.
* I have ported this puppy to assembler and the exe size went way, way
* south.
* 
* Suggestions: 
* 1. Delete the information getting functions (ie w_row, w_col, etc)
* and this will result in a little space savings on you EXEs
* 2. Decrease the number of windows to a lesser amount.
*
* This is only one method of windowing.

****************************************************************************
* W_INIT()
* INCLUDE FILE: dwindow.hdr
*
* FUNCTION LOGICAL w_init PROTOTYPE
* 
* PURPOSE: Sets up window procedures. Must be used before all other window
* functions
* 
* PARAMETERS: None.
*
* RETURNS: .T. if sucessesful
*
* EXAMPLE: 
* * Set up windows procedures.
* w_init()
* ....
* ....
* SEE ALSO:
****************************************************************************
* W_MAKE()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION UINT w_make PROTOTYPE
* PARAMETERS VALUE UINT r, VALUE UINT c, VALUE UINT r1, VALUE UINT c1,;
* VALUE CHAR border, VALUE CHAR fill_pat, VALUE INT color, VALUE LOGICAL shadow
* 
* PURPOSE: Defines window for later drawing.
* 
* PARAMETERS: w_make(tr,tc,br,bc,border type, fill pattern, color,shadow)
* tr = top row
* tc = top column
* br = bottom row
* bc = bottom column
* border =See FILL() function.
* fill pattern =See FILL() function.
* color	= See FILL() function.
* shadow = .T. for shadows, else .F. for none
*
* RETURNS: Handle of window.
*
* EXAMPLE: 
* * Set up windows procedures then define a window.
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* max_win[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* endpro
* SEE ALSO:
****************************************************************************
* W_OPEN()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_open PROTOTYPE
* PARAMETERS VALUE UINT handle[]

* PURPOSE: Draws pre defined window. 
* 
* PARAMETERS: w_open( array[Number])
* Number is window made with w_make()
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, then open
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* ....
* ....
* endpro
* SEE ALSO:
****************************************************************************
* W_SAY()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_say PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE UINT row, VALUE UINT column, ;
* VALUE CHAR string
*
* PURPOSE: Writes string in window. 
* 
* PARAMETERS: w_say( array[Number], row, col, string)
* Number is window made with w_make()
* W_SAY() uses relative windowing positions. 
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, then open and say something
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* w_say(max_win[0], 0,0,"Check this puppy out")
* w_say(max_win[0], 1,0,"He is so messy")
* ....
* ....
* endpro
* SEE ALSO:
****************************************************************************
* W_OPEN_EXPLODE()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_open_explode PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE UINT speed
* 
* PURPOSE: Draws pre defined window that explodes. 
* 
* PARAMETERS: w_open_explode( array[Number], delay)
* Number is window made with w_make(). This is the same function as w_open()
* but is seperate to reduce code size. Delay is the time delay for exploding
* imploding.
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, then open with exploding effect.
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open_explode(max_win[0],2)
* ....
* ....
* endpro
* SEE ALSO:
****************************************************************************
* W_CLOSE()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_open_explode PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE UINT speed
*
* PURPOSE: Closes a window. 
* 
* PARAMETERS: w_close( array[Number])
* Number is window made with w_make()
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, open	it, close it.
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_close(max_win[0])
* endpro
* SEE ALSO:
****************************************************************************
* W_CLOSE_IMPLODE()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_open_implode PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE UINT speed
*
* PURPOSE: Closes a window by imploding it. 
* 
* PARAMETERS: w_open_explode( array[Number], delay)
* Number is window made with w_make(). Delay is the time delay for imploding
* window.
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, open it, close it.
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_close_implode(max_win[0])
* endpro
* SEE ALSO:
****************************************************************************
* W_CLEAR()
* INCLUDE FILE: dwindow.hdr
*
* PROCEDURE w_clear PROTOTYPE
* PARAMETERS VALUE UINT handle[]
* 
* PURPOSE: Clears inside a window. 
* 
* PARAMETERS: w_clear( array[Number])
* Window is cleared from 1,1 of cursor position leaving border alone.
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, open	it, clear inside.
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_clear(max_win[0])
* endpro
* SEE ALSO:
****************************************************************************
* W_ALTER()
* INCLUDE FILE: dwindow.hdr
* 
* PROCEDURE w_alter PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE UINT new_row, VALUE UINT new_col,;
* VALUE UINT new_row1, VALUE UINT new_col1 
* 
* PURPOSE: Resize or move a window. 
* 
* PARAMETERS: w_alter(array number, row, col, bottom row, bottom col)
*
* RETURNS: Nothing.
*
* * Set up windows procedures,define a window, open it, clear inside and resize
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_alter(max_win[0],0,0,24,79)
* w_clear(max_win[0])
* endpro
* SEE ALSO:
****************************************************************************
* W_HEADER()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION LOGICAL w_header PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE CHAR msg, VALUE INT color
* 
* PURPOSE: Places a Header in a window. 
* 
* PARAMETERS: w_header(array number, message, color of string)
*
* RETURNS: .T. if okay.
*
* * Place a header on a window with blue on white
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_header(max_win[0],"[ Testing Header ]",&white_blue)
* ...
* endpro
* SEE ALSO:
****************************************************************************
* W_FOOTER()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION LOGICAL w_footer PROTOTYPE
* PARAMETERS VALUE UINT handle[], VALUE CHAR msg, VALUE INT color
* 
* PURPOSE: Places a footer in a window. 
* 
* PARAMETERS: w_footer(array number, message, color of string)
*
* RETURNS: .T. if okay.
*
* * Place a footer on a window with blue on white
* vardef
*  uint max_win[10] && Array to hold window structure
* enddef 
* 
* procedure force_main
* w_init()
* win_max[0] = w_make(3,3,10,55,&single_box,"    ",&white_blue,.T.)
* ....
* ....
* w_open(max_win[0])
* delay(1)
* w_footer(max_win[0],"[ Testing Footer ]",&white_blue)
* ...
* endpro
* SEE ALSO:
****************************************************************************
* W_ROW()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION INT w_row PROTOTYPE
* PARAMETERS VALUE UINT handle[]
* 
* PURPOSE: Returns top row of a window. 
* 
* PARAMETERS: w_row(array number)
*
* RETURNS: Row of top left of window.
*
* EXAMPLE:
* * Where is window number 3 ?
* ? w_row(win[3])
* SEE ALSO:
****************************************************************************
* W_COL()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION INT w_col PROTOTYPE
* PARAMETERS VALUE UINT handle[]
* 
* PURPOSE: Returns bottom column of a window. 
* 
* PARAMETERS: w_col(array number)
*
* RETURNS: Bottom column of window.
*
* EXAMPLE:
* * Where is window number 3 ?
* ? w_row(win[3])
* ? w_col(win[3])
* SEE ALSO:
****************************************************************************
* W_COLOR()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION INT w_color PROTOTYPE
* PARAMETERS VALUE UINT handle[]
* 
* PURPOSE: Returns current color of a window. 
* 
* PARAMETERS: w_color(array number)
*
* RETURNS: Color number value.
*
* EXAMPLE:
* * Where is window number 3 and the color?
* ? w_row(win[3])
* ? w_col(win[3])
* ? w_color(win[3])
* SEE ALSO:
****************************************************************************
* W_ACTIVE()
* INCLUDE FILE: dwindow.hdr
* 
* FUNCTION LOGICAL w_active PROTOTYPE
* PARAMETERS VALUE UINT handle[]
* 
* PURPOSE: Returns if a window is active. 
* 
* PARAMETERS: w_active(array number)
*
* RETURNS: .T. if window is active.
*
* EXAMPLE:
* * Where is window number 3 and is the window active?
* ? w_row(win[3])
* ? w_col(win[3])
* ? w_active(win[3])
* SEE ALSO:
* $Header:   D:/pvcs/dforce/wind.prv   1.0   12 Dec 1991 02:08:40   ALEX  $
* $Log:   D:/pvcs/dforce/wind.prv  $
*  
*     Rev 1.0   12 Dec 1991 02:08:40   ALEX
*  Initial revision.


#include colors.hdr
#include keys.hdr
#include string.hdr
#include iif.hdr
#include math.hdr
#include io.hdr
#include system.hdr
#include dstring.hdr
#pragma W_FUNC_PROC-

vardef extern
 byte __color_std
enddef

vardef private
#define DWINDOWS 50
  uint cur_x[&DWINDOWS]
  uint cur_y[&DWINDOWS]
  uint r_win[&DWINDOWS]
  uint c_win[&DWINDOWS]
  uint r1_win[&DWINDOWS]
  uint c1_win[&DWINDOWS]
  uint clr_win[&DWINDOWS]
  uint w_back[&DWINDOWS]
  uint max_header
  uint w_head_clr[&DWINDOWS]
  uint w_foot_clr[&DWINDOWS]
  char bord_win[&DWINDOWS]
  char fill_win[&DWINDOWS]
  char(79) footer_win[&DWINDOWS]
  char(79) header_win[&DWINDOWS]
  logical shad_win[&DWINDOWS]
  logical w_head[&DWINDOWS]
  logical w_foot[&DWINDOWS]
  logical expld[&DWINDOWS]
  logical active_w[&DWINDOWS]
enddef

* These functions are internal calls to some routines I wrote to get
* the status of the called array. They are not available to be released

* All this does is clear the screen using the scroll function. Modify
* the scroll function to go down and clear with current attribute.

procedure dbclr prototype
parameters value uint , value uint ,value uint ,value uint ,value uint 


* This function make a shadow on the screen
* I decided not to make a shadow with FILL() in order for
* W_SAY to work. You have 3 choice for this. 1 Write a routine
* to make a shadow(TYPE 6 on FILL function). 2 Remove support for 
* making shadows. 3. Modify W_SAY to work with what ever type
* of shadow you want.
procedure df_shadow prototype
parameters value uint tr, value uint tc,value uint br ,value uint bc

* w_header and w_footer simply return .T. if there is a HEADER 
* or FOOTER for that particular window.
* for w_header
function logical DF_HDR prototype
PARAMETERS VALUE UINT

* for w_footer
function logical DF_FTR prototype
parameters value uint 


function logical w_init
max_header = 0
return .t.
endpro

procedure w_open_explode
PARAMS VALUE UINT h, VALUE UINT speed
VARDEF
   	UINT	ir,ic,ir1,ic1
	LOGICAL	odd
	UINT  BC
	UINT  SC
ENDDEF
*w_back[h] = savescrn(r_win[h],c_win[h],r1_win[h],c1_win[h])
w_back[h] = savescrn(0,0,24,79)
active_w[h] = .t.
    ir = (r_win[h] + r1_win[h]) / 2 - 1
    ic = (c_win[h] + c1_win[h]) / 2 - 1
    ir1 = ir + 1
    ic1 = ic + 1
    odd = .f.
    REPEAT
    odd = .NOT. odd
    IF odd
	IF ( ir > r_win[h] )
    	    ir = ir - 1
	ENDIF
	IF ( ir1 < r1_win[h] )
    	    ir1 = ir1 + 1
	ENDIF
    ENDIF
			
    IF ( ic > c_win[h] )
	ic = ic - 1						   
    ENDIF							   
    IF ( ic1 < c1_win[h] )
	ic1 = ic1 + 1
    ENDIF
    FILL(ir,ic,ir1,ic1,bord_win[h],fill_win[h],clr_win[h],clr_win[h] , 0 )
if shad_win[h]
df_shadow(ir,ic,ir1,ic1)
endif
* A little trick to delay for hundreths of a second

	sound(0,speed)
    UNTIL ir = r_win[h] .AND. ic = c_win[h] .AND. ir1 = r1_win[h] .AND. ic1 = c1_win[h] 
ENDPRO

procedure w_close_implode
PARAMETERS value uint h, value int delay_len
VARDEF
int start_ul_row,start_ul_col,start_lr_row ,start_lr_col ,temp_ul_row,temp_ul_col,;  
temp_lr_row,temp_lr_col,diff_row ,diff_col,increment 
int sleep_cnt
int step_cnt
int inc_row
int inc_col
int sleep
ENDDEF
sleep = 1

start_ul_row = r1_win[h] - 1
start_ul_col = c1_win[h] - 1
start_lr_row = r1_win[h]
start_lr_col = c1_win[h]

temp_ul_row  = r_win[h]
temp_ul_col  = c_win[h]
temp_lr_row  = r1_win[h]
temp_lr_col  = c1_win[h]

diff_row     = start_ul_row - r_win[h]
diff_col     = start_ul_col - c_win[h]

IF diff_row > diff_col
	increment = diff_col
ELSE
	increment = diff_row
ENDIF

inc_row = diff_row / increment
inc_col = diff_col / increment

step_cnt = 1

DO WHILE step_cnt <= increment
RESTORESCRN(w_back[h])

	temp_ul_row = trunc(temp_ul_row + inc_row)
	temp_ul_col = trunc(temp_ul_col + inc_col)
	
	@ temp_ul_row + 1, temp_ul_col + 1 CLEAR TO;
	temp_lr_row - 1, temp_lr_col - 1
	
fill(temp_ul_row, temp_ul_col, temp_lr_row, temp_lr_col,bord_win[h],fill_win[h],clr_win[h],clr_win[h] ,0)
if shad_win[h]
df_shadow(temp_ul_row, temp_ul_col, temp_lr_row, temp_lr_col)
endif
	sound(0,delay_len)
	sleep_cnt = 1
	
	DO WHILE sleep_cnt < sleep
		sleep_cnt = sleep_cnt + 1
	ENDDO
	
	step_cnt = step_cnt + 1
ENDDO

RESTORESCRN(w_back[h])
active_w[h] = .f.
ENDPRO

function uint w_make
parameters value uint r, value uint c, value uint r1, value uint c1,;
value char bord, value char fill_pat, value int clr,value logical shad
vardef
 uint h
enddef

h = max_header 
cur_x[h]	= 0
cur_y[h]	= 0
r_win[h]   	= r	
c_win[h]   	= c	
r1_win[h]  	= r1	
c1_win[h]   = c1 
bord_win[h] = bord
fill_win[h] = fill_pat
clr_win[h]  = clr
w_back[h]	= 0
w_head_clr[h] =	0
w_foot_clr[h] =	0
footer_win[h] = ""
header_win[h] =""
w_head[h] = .f.
w_foot[h] = .f.
active_w[h] = .f.
shad_win[h] = shad

max_header = max_header + 1
return h
endpro

procedure w_open
parameters value uint h

w_back[h] = savescrn(r_win[h],c_win[h],r1_win[h]+2,c1_win[h]+2)
active_w[h] = .t.
fill(r_win[h],c_win[h],r1_win[h],c1_win[h],bord_win[h], fill_win[h] , clr_win[h],; 
clr_win[h], 0)
if shad_win[h]
df_shadow(r_win[h],c_win[h],r1_win[h],c1_win[h])
endif

endpro


function int w_row
parameters value uint h
return	r_win[h]
endpro

function int w_col
parameters value uint h
return	c1_win[h]
endpro

function int w_color
parameters value uint h
return	clr_win[h]
endpro


function logical w_active
parameters value uint h
return	active_w[h]
endpro

procedure w_close
parameters value uint h
cur_x[h] = 0
cur_y[h] = 0
active_w[h] = .f.
restorescrn(w_back[h])
endpro

procedure w_clear
parameters value uint h
vardef
  byte old
enddef
old = __color_std
__color_Std = clr_win[h]
dbclr( 0, r_win[h] +1,c_win[h], r1_win[h] + 1, c1_win[h] )
__color_Std = old 
ENDPRO

function logical w_say
parameters value uint h,value uint  X, value uint Y, value char saytext
 vardef
  byte old
  int slen
  char stext, work
 enddef
 work  = " "
 old = __color_std
 __color_std = clr_win[h]
 
 	X = X + r_win[h]
 	Y = Y + c_win[h] + 1
 
 	if Y >= r1_win[h]
 		Y = cur_y[h]
 	endif
 
 	if X >= r1_win[h]
 		X = cur_x[h]
 	endif
 
 	if len(SayText) >= c1_win[h] - Y
 		Do while len(SayText) > 1
 			sText = substr(SayText, 1, c1_win[h] - y)
 			sLen  = iifn(len(sText) = c1_win[h] - Y,rat(" ",sText),len(stext))
 			@ X + 1, Y say Substr(SayText, 1, sLen )
		SayText = Substr(SayText,sLen+1,sLen+1)
 			X = X + 1
 			if X >= r1_win[h]
 				return (.f.)
 			endif
 		Enddo
 		cur_x[h] = X
 		cur_y[h] = Y
 	else
 		@ X + 1,Y say saytext
 	endif
 __color_std = old
return (.t.)
 endpro


function logical w_header
parameters value uint h, value char msg, value int clr
vardef 
  byte old
  int  Y, Size
enddef
old = __color_std
__color_std = clr
header_win[h] = msg
w_head[h] = .t.
w_head_clr[h] =	clr
    y = c_win[h] + 1
	Size = len(msg)
	Size = (c1_win[h] - Y - Size)/2

	if Size < 0
		return .f.
	endif

	Y = Y + Size
  	@ r_win[h] , Y say msg

__color_std = old

Return .t.
endpro

function logical w_footer
parameters value uint h, value char msg, value int clr
vardef 
  byte old
  int  Y, Size
enddef
old = __color_std
__color_std = clr
footer_win[h] = msg
w_foot[h] = .t.
w_foot_clr[h] =	clr
    y = c_win[h] + 1
	Size = len(msg)
	Size = (c1_win[h] - Y - Size)/2

	if Size < 0
		return .f.
	endif

 Y = Y + Size
@ r1_win[h] , Y say msg
__color_std = old
Return .t.
ENDPRO

* I wanted a move, resize function all in one. That way, any modification
* could be done by the user.

procedure w_alter
parameters value uint h, value uint r, value uint c, value uint r1, value uint c1 
vardef 
  uint saved,old
enddef

old = w_back[h]		  && Saved background
r_win[h] = r		  && Give new value to positions
c_win[h] = c
r1_win[h] =	r1
c1_win[h] =	c1
restorescrn( old)	  && Restore old screen
w_back[h] = savescrn(r_win[h],c_win[h],r1_win[h],c1_win[h])

fill(r_win[h],c_win[h],r1_win[h],c1_win[h],; && Redraw window in new area
bord_win[h],fill_win[h],clr_win[h],clr_win[h], 0) 

if shad_win[h]
df_shadow(r_win[h],c_win[h],r1_win[h],c1_win[h])
endif

if w_foot[h] 
  w_footer(h,footer_win[h],w_foot_clr[h]) && Check if there is a footer
endif
if w_head[h] 
  w_header(h,header_win[h],w_head_clr[h]) && Check if there is a footer
endif
endpro

