*------------------------------------------------------------------------------
FUNCTION WaitForMe		&& this program waits until a windows program is done
PARAMETER dowhat
PRIVATE   dowhat, getwind, wclass, winname, pmhand, howquit, seconds, key
*------------------------------------------------------------------------------
* I needed to interface my Foxpro applicaton with a Electronic Data Interchange(EDI)
* program to translate a input file created by foxpro into a output EDI file. The 
* EDI file is then transfered using a communication package. These events must be 
* processed sequentially and I could not allow the programs to run in a multi-tasking
* mode. Therefore, this program was designed to wait until the external program 
* window is terminated before it allows the foxpro application to continue.
*-----
* The loop tests for the presence of the external window every 'n_sec' seconds.
* this does not place the computer in a continious loop and with the 'wait' statement
* provides some feedback to the user that at least something is hapening. Both external 
* applications are self terminating. When the window is no longer found the loop is broken.
*------------------------------------------------------------------------------
SET LIBRARY TO SYS(2004)+"foxtools.fll" ADDITIVE
m.dowhat = LOWER(ALLTRIM(m.dowhat))
DO CASE
	CASE m.dowhat = 'procomm'
		m.winname    = "PROCOMM PLUS for Windows"	&& name of the application window
		m.message = 'Waiting for ProComm to complete transmission.'
	CASE m.dowhat = 'mercator'
		m.winname    = "Mercator - NNG830.MMC"
		m.message = 'Waiting for Mercator to complete translation.'
	OTHERWISE
		RETURN .t.
ENDCASE

m.message = m.message +CHR(13)+ 'Press "Q" to Quit.' +CHR(13)+ 'Seconds = '
m.getwind = Regfn("FindWindow", "CC", "I")
m.wclass  = 0
m.pmhand  = 1
m.howquit = .f.		&& .f. = normal termination, .t. = user termination
m.seconds = 0		&& count the seconds that have passed & display to the user
m.n_sec   = 5		&& seconds to wait before testing the loop again
*----------------------------
DO WHILE m.pmhand <> 0		&& do while the Mercator window exists
	WAIT WINDOW m.message + ALLTRIM(STR(m.seconds)) TO m.key TIMEOUT m.n_sec
	m.seconds = m.seconds + m.n_sec
	IF UPPER(m.key) = 'Q'		&& exit loop on Q key
		m.howquit = .t.
		EXIT
	ENDIF
	m.pmhand = callfn(m.getwind, m.wclass, m.winname)
ENDDO
RELEASE LIBRARY SYS(2004)+"foxtools.fll"
*------------------------------------------------------------------------------
RETURN m.howquit		&& if .t., user quit the process.
*------------------------------------------------------------------------------
