SET TALK OFF
DEFINE WINDOW all FROM 3,6 TO 16,74
ACTIVATE window all
*******************************************************
*** A RETURN will get you out of this example because we 
*** passed a " " as v3.
DO waitdo WITH "C","Are you sure you want to display",;
                   "this very important file. I mean,",;
                   "what if it's contents are vital",;
                   "to national security? Y/<N> ",;
                   "Display readme?","","Y","N"," ",;
                   "modi file readme.txt","",""
*******************************************************                 
*** This window will appear in the upper left corner 
*** because of the UL passed as loc.                   
DO waitdo WITH "UL","Are you sure you're ready to",;
                    "see what the standard wait",;
                    "window looks like 1/<0>","",;
                    "View wait window?","","1","0"," ",;
                    "wait 'Now this is lame!' window","","" 
*******************************************************
*** A RETURN will not get you out of this example because
*** we did not pass a " " as v1,v2,or v3. It will appear
*** in the upper right corner because we passed a UR to loc.                  
DO waitdo WITH "UR","Which window would you like",;
                    "to see 1/2/3","","",;
                    "Choose a window!","","1","2","3",;
                    "wait 'Window number 1' window",;
                    "wait 'Window number 2' window",;
                    "wait 'Window number 3' window"                     
*******************************************************
Deactivate WINDOW all
CLEAR
CLEAR all
*******************************************************
PROCEDURE waitdo
PARAMETERS loc,t1,t2,t3,t4,hdr,ftr,v1,v2,v3,do1,do2,do3
PRIVATE loc,t1,t2,t3,hdr,ftr,v1,v2,v3,do1,do2,do3,ok,resp
* loc     - location is UR, UL, LL, LR, or C.
* t1-t4   - this is the text you want to appear.
* hdr     - optional header for the window
* ftr     - optional footer for the window
* v1-v3   - valid keypresses, send " " to accept a RETURN
* do1-do3 - actions that correspond to the valid keypresses
SET CURSOR OFF
   IF !EMPTY(t1)
       ts = 1
       maxt = LEN(t1)
   ENDIF
   IF !EMPTY(t2)
       ts = 2
       maxt = MAX(LEN(t1),LEN(t2))
   ENDIF
   IF !EMPTY(t3)
       ts = 3
       maxt = MAX(LEN(t1),LEN(t2),LEN(t3))
   ENDIF
   IF !EMPTY(t4)
       ts = 4
       maxt = MAX(LEN(t1),LEN(t2),LEN(t3),LEN(t4))
   ENDIF
  DO CASE
   CASE loc = "UL"
      startx = 0
      starty = 0
   CASE loc = "UR"
      startx = WCOLS() - (maxt + 2)
      starty = 0
   CASE loc = "C"
      startx = FLOOR((WCOLS() - 2) / 2 - (maxt / 2))
      starty = FLOOR((WROWS() - 2) / 2 - (ts / 2))
   CASE loc = "LL"
      startx = 1
      starty = WROWS() - (ts + 2)
   CASE loc = "LR"
      startx = WCOLS() - (maxt + 2)
      starty = WROWS() - (ts + 2)
 ENDCASE
 curwin = WOUTPUT()
 DEFINE WINDOW waitdo FROM starty,startx TO starty+ts+1,startx+maxt+1;
   IN &curwin TITLE hdr FOOTER ftr COLOR SCHEME 7
 ACTIVATE WINDOW waitdo
 IF !EMPTY(t1)
   @0,0 SAY t1
 ENDIF
 IF !EMPTY(t2)
   @1,0 SAY t2
 ENDIF
 IF !EMPTY(t3)
   @2,0 SAY t3
 ENDIF
 IF !EMPTY(t4)
   @3,0 SAY t4
 ENDIF
 resp = " "
 ok = 0
 DO WHILE ok <> 1
   @(ts -1),(maxt - 1) GET resp PICTURE "!" COLOR "GR+/R"
   READ
   IF INLIST(resp,v1,v2,v3)
     ok = 1
   ENDIF
 ENDDO
 DEACTIVATE WINDOW waitdo
 SET CURSOR ON
 DO CASE
  CASE !EMPTY(do1) AND resp = v1
      &do1
  CASE !EMPTY(do2) AND resp = v2
      &do2
  CASE !EMPTY(do3) AND resp = v3
      &do3
 ENDCASE
RETURN
