FUNCTION VStretch
*-------------------------------------------------------------------------------
*-- Programmer...: Martin Leon (HMAN -- Ashton Tate/Borland BBS)
*-- Date.........: 10/30/91
*-- Notes........: Used to display a long character field, with proper word wrap
*-- Written for..: dBASE IV, 1.1
*-- Rev. History.: Once upon a time, Martin helped me write a more complicated
*--                routine for use in a browse table. He came up with this
*--                much less complex version recently and sent to me via EMail.
*--                10/31/91 -- modified by me (KenMayer) for dUFLP
*-- Calls........: None
*-- Called by....: Any
*-- Usage........: ?VStretch(<cLFld>,<nULRow>,<nULCol>,<nBRRow>,<nBRCol>)
*-- Example......: ?VStretch(Notes,20,10,24,60,"rg+/gb")
*-- Returns......: ""  (Nul)
*-- Parameters...: cLFld  = Long Field to be wrapped on screen
*--                nULRow = Upper Left Row of window
*--                nULCol = Upper Left Column
*--                nBRRow = Bottom Right Row of window
*--                nBRCol = Bottom Right Column
*-------------------------------------------------------------------------------

	PARAMETER cLFld,nULRow,nULCol,nBRRow,nBRCol
	
	nWinWidth = ltrim(str((nBRCol - nULCol)-1,2))
	*-- define window without any border ...
	define window wStretch from nULRow,nULCol to nBRRow,nBRCol none
	activate window wStretch
	*-- make sure window is empty ...
	clear
	*-- display field
	?? cLFld picture "@V"+nWinWidth at 0  && the @V function causes word wrap
	save screen to sTemp
	activate screen
	release window wStretch
	restore screen from sTemp
	release screen sTemp

RETURN ""
*-- EoF: VStretch