*UAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA?
*3Program..........View.Prg                                 3
*3Author...........Kenneth C. Denson                        3
*3Date.............07 August 1994                           3
*3Notice...........* FREEWARE *                             3
*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
*3Purpose:                                                  3
*3 Allow file edit/viewing from within other applications.  3
*3 Option to use internal interface for multiple files      3
*3 or command line for single files.                        3
*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
*3Note:                                                     3
*3 Hidden and System files are not displayed or accessed.   3
*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
*3Syntax :                        3                         3
*3 Do View                        3 Uses built-in interface 3
*3 Do view With "<Path>\<File>"   3 Edit file named only    3
*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAU

PARAMETERS whatfile

Push Key Clear
*Push Menu _Msysmenu
*Set Sysmenu off


Private;
  mchoice,mtop,textfile,today,dowhat,m1,macterr,maction,;
  savtalk,savescape,savsafety
  
Savtalk = Set('Talk')
  Set Talk Off
Savescape = Set('Escape')
  Set Escape Off
Savsafety = Set('Safety')
  Set Safety Off

Store 1 to Mchoice
Store "" to TextFile,maction,dowhat,today

Save Screen To M1

=Today()
=Main()

FUNCTION Main
ON ERROR DO CHKERROR
IF EMPTY(WhatFile)   && No File Spec passed
*----Main Menu----*
Do While .T.
  Store Sys(5)+Sys(2003)+"\" To Mtop  && Default Directory
  Define Window MainMenu From 10,20 to 15,60 Double Shadow Color rb+/rb,rb+/rb,rb+/rb
  Activate Window MainMenu
  Set Color To BG+/RB,W+/B
  =Senter(0,"File Viewer Main Menu")
  Set Color To RB+/RB
  =Senter(1,""+mtop)
  Set Color To GR+/RB
  Set Color To GR+/RB,W+/B
  @  3, 1 Prompt "Edit File"
  @  3,17 Prompt "View File"
  @  3,34 Prompt "Quit"
  Choice=1
  Menu to Choice
  Do Case
    Case Choice = 1
      Release Window MainMenu
      dowhat  = ""
      maction = "Edit"
      =Gdir()
    Case Choice = 2
      Release Window MainMenu
      dowhat  = "NOEDIT"
      maction = "View"
      =Gdir()
    Case Choice = 3
      Exit
  EndCase
EndDo
ELSE                    && File Spec passed
  dowhat = ""
  maction = "Edit"
  TextFile = WhatFile
  =SeeRpt()
ENDIF
Release Window MainMenu
Restore Screen from M1
Set Talk &savtalk
Set Escape &savescape
Set Safety &savsafety
*Set Sysmenu On
*Pop Menu _Msysmenu
Pop Key
RETURN


*---Display Directory---*
FUNCTION GDir
*IF LASTKEY() <> 27
  Textfile = GetFile('*.*','Select File To '+maction,maction,2)
IF LASTKEY() <> 27
  =SeeRpt()
ENDIF
RETURN


*---Display Date in (Wed, January 01, 1994) format---*
FUNCTION TODAY
Today = CDOW(DATE())+", "+CMONTH(DATE())+" "+STR(DAY(DATE()),2);
            +", "+STR(YEAR(DATE()),4)
RETURN

*---Create/Open Window, Access File and Display It.---*
FUNCTION SEERPT
ON ERROR DO CHKERROR
ON KEY LABEL F1 DO SEEHLP
Macterr = Maction
Maction = "* "+maction+" * "+textfile
IF DoWhat = "NOEDIT"
  DEFINE WINDOW SeeRpt FROM 0,0 TO 24,79 PANEL COLOR "W/RB,W/RB,W/RB,GR+/W" ;
  TITLE ""+maction+space(7)+TODAY ;
  FOOTER "<>    <PgUp>    <PgDn>    <Esc> Exit"
  ON KEY LABEL F1 DO SEEHLP1
ELSE  
  DEFINE WINDOW SeeRpt FROM 0,0 TO 24,79 PANEL COLOR "W/RB,W/RB,W/RB,GR+/W" ;
  TITLE ""+maction+space(7)+TODAY ;
  FOOTER "<F1> Help    <>    <PgUp>    <PgDn>    <F10> Save    <Esc> Exit"
  ON KEY LABEL F1 DO SEEHLP
  ON KEY LABEL F10 KEYBOARD CHR(23)
ENDIF  
ACTIVATE WINDOW SeeRpt
SET COLOR TO W+/rb

*---To allow editing, remove the NoEdit Clause---*
MODIFY FILE &TextFile &DoWhat WINDOW SEERPT
RELEASE WINDOW SeeRpt
ON KEY LABEL F1
ON KEY LABEL F10
RETURN

FUNCTION CHKERROR
ON ERROR
DO CASE
  CASE ERROR() = 202   && Invalid Path or FileName
        Release Window SeeRpt
  		??chr(7)
        WhatFile = ""
        Wait "Invalid File Name or Path" Window NoWait
        =Main()
*        Textfile = GetFile('*.*','Select File To '+MACTERR,''+MACTERR,2)
*        MODIFY FILE &TextFile &DoWhat WINDOW SEERPT
  CASE ERROR() = 1705  && File Access Denied
        If Empty(WhatFile)
          Deactivate Window SeeRpt
          ??chr(7)
          Define Window ErrWin From 6,36 to 13,76 Double Shadow Color "Rb+/Rb,Rb+/Rb,Rb+/Rb,W+/Rb" ;
          Title "ACCESS DENIED" Footer "[Press Any Key]"
          Activate Window ErrWin
          Set Color to gr+/Rb
          @ 0,1 Say "Attribute    Type Access"
          Set Color to rb+/Rb
          @ 1,0 Say "AAAAAAAAA    AAAAAAAAAAA"
          Set Color to BG+/Rb
          @ 2,1 Say "    A        Read/Write"
          @ 3,1 Say "    S        None"
          @ 4,1 Say "    R        Read Only"
          @ 5,1 Say "    H        None"
          ??chr(7)
          Wait""
          Release Window ErrWin
        EndIf
ENDCASE
ON ERROR DO CHKERROR
RETURN


*---Center String on Screen/Window---*
PROCEDURE Senter
PARAMETERS LINE, MSG
IF PARAMETERS() = 1
        @ LINE, 0 CLEAR
        RETURN .T.
ENDIF
LENGTH = LEN(ALLTRIM(MSG))
WIDTH  = WCOLS()
IF LENGTH > WIDTH
        MSG    = LEFT(MSG, WCOLS())
        LENGTH = LEN(ALLTRIM(MSG))
ENDIF
START = (WIDTH/2)-(LENGTH/2)
@ LINE, START+1 SAY ALLTRIM(MSG)
RETURN .T.

FUNCTION SEEHLP
Define Window SeeHlp From 5,19 to 18,60 Shadow ;
Title "[Special Keys]" Footer "[Press Any Key to Exit]"
Activate Window SeeHlp
@ 1,1 Say "Highlight Text          <Shift> <Arrow>"
@ 2,1 Say "Select All              <Ctrl> <A>"
@ 3,1 Say "Copy Text               <Ctrl> <C>"
@ 4,1 Say "Paste Text              <Ctrl> <V>"
@ 5,1 Say "Find                    <Ctrl> <F>"
@ 6,1 Say "Top of File             <Ctrl> <Home>"
@ 7,1 Say "End of File             <Ctrl> <End>"
wait""
Release Window SeeHlp
RETURN

FUNCTION SEEHLP1
RETURN

