****************************************************************************
*
*	Program	:	T_VGRAPH.PRG
*
*	System	:	Vertical Bar Graph Test program
*
*	Date	:	December 1992
*	Author	:	Barry Glick
*
*	Comment	:	Sets up arrays of values and legends for testing the VGRAPH
* 				program
*
*	Example : 	DO T_vgraph
*
****************************************************************************
*	Mod Hist
*
*
Procedure T_vgraph

CLEAR
SET TALK OFF

DO SpecTest							&& Specific Test
DO SmallTest						&& Small value test
DO ValOnly							&& Simply passing one array of values

* The following will generate a random test each time run - you can
* comment out the line above and keep pressing CTRL-O (^O) to see 
* the way VGRAPH handles different numbers of bars and values

factor    = 10						&& Multiplier for size of values
num_elems = 0						&& Number of elements to plot

title     = "Random Test of Vertical Bar graphs"

= RAND(-1)							&& Seed the randomiser

DO WHILE num_elems < 2				&& Ensure that a least 2 bars
	num_elems = INT(RAND() * 70)	&& Will sometime select more than 72 elements
ENDDO	

DIMENSION valarray(num_elems), legarray(num_elems)

FOR i = 1 TO num_elems
	valarray(i) = RAND() * num_elems * factor
	legarray(i) = STR(i,2,0)
ENDFOR


*
* This is the call to the "vgraph" engine. There are only three things needed
* 1) the array containing the values to be graphed
* 2) the array containing the matching legends for the x-axis
* 3) the title to be placed at the top of the screen
*

DO vgraph WITH valarray,legarray,title

RELEASE ALL
RETURN								&& End of test program

*******************************************************************************

Procedure SpecTest
*  This will show how it can be used for graphing a specific series showing
*  some of the quirks and features

DIMENSION s_value(5), s_legend(5)

s_value(1) 	= 9999999
s_value(2) 	= 2500000
s_value(3) 	= 175
s_value(4) 	= 565000
s_value(5) 	= 1234567
s_legend(1)	= "Max Value"
s_legend(2) = "To big a label to fit"
s_legend(3) = "Small number"
s_legend(4) = "Sales"
s_legend(5) = "'92 Profit"

s_title     = "Specific Vgraph Test graph"

DO vgraph WITH s_value,s_legend,s_title

RELEASE s_value, s_legend, s_title

RETURN

*******************************************************************************

Procedure SmallTest
*  This will show how it can be used for graphing a series of small values 


DIMENSION s_value(7), s_legend(7)

s_value(1) 	= 0.025
s_value(2) 	= 1.012
s_value(3) 	= 0.03
s_value(4) 	= 0.0275
s_value(5) 	= 1.023
s_value(6)  = 0.7865
s_value(7)  = 0.0023
s_legend(1)	= "Jan"
s_legend(2) = "Feb"
s_legend(3) = "Mar"
s_legend(4) = "Apr"
s_legend(5) = "Jun"
s_legend(6) = "Jul"
s_legend(7) = "Aug"

s_title     = "VGraph Usage in 000's - 1993"

DO vgraph WITH s_value,s_legend,s_title

RELEASE s_value, s_legend, s_title

RETURN

*******************************************************************************

Procedure ValOnly
*  This shows that VGRAPH will work with only a value array


DIMENSION s_value(7), s_legend(7)

s_value(1) 	= 10.025
s_value(2) 	= 31.012
s_value(3) 	= 40.03
s_value(4) 	= 70.0275
s_value(5) 	= 21.023
s_value(6)  = 30.7865
s_value(7)  = 70.0023

DO vgraph WITH s_value

RELEASE s_value

RETURN