* Translation from Quickbasic to XBASE by Richard Ozer: 76237,123
* This is freeware (in celebration of July 4th! and July 14th!)

* This function accepts a string containing a credit card number and
* returns .T. or .F. depending on its validity. Dashes and spaces are
* accepted within the string, and are ignored. The last character must
* be a number, or the card will be rejected.
* This code is based on a checksum function found in the Cobb group forum.

PARAMETER theCardNum
PRIVATE isValid,checkSum,mult,i,theNumLen,theChar,theDigit,sumDigit
isValid=.f.
IF PARAMETERS()=0 OR LEN(theCardNum)<=1
  ** a one char string can inadvertantly return a correct result
  RETURN .f.
ENDIF
checkSum=0  && start with 0 for checksum
mult=2
** process from right to left
theCardNum=ALLTRIM(theCardNum)
IF ASC(RIGHT(theCardNum,1))<48 or ASC(RIGHT(theCardNum,1))>57
  ** last character must be a number
  RETURN .f.
ENDIF
theNumLen=-1*len(theCardNum)
** last character is ignored in the loop
FOR i=theNumLen+1 TO -1
  theChar=SUBST(theCardNum,(-1*i),1)
  IF ASC(theChar)<48 or ASC(theChar)>57
    IF theChar=' ' or theChar='-'
      ** ignore this character
    ELSE
      RETURN .F.
    ENDIF
  ELSE
    theDigit=VAL(theChar)
    theDigit=theDigit*mult
    mult=3-mult
    IF theDigit>9
      sumDigit=TRANS(theDigit,"99")
      theDigit=VAL(SUBST(sumDigit,1,1))+VAL(SUBST(sumDigit,2,1))
    ENDIF
    checkSum=checkSum+theDigit
  ENDIF
ENDFOR
**  see if the resulting checksum is equal to the last digit of the card
**  checksum = the next greater multiple of 10, minus the current checksum value
checksum=int((checksum+9)/10)*10-checksum
IF checksum=val(right(theCardNum,1))
  isValid=.t.
ENDIF
RETURN isValid
