
*********************************************************************      
*																	*
*																	*
*	Title															*	
*   -----														    *
*																	*
*   IS_TIME ()														* 
*																	*
*																	*
*																	*
*********************************************************************
*																	*
*																	*
*	When To Use It                                                  * 
*	--------------                                                  * 
*																	*
*	Whenever you need to verify that a particular character string	*
*	is a correct TIME string.										*
*																	*
*	Whenever you want to convert a "short" time string into a 		*
*	full length 8-character time string.							*
*																	*
*	Whenever you want to find out what time it will be in  x		*
*	minutes time, where x is a number between 0 and 59 minutes.		*
*																	*
*																	*
*********************************************************************     
*																	*
*																	*
*	What It Does                                                    *    
*	------------                                                    *
*																	*
*	This routine takes the character string that you supply, 		*
*	verifies that it is a valid TIME character string, and if		*
*	it is, it returns the equivalent full length 8-character time	*
*	string to the calling program.  The routine will accept time	*
*	strings in any of the following formats :						*
*																	*
*		1 or 2-character string  (HOURS)							*
*		--------------------------------							*
*		Such strings are assumed by the routine to be "hours" 		*
*		strings, e.g. "1", "3", "7", "22" will make the routine		*
*		return  " 1:00:00", " 3:00:00", " 7:00:00", and "22:00:00"	*
*		respectively to the calling program.   On the other hand, 	*
*		"33" which is an incorrect number of hours will make the	*
*		routine return a null string ("").							*
*																	*
*		2 or 3-character string  (:MINUTES)							*
*		-----------------------------------							*
*		This routine will accept character strings in the format	*
*		":x"  or  ":xx"  where x and xx indicate minutes.			*
*		For instance, ":2" and ":47" indicate respectively 			*
*		"2 minutes FROM NOW"  and  "47 minutes FROM NOW",  and if 	*
*		at the time of execution the time is  "23:20:01", the		*
*		routine will return  "23:22:01"  and  " 0:07:01"  			*
*		respectively to the calling program.						*
*																	*
*		4 or 5-character string  (HOURS:MINUTES)					*
*		----------------------------------------					*
*		This is the case where the calling programs provides a		*
*		time in the  "Hours:Minutes"  format, e.g.  "4:03", 		*
*		"22:00".   In other words, time strings which contain		*
*		just the one "embedded" colon (:) will always be assumed	*
*		by this routine to be  "Hours:Minutes"  time strings.  In	*
*		the above examples, the routine would return  " 4:03:00"	*
*		and  "22:00:00"  to the calling program.					*
*																	*
*		6-character string  (:MINUTES:SECONDS)						*
*		--------------------------------------						*
*		This is an extension to the  "Minutes from now"  format		*
*		seen above in that the calling program is also specifying	*
*		seconds, e.g.  ":30:17",  ":02:22"  will have the routine	*
*		interpret these strings as  "30 minutes and 17 seconds		*
*		FROM NOW"   and   "2 minutes and 22 seconds FROM NOW"		*
*		respectively.   So, for instance, if at the time of 		*
*		execution the time is "20:18:44",  the routine will return	*
*		"20:49:01"  and  "20:21:06"  respectively.					*
*																	*
*		7 or 8-character string  (HOURS:MINUTES:SECONDS)			*
*		------------------------------------------------			*
*		This is the full length time format, e.g.  "7:10:00", 		*
*		"20:22:22", etc....											*
*																	*
*																	*
*********************************************************************
*	                 											    *
*	                 											    *
*	How To Use It					              					*
*	-------------													*
* 																	*
* 																	*
*	<Character_Variable>  =  IS_TIME  ( C_TIME		,				*
*										L_SPACE		,				*
*										L_LOGICAL	,				*
*										L_SECONDS )					*
* 																	*
* 																	*
*																    *
*-------------------------------------------------------------------*
*																    *
*	If a time string is incorrect, i.e. more than 23 hours, or		*
*	more than 59 minutes or seconds, then the routine returns a		*
*	NULL string to the calling program  ("").						*
*																	*
*	If the time string is correct, the routine returns the full		*
*	length 8-character equivalent time string to the supplied time	*
*	string according to the rules detailed in the  WHAT IT DOES		*
*	section above.													*
*																    *
*-------------------------------------------------------------------*
*																    *
*	The above notwithstanding, if the  L_LOGICAL  parameter is set	*
*	to  TRUE,  the routine returns either  TRUE  or  FALSE  to		*
*	indicate that the supplied time string is a valid time string	*
*	or not.															*
*																    *
*-------------------------------------------------------------------*
*																    *
*																    *
*																    *
*	The Parameters													*				
*	--------------													*
*																    *					
*	C_TIME			-	The character time string that you want to	*
*						validate or convert.						*
*						If this parameter is not supplied, or is	*
*						supplied but is not of type  CHARACTER,		*
*						the routine returns a null string ("").		*
*																	*
*																	*
*	L_SPACE			-	By default, if the number of hours in a		*
*						valid time string is less than 10, the		*
*						8-character time string returned to the 	*
*						calling program will contain a leading 		*
*						space,  e.g.  " 7:30:00",  " 0:20:16".		*
*																	*
*						If you prefer your time strings to contain	*
*						a leading zero when the number of hours is	*
*						less than 10,   e.g.  "07:30:00"  and 		*
*						"00:20:16",  set this parameter to  FALSE.	*
*																	*
*						If this parameter is not supplied, or is 	*
*						supplied but is not of type  LOGICAL, the	*
*						routine sets it to  TRUE.					*
*																    *
*																    *
*	L_LOGICAL		-	In some cases you may wish to use this 		*
*						function purely as a  TRUE/FALSE  switch	*
*						in your program.  If that is the case, 		*
*						set this parameter to  TRUE  and the 		*
*						routine will return  TRUE  or  FALSE  to 	*
*						the calling	program instead of returning a 	*
*						null string ("") or a full length 			*
*						8-character	time string.					*
*																    *
*						If this OPTIONAL parameter is not supplied,	*
*						or is supplied but is not of type LOGICAL,	*
*						the routine sets it to  FALSE.				*
*																    *
*																    *
*	L_SECONDS		-	Set this optional parameter to  FALSE  if	*
*						you want the routine to return you a time	*
*						string that does NOT include the number of	*
*						seconds.  E.g. if this parameter is set to	*
*						FALSE, instead of returning  "10:23:59"  	*
*						the routine will return  "10:23",  instead	*
*						of returning  " 7:40:00" it will return		*
*						" 7:40"  to the calling program, etc ....	*
*																    *
*						If this OPTIONAL parameter is not supplied,	*
*						of is supplied but is not of type LOGICAL,	*
*						the routine defaults it to  TRUE  (in other	*
*						words, the seconds will be returned).		*
*																    *
*						This parameter is ignored if  L_LOGICAL		*
*						is set to  TRUE.							*
*																    *
*																    *
*********************************************************************	
*																	*		
*                                                                   *  
*   History															*
*   -------														    *
*																	*
*   Michel Creppy :		23-May-93.									*
*																	*
*	Michel Creppy :		24-May-93.    Added the  L_LOGICAL  para-	*
*									  meter.						*
*																	*
*	Michel Creppy :		 4-Jul-93.    Added the  L_SECONDS  para-	*
*									  meter.						*
*	                 											    *
*                                                                   *
*********************************************************************
*	(C) Copyright 1993 by Le Software Man Ltd., London, England.	*
*********************************************************************







FUNCTION  IS_TIME
*----------------


PARAMETERS  T_TIME,  L_SPACE,  L_LOGICAL,  L_SECONDS


PRIVATE		N_COLONS,   N_LENGTH,	 N_MINUTES,  N_MINS_NOW,  N_HOURSNOW
PRIVATE		N_SECONDS,  N_SECS_NOW
PRIVATE		C_TIME,	    C_PAD_CHAR,  C_TIME_NOW
PRIVATE		L_SPACE,	L_LOGICAL,   L_SECONDS
PRIVATE		T_TIME


C_TIME_NOW  =  TIME()
C_TIME		=  ""
L_LOGICAL	=  IIF((PARAMETERS() > 2  .AND.  TYPE("L_LOGICAL") = "L"), L_LOGICAL, .F.)
L_SECONDS	=  IIF((PARAMETERS() > 3  .AND.  TYPE("L_SECONDS") = "L"), L_SECONDS, .T.)


IF  (PARAMETERS() > 0  .AND.  TYPE("T_TIME") = "C")
	T_TIME		=  ALLTRIM(T_TIME)
	C_PAD_CHAR  =  IIF((PARAMETERS() > 1  .AND.  TYPE("L_SPACE") = "L" 	;
										  .AND.  L_SPACE = .F.), "0", " ")
	
	IF  .NOT. EMPTY(T_TIME)
		N_LENGTH  =  LEN(T_TIME)
		N_COLONS  =  OCCURS(":", T_TIME)
		

		DO CASE

			CASE  (N_COLONS = 0  .AND.  N_LENGTH < 3)
				IF  (ISDIGIT(T_TIME)  .AND.  ISDIGIT(RIGHT(T_TIME, 1))		;
									  .AND.  VAL(T_TIME) < 24)
					C_TIME  =  PADL(INT(VAL(T_TIME)), 2, C_PAD_CHAR) + ":00:00"
				ENDIF


			CASE  (N_COLONS = 1  .AND.  BETWEEN(N_LENGTH, 2, 5))
				IF  N_LENGTH  <  4
					IF  LEFT(T_TIME, 1)  ==  ":"
						IF  (ISDIGIT(SUBSTR(T_TIME, 2, 1)) .AND. ISDIGIT(RIGHT(T_TIME, 1)) ;
											.AND. VAL(SUBSTR(T_TIME, 2)) < 60)
							N_MINUTES	=  VAL(SUBSTR(T_TIME, 2))
							N_MINS_NOW	=  VAL(SUBSTR(C_TIME_NOW, 4, 2))
							N_HOURSNOW	=  VAL(LEFT(C_TIME_NOW, 2))
							N_MINUTES	=  N_MINUTES + N_MINS_NOW
							
							IF  N_MINUTES  >  59
								N_HOURSNOW  =  N_HOURSNOW + 1
								N_HOURSNOW  =  IIF((N_HOURSNOW > 23), 0, N_HOURSNOW)
								N_MINUTES	=  N_MINUTES - 60
							ENDIF
							
							C_TIME  =  PADL(INT(N_HOURSNOW), 2, C_PAD_CHAR) + ":" 		;
												+ PADL(INT(N_MINUTES), 2, "0")			;
												+ RIGHT(C_TIME_NOW, 3)
						ENDIF
					ENDIF
				ELSE
					IF  SUBSTR(T_TIME, (N_LENGTH - 2), 1)  ==  ":"
						IF  (ISDIGIT(RIGHT(T_TIME, 1))  .AND.  ISDIGIT(RIGHT(T_TIME, 2))  ;
														.AND.  ISDIGIT(RIGHT(T_TIME, 4))  ;
														.AND.  ISDIGIT(LEFT(T_TIME, 1)))
							IF  (VAL(LEFT(T_TIME, (N_LENGTH - 3))) < 24					  ;
										.AND.  VAL(RIGHT(T_TIME, 2)) < 60)
								C_TIME  =  PADL(T_TIME, 5, C_PAD_CHAR) + ":00"
								
								IF  LEFT(C_TIME, 1)  ==  "0"
									C_TIME  =  C_PAD_CHAR + RIGHT(C_TIME, 7)
								ENDIF
							ENDIF
						ENDIF
					ENDIF
				ENDIF


			CASE  (N_COLONS = 2  .AND.  BETWEEN(N_LENGTH, 6, 8))
				IF  (LEFT(T_TIME, 1) == ":"  .AND.  N_LENGTH = 6)
					IF  (ISDIGIT(SUBSTR(T_TIME, 2, 1)) .AND. ISDIGIT(RIGHT(T_TIME, 4)) 		;
										.AND.  VAL(SUBSTR(T_TIME, 2, 2)) < 60				;
										.AND.  ISDIGIT(RIGHT(T_TIME, 2))					;
										.AND.  ISDIGIT(RIGHT(T_TIME, 1))					;
										.AND.  VAL(RIGHT(T_TIME, 2)) < 60)
						N_MINUTES	=  VAL(SUBSTR(T_TIME, 2, 2))
						N_SECONDS	=  VAL(RIGHT(T_TIME, 2))
						N_SECS_NOW	=  VAL(RIGHT(C_TIME_NOW, 2))
						N_MINS_NOW	=  VAL(SUBSTR(C_TIME_NOW, 4, 2))
						N_HOURSNOW	=  VAL(LEFT(C_TIME_NOW, 2))
						N_SECONDS	=  N_SECONDS + N_SECS_NOW
						N_MINUTES	=  N_MINUTES + N_MINS_NOW
							
						IF  N_SECONDS  >  59
							N_MINUTES  =  N_MINUTES + 1
							N_SECONDS  =  N_SECONDS - 60
						ENDIF
						
						IF  N_MINUTES  >  59
							N_HOURSNOW  =  N_HOURSNOW + 1
							N_HOURSNOW  =  IIF((N_HOURSNOW > 23), 0, N_HOURSNOW)
							N_MINUTES	=  N_MINUTES - 60
						ENDIF
							
						C_TIME  =  PADL(INT(N_HOURSNOW), 2, C_PAD_CHAR) + ":" 		;
											+ PADL(INT(N_MINUTES), 2, "0") + ":"	;
											+ PADL(INT(N_SECONDS), 2, "0")
					ENDIF

				ELSE
					IF  (SUBSTR(T_TIME, (N_LENGTH - 2), 1)  ==  ":"		;
							.AND.  SUBSTR(T_TIME, (N_LENGTH - 5), 1)  ==  ":")
						IF  (ISDIGIT(T_TIME)  .AND.  ISDIGIT(RIGHT(T_TIME, 1))	;
											  .AND.  ISDIGIT(RIGHT(T_TIME, 2))	;
											  .AND.  ISDIGIT(RIGHT(T_TIME, 4))	;
											  .AND.  ISDIGIT(RIGHT(T_TIME, 5))	;
											  .AND.  ISDIGIT(RIGHT(T_TIME, 7)))
							IF  (VAL(LEFT(T_TIME, (N_LENGTH - 6))) < 24						;
										.AND.  VAL(RIGHT(T_TIME, 2)) < 60					;
										.AND.  VAL(SUBSTR(T_TIME, (N_LENGTH - 4), 2)) < 60)
								C_TIME  =  PADL(T_TIME, 8, C_PAD_CHAR)
								
								IF  LEFT(C_TIME, 1)  ==  "0"
									C_TIME  =  C_PAD_CHAR + RIGHT(T_TIME, 7)
								ENDIF
							ENDIF
						ENDIF
					ENDIF
				ENDIF
		ENDCASE
	ENDIF
ENDIF



IF  (L_SECONDS = .F.  .AND.  .NOT. EMPTY(C_TIME))
	C_TIME  =  LEFT(C_TIME, 5)
ENDIF

IF  L_LOGICAL  =  .T.
	C_TIME  =  IIF(EMPTY(C_TIME), .F., .T.)
ENDIF



RETURN  (C_TIME)


*********************************************************************      
*********************************************************************      
