* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program....: Example.Prg
* Description: Just some code to setup for the call to LOADDIRS.PRG
* Programmer.: George Gartner
* Location...: Weiss Research, Inc.
*            : 2200 N. Florida Mango Rd.
*            : West Palm Beach, FL 33415  (407)684-8100 Ext. 145
* Notes......: We needed a routine that would scan a given drive and
*            : populate a database with it's directory structure. 
*            : Several attempts, by other programmers, produced code
*            : that was full of arrays, pointers, counters and several
*            : ridiculously complicated steps.  This is my attempt at
*            : a method that is much shorter and more simplistic.
*            : 
*            : This utility can be used as you see fit.  It's unlikely
*            : it will work "as is" for your specific needs, but it 
*            : *will* work to demonstrate the logic.  If you have a 
*            : need similar to ours, please feel free to change this
*            : code any way you want.  It's freeware!
*            : 
*            : (P.S. Anyone looking for a FoxPro programmer?)
*            : 
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Close All
Clea All
Clea

Set Talk Off
Set Safe Off

If !File("DIRDATA.DBF")
	Create Table DirData (DirPath C(100))
Else
	Use DirData
	Zap
Endi

Declare Dirs[1]
Do LoadDirs With "E:"

CurRec   = 1
Do Whil !Eof()
	mTemp = AllTrim(DirPath)
	Wait Window mTemp NoWait
	Do LoadDirs With mTemp
	Go CurRec
	Skip
	Do Whil At("\.",DirPath) > 0
		Skip
	Endd
	CurRec = Recno()
Endd

Dele All For At("\.",DirPath) > 0
Pack
Index On DirPath To Temp
Brow


Procedure LoadDirs
Parameters Drive

* Because DOS allows you to create directories that include up to a
* three character extension, a "\*.*" is used in this ADIR call.
* You can save memory here by using "\*." instead, *if* you know you 
* wont have subdirectory names like this.
*
=ADir(Dirs,Drive+"\*.*","D")
*=ADir(Dirs,Drive+"\*.","D")
Num = ALen(Dirs)/5
For I = 1 To Num
	If At("D",Dirs[I,5]) > 0 And At("\.",Dirs[I,1]) = 0
		Append Blank
		Replace DirPath With Drive+"\"+Dirs[I,1]
	Endi
Next

