* Program.....:	TimeFunc.PRG
* Author......: Charles Miedzinski
* Version.....: dBASE IV 1.1, 1.5
* Description.: A library of time-calculating functions.
*
FUNCTION Ampm
* Ampm()   Syntax:  Ampm( <hh:mm [:ss]> )
*          Returns: time string (hh:mm [:ss]) in A.M./P.M. format (char)
PARAMETERS am_pm
RETURN IIF(MOD(VAL(am_pm), 12) = VAL(am_pm), ;
	IIF(VAL(am_pm) = 0, ;
	"12" + RIGHT(am_pm, LEN(am_pm) - 2) + "am", ;
	STR(VAL(am_pm), 2) + RIGHT(am_pm, LEN(am_pm) - 2) + "am"), ;
	 IIF(MOD(VAL(am_pm), 12) = 0, ;
	STR(VAL(am_pm), 2) + RIGHT(am_pm, LEN(am_pm) - 2) + "pm", ;
	STR(INT(MOD(VAL(am_pm), 12)), 2) + RIGHT(am_pm, LEN(am_pm) - 2) + "pm"))

*
FUNCTION Ck_ampm
* CK_AMPM()  Snytax:  [VALID]  Ck_ampm( <hh:mm [:ss] a/pm> )
*            Returns: Isampm() with error message
	PARAMETERS isok
	IF .NOT. Isampm(isok)
		@23,0 SAY Center("Time must be entered in AM / PM format", 80)
  	mwarn = Warn(30, 19)
	ENDIF
	RETURN Isampm(isok)

*
FUNCTION Elapsed
	* ELAPSED()  Syntax: Elapsed( <num1> , <num2> )
	*                    num1 = <start time in seconds>
	*                    num2 = <stop time in seconds> )
	*            Returns: the calculated elapsed time in numberic seconds.
	*            Operates within any 24 hour time frame.
	PARAMETERS start_secs, stop_secs
RETURN IIF(stop_secs < start_secs, stop_secs + 86400, stop_secs) - start_secs

*
FUNCTION Isampm
* Isampm()   Syntax: [VALID] Isampm( <hh:mm [:ss] a/pm> )
*	           Returns: validation of time string in A.M./P.M. format
	PARAMETERS timestr
RETURN IIF(VAL(LEFT(timestr, 2)) > = 1 .AND. VAL(LEFT(timestr, 2)) < = 12, ;
	 IIF(VAL(SUBSTR(timestr, 4, 2)) > = 0 .AND. VAL(SUBSTR(timestr, 4, 2)) < = 59, ;
	 IIF(SUBSTR(timestr, 6, 1) $ 'aApP', .T., ;
	 IIF(VAL(SUBSTR(timestr, 6, 2)) > = 0 .AND. VAL(SUBSTR(timestr, 6, 2)) < = 59, ;
	 .T., .F.)), .F.), .F.)

*
FUNCTION Mpma
* Mpma()     Syntax: Mpma( <hh:mm [:ss] a/pm> )    && Opposite of Ampm()
*            Returns: hh:mm [:ss] from 7 or 10 byte AMPM time string.
	PARAMETERS Mp_ma
RETURN RIGHT("00" + LTRIM(STR(MOD(VAL(LEFT(mp_ma, 2)), 12) + ;
IIF("a" $ mp_ma .OR."A"$ mp_ma, 0, 12), 2)), 2) + ;
 SUBSTR(mp_ma, 3, IIF(LEN(TRIM(mp_ma)) > 7, 6, 3))

*
FUNCTION Stot
* Stot()     Syntax: Stot( <num> )     && Seconds_TO_Time
*            Returns: time string (hh:mm;ss) from seconds
*            Note: use LEFT(Stot(<num>),5) to display hh:mm only

	PARAMETERS secs
RETURN RIGHT("00" + LTRIM(STR(INT(secs / 3600))), 2) + ":" + ;
   RIGHT("00" + LTRIM(STR(INT(MOD(secs, 3600) / 60))), 2) + ":" + ;
   RIGHT("00" + LTRIM(STR(INT(MOD(MOD(secs, 3600), 60)))), 2)

*
FUNCTION Ttos
* Ttos()     Syntax: TTOS( <hh:mm [:ss]> )   && Time_TO_Seconds
*            Returns: numeric seconds from time string
	PARAMETERS m_seconds
RETURN INT((3600 * VAL(m_seconds) + 60 * VAL(SUBSTR(m_seconds, 4, 2))) + ;
	IIF(LEN(m_seconds) > 5, VAL(RIGHT(m_seconds, 2)), 0))


***** Utility Functions  ******
* Called from TIME FUNCTIONS
FUNCTION Center
* Center()    Syntax: @row,col SAY Center( <string>,n)
*             Returns: string centered in n
	PARAMETER string, length
RETURN (STUFF(SPACE(length), (length - LEN(string)) / 2, LEN(string), string))

FUNCTION Warn
* WARN()      Syntax: mvar = Warn(<freq>, <duration>)
*
	PARAMETERS freq, duration
	SET BELL TO freq, duration
	@24,0 SAY CHR(7)
RETURN ""
* EOF: TimeFunc.PRG

The program below is cut from a inter-active time card applacation and
demonstrates the use of the TimeFunc.PRG library. 

* Program.....:	Time().prg
* Author......: Charles Miedzinski
* Version.....: dBASE IV 1.1, 1.5
* Description.: Program to test and demonstrate TIME FUNCTIONS

SET SCOREBOARD OFF
SET COLOR TO w/b
SET TALK OFF
SET CLOCK OFF
SET STATUS OFF
SET LIBRARY TO TimeFunc
CLEAR
SET CLOCK TO 08,59
*-
@ 7,6 SAY 'ͻ'
@ 8,6 SAY ' '+DTOC(DATE())+'             T I M E   C A R D                          '
@ 9,6 SAY '                                                                 '
@10,6 SAY ' Employee Number: 0034            Department: Sales              '
@11,6 SAY '                                                                 '
@12,6 SAY ' First: Joe          Last: User              SSN: 123-12-1234    '
@13,6 SAY 'Ķ'
@14,6 SAY '     Time In     Time Out     Time      Remarks                  '
@15,6 SAY '           m           m                                         '
@16,6 SAY '                                                                 '
@17,6 SAY '                                                                 '
@18,6 SAY '                                                                 '
@19,6 SAY '                                                                 '
@20,6 SAY '                  Total Time:    hours,    minutes               '
@21,6 SAY 'ͼ'
*-
*- Time is stored in the dbf as hhmm. Typically it appears as:
s_time = LEFT(TIME(), 2) + SUBSTR(TIME(), 4, 2)
e_time = LEFT(TIME(), 2) + SUBSTR(TIME(), 4, 2)
*-
*-
*- We need to convert the information in the dbf to an AM/PM format:
stime = Ampm(LEFT(s_time, 2) + ":" + RIGHT(s_time, 2) )
etime = Ampm(LEFT(e_time, 2) + ":" + RIGHT(e_time, 2) )
*-
@ 05,0 SAY Center("Press <ESC> key to EXIT", 80)
DO WHILE LASTKEY() # 27
	@ 15,12 GET stime PICTURE "99:99A" VALID Ck_ampm(stime)
	@ 15,24 GET etime PICTURE "99:99A" VALID Ck_ampm(etime)
	READ
	@ 23,0
	@ 15,37 SAY Stot(Elapsed(TTOS(Mpma(stime)), Ttos(Mpma(etime))))
	@ 16,15 SAY "start time seconds      : " + LTRIM(STR(Ttos(Mpma(stime))))
	@ 17,15 SAY "end time seconds        : " + LTRIM(STR(Ttos(Mpma(etime))))
	@ 18,15 SAY "start seconds to string : " + Stot(Ttos(Mpma(stime)))
	@19,15 SAY "end seconds to string   : " + STOT(TTOS(MPMA(etime)))
	log_tot = Elapsed(Ttos(Mpma(stime)), Ttos(Mpma(etime)))
	@ 20,37 SAY RIGHT(" "+LTRIM(STR(INT(log_tot / 3600))), 2)
	@ 20,47 SAY RIGHT(" "+LTRIM(STR(INT(MOD(log_tot, 3600) / 60))), 2)
ENDDO
*-
SET SCOREBOARD ON
SET CLOCK OFF
SET STAT ON
SET TALK ON
CLEAR ALL
CLEAR
RETURN

