* Procedure UPDTHERM by Michael Mostov, 1993
* Updates thermometer window, that was created with INITHERM.PRG
* Returns empty string.
*
* The rate at which thermometer is refreshed determined by setting of FP
* SET ODOMETER command.
*
* Parameters: m.text - String to be displayed on the second line of the 
*                      Thermometer window. (optional)
*             	       If omitted, defaults to: str(RecsDone/RecsToDo)
* Examles of USAGE:
* 1) Expression UPDTHERM([<expC>]) can be placed as a field in the Detail band
*    of the report.
* 2) DO updtherm([<expC>]) could be included in the SCAN loop.
* 3) REPLACE FOR empty(updtherm([<expC>]))  [replace commands]
***************************************************************************

PARAMETER m.text
	mparm = PARAMETERS()

If type("lnRecsDone") = "U" 
	WAIT WINDOW NOWAIT "Thermometer has to be initialized first!"
	return
endif

lnRecsDone = lnRecsDone + 1
IF lnRecsDone = lnRecsToDO  && If all records were processed - Release Thermometer
	do stoptherm in initherm
	RETURN ""
ENDIF

if lnRecsDone-lnLastRecord < set("odometer")  && Check SET ODOMETER value
	return ""
else
	lnLastRecord = lnRecsDone
endif


IF mparm = 0  && Default text.
	m.text = alltrim(str(lnRecsDone))+"/"+alltrim(str(lnRecsTodo))
ENDIF

PRIVATE m.nblocks, m.percent, mparm

ACTIVATE WINDOW thermomete

m.percent = lnRecsDone/lnRecsTodo

m.nblocks = min(int((m.percent) * (lcThermwidth)),100)

IF _Windows
	@ 1.5,3 SAY m.text FONT c_dlgface, c_dlgsize STYLE c_dlgstyle
	@ 3.000,3.333 TO 4.231,m.nblocks + 3.333 ;
		PATTERN 1 COLOR RGB(128, 128, 128, 128, 128, 128)
ELSE
	@ 1,3 SAY m.text
	@ 3,3 SAY REPLICATE("",m.nblocks)
ENDIF

RETURN ""

