************************************************************
* Name:      TCAL_NEW.PRG
* Desc:      A popup calendar program.  User can change
*            the month or year by pressing the PgUp, PgDn,
*            + , -
*
*            INSERT KEY will toggle a selected day ON or OFF.
*
*            RIGHT ARROW KEY ->  will advance calendar through days
*
* Author:    Todd W. Lindley  - Modified by A. Frazier                              *
* Created:   3/12/91          - Modified 11/1991
* Version:   1.0
* Revisions: 3/91 - fixed display of dates past 12/1999.
*                 - Made all variables private so that
*                   they don't conflict with the calling
*                   program.
*
*       MODIFICATIONS MADE ON 11/1991:
*
*                   Removed the calander size and location variables.
*                   Added the ability to select a day by using the
*                   Insert Key and Right Arrow Key
*
*                   The selected data base will force all matching dates
*                   to display in red, and will be added to or deleted
*                   from when dates are selected or de-deselected.
*
*
* Usage:     DO TCAL_NEW WITH "<file_name>","<date_field_name>",date
*
*        Where:  file_name = a Dbase File containing dates.  Days matching
*                            dates in the specified field name will display
*                            in red on the calander.   If a day is toggled
*                            ON or OFF by using the insert key, and
*                            a record will be appended to the file <ON>
*                            or deleted <OFF>.
*
*                date_field_name = Must be a indexed field in the specified
*                                  data base file.
*
*               DATE =  DATE() or CTOD("DATE")
*
*
*            Ex: DO TCAL WITH "DATEFILE", "IN_DATE", DATE()
*            Results: Displays a popup calendar at screen
*                     coordinates 2,2 in large format
*                     with the calendar displaying the
*                     month and year of system date.
*                     Access the data base file DATEFILE and displays
*                     in red all calandar dates which match the field IN_DATE
*                     in the data base.
*
*
*            Ex: DO TCAL WITH "DATEFILE","IN_DATE",CTOD("01/01/90")
*            Results: displays a popup calendar at screen
*                     coordinates 2,2 calendar displaying January 1990
*                     Access the data base file DATEFILE and displays
*                     in red all calandar dates which match the field IN_DATE
*                     in the data base.
*
* Notes:
*      - The program does not check the validity of
*        any parameters
*      - I have randomly checked some month/year combina-
*        tions and the calendars seem to be correct.
*
*      - The Data Base file must exist, and be indexed on the Date Field
*        which must be a format of DATE.
*
*
* Credits:
*
*      - I needed a calendar function in a Reservation System I was
*        developing which would allow the user to select reserved dates by
*        a 'point & shoot' method.  I liked the TCAL program, but
*        needed to select days.  Therefore, the modifications.

*      - I'd like to thank Todd W. Lindley, the author of TCAL.prg for
*        allowing(?) me to expand(?) on his concept.
*
************************************************************


*---sample calling code, DB file TEST_DTE must exist and have an
*                        index tag date field named SEL_DATE
*                        This file will be modified depending on the
*                        dates selected by the user.

SET STATUS OFF
SET TALK OFF
CLEAR
TDATE = DATE()
@ 10,10 SAY "ENTER DATE:  " GET TDATE
READ
CLEAR
DO TCAL_NEW WITH "TEST_DTE","SEL_DATE",TDATE
RETURN




*PROCEDURE

PROCEDURE TCAL_NEW
    PARAMETERS FILE_NAME,FIELD_NAME,TDATE

USE (FILE_NAME) ORDER &FIELD_NAME.
ESC_STAT=SET("ESCAPE")
TALK_STAT=SET("TALK")
ATTR_STAT=SET("ATTRIBUTES")

SAVE SCREEN TO TCALSCRN
PRIVATE ALL
  STORE 0 TO MONTH,YEAR,DAY,FIRSTDAY,LASTDAY,SKIP_COLS,LAST_COL,COL,ROW,S_COL
  STORE 0 TO CURR,NEXT,X,MONTHN,LAST_ROW,INFO_ROW,S_ROW,E_ROW,S1_COL
  STORE 0 TO SVE_DTE
  STORE 1 TO YY
  STORE " " TO FOUND_SW

START_ROW = 2
START_COL = 10


SET DELETED ON
SET ESCAPE OFF
SET COLOR OF NORMAL TO N/W
DO init
DO grid
DO calc
DO refresh
S_ROW = START_ROW+ 3
SVE_DTE = 0


* ---- MAIN LOOP - READS KEYBOARD ----------------------------

SET COLOR OF NORMAL TO B+/W
@ S_ROW,S_COL SAY " 1"
SET COLOR OF NORMAL TO N/W
YY = 1

DO WHILE .T.
  KEY=INKEY()
  DO CASE

    *  ----- escape key ---------------
    CASE key=27
      EXIT


    *  ----- insert key toggle----------
    case key = 22
      NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
      SEEK NEW_DATE
      IF  FOUND()
          FOUND_SW = "Y"
          SET COLOR OF NORMAL TO N/W
          DELETE
          ELSE
              FOUND_SW = "N"
              SET COLOR OF NORMAL TO R+/W
              ENDIF

      @ S_ROW,S_COL SAY STR(YY,2,0)
      SET COLOR OF NORMAL TO N/W
      IF FOUND_SW = "N"
          NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
          SVE_DTE = YY
          SET ORDER TO
          APPEND BLANK
          REPLACE &FIELD_NAME. WITH NEW_DATE
          SET ORDER TO TAG &FIELD_NAME.
          ENDIF


    *  ----- right arrow---------------
    CASE key=4
      NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
      SEEK NEW_DATE
      IF  FOUND()
          SET COLOR OF NORMAL TO R+/W
          ELSE
              SET COLOR OF NORMAL TO N/W
              ENDIF

      @ S_ROW,S_COL SAY STR(YY,2,0)
      SET COLOR OF NORMAL TO B+/W
      S_COL = S_COL+ SKIP_COLS

      YY = YY+1
          IF S_COL>LAST_COL
               S_COL=START_COL+3
               S_ROW=S_ROW+2

               IF S_ROW > E_ROW
                  S_ROW = START_ROW + 3
                  S_COL = S1_COL
                  YY = 1
                  ENDIF
          ENDIF

      IF YY > LASTDAY
         S_ROW = START_ROW+3
         S_COL = S1_COL
         YY = 1
         ENDIF

      NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(YY,2,0)+"/"+STR(YEAR,4,0))
      SEEK NEW_DATE
      IF  FOUND()
          SET COLOR OF NORMAL TO R/W
          ELSE
              SET COLOR OF NORMAL TO b+/W
              ENDIF

      @ S_ROW,S_COL SAY STR(YY,2,0)
      SET COLOR OF NORMAL TO N/W


    *  ----- page up next MONTH----------
    CASE key=18
      MONTH=MONTH+1
      IF MONTH>12
        MONTH=1
        YEAR=YEAR+1
      ENDIF
      DO calc
      DO refresh


    *  ----- page down previous MONTH---------------
    CASE key=3
      MONTH=MONTH-1
      IF MONTH<1
        MONTH=12
        YEAR=YEAR-1
      ENDIF
      DO calc
      DO refresh

    *  ----- + key next year ---------------
    CASE key=43
      YEAR=YEAR+1
      IF YEAR<0
        YEAR=1
      ENDIF
      DO calc
      DO refresh

    *  ----- - key previous year ---------------
    CASE key=45
      YEAR=YEAR-1
      DO calc
      DO refresh
  ENDCASE

ENDDO
SET COLOR OF NORMAL TO R/W
@last_row+1,start_col SAY "     UPDATING DATA BASE RECORDS...  "
@last_row+2,start_col SAY "                                    "
SET DELETED OFF
PACK
USE
SET ESCAPE &esc_stat
SET TALK &talk_stat
SET COLOR TO &attr_stat
RESTORE SCREEN FROM tcalscrn
RETURN


* --- procedure to refresh screen -------------

PROCEDURE refresh
yy = 1
x=1
row=start_row+3
@info_row,start_col+1 CLEAR TO info_row,start_col+skip_cols*6
@info_row,start_col SAY monthn COLOR W+/W
@info_row,last_col-3 SAY STR(year,4,0) COLOR W+/W
DO clear_grid
S_ROW = ROW
S1_COL = COL

DO WHILE x <= lastday
      NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(x,2,0)+"/"+STR(YEAR,4,0))
      SEEK NEW_DATE
      IF  FOUND()
          SET COLOR OF NORMAL TO R+/W
          ELSE
              SET COLOR OF NORMAL TO N/W
              ENDIF

  @ROW,COL SAY STR(x,2,0)
  COL=COL+SKIP_COLS
  IF COL > LAST_COL
       COL=START_COL+3
       ROW=ROW+2
       ENDIF
X=X+1
ENDDO

E_ROW  = ROW
NEW_DATE = CTOD(STR(MONTH,2,0)+"/"+STR(1,2,0)+"/"+STR(YEAR,4,0))
      SEEK NEW_DATE
      IF  FOUND()
          SET COLOR OF NORMAL TO R/W
          ELSE
              SET COLOR OF NORMAL TO b+/W
              ENDIF
@ S_ROW,S_COL SAY " 1"
RETURN


* --- initial set up procedure  -------------

PROCEDURE init
  month=month(tdate)
  year=YEAR(tdate)
  day=DAY(tdate)
RETURN



* --- procedure to calculate days of the month ---------

PROCEDURE calc
 ** GET MONTH NAME
  monthn=CMONTH(CTOD(STR(month,2,0)+"/01/91"))

 ** CALCULATE 1ST OF MONTH AND BEGINNING OF NEXT MONTH
  beg=CTOD(STR(month,2,0)+"/"+"01/"+STR(year,4,0))
  next=CTOD(STR(month+1,2,0)+"/"+"01/"+STR(year,4,0))

 ** CALCULATE # OF DAYS IN MONTH
  firstday=DOW(beg)
  lastday=next-beg

 ** STARTING DISPLAY COLUMN OF 1ST DAY OF MONTH

    col=skip_cols*(firstday-1)+start_col+3
    s_col = col

RETURN



* --- procedure to rebuild grid -------------

PROCEDURE grid
** EACH @ SAY WAS HARD CODED FOR SPEED IN DRAWING THE GRID.
** A DO WHILE COULD HAVE BEEN USED BUT WOULD HAVE BEEN TOO SLOW.
  skip_cols=5
  last_col=start_col+skip_cols*6+5
  last_row=start_row+14
  info_row=start_row-1

  @start_row-1,start_col-1 CLEAR TO last_row+2,last_col+1
  @start_row+1,start_col+2 SAY "Sun  Mon  Tue  Wed  Thu  Fri  Sat"
  @start_row,start_col TO last_row,last_col
  @start_row+2,start_col TO start_row+2,last_col
  @start_row,start_col+skip_cols TO last_row,start_col+skip_cols*6
  @start_row,start_col+skip_cols*2 TO last_row,start_col+skip_cols*5
  @start_row,start_col+skip_cols*3 TO last_row,start_col+skip_cols*4

  @start_row,start_col+skip_cols SAY CHR(194)
  @start_row,start_col+skip_cols*2 SAY CHR(194)
  @start_row,start_col+skip_cols*3 SAY CHR(194)
  @start_row,start_col+skip_cols*4 SAY CHR(194)
  @start_row,start_col+skip_cols*5 SAY CHR(194)
  @start_row,start_col+skip_cols*6 SAY CHR(194)

  @start_row+2,start_col SAY CHR(195)
  @start_row+2,start_col+skip_cols SAY CHR(197)
  @start_row+2,start_col+skip_cols*2 SAY CHR(197)
  @start_row+2,start_col+skip_cols*3 SAY CHR(197)
  @start_row+2,start_col+skip_cols*4 SAY CHR(197)
  @start_row+2,start_col+skip_cols*5 SAY CHR(197)
  @start_row+2,start_col+skip_cols*6 SAY CHR(197)
  @start_row+2,last_col SAY CHR(180)

  @start_row+4,start_col TO last_row-2,last_col
  @start_row+6,start_col TO last_row-4,last_col
  @start_row+8,start_col TO last_row-6,last_col

  @start_row+4,start_col SAY CHR(195)
  @start_row+4,start_col+skip_cols SAY CHR(197)
  @start_row+4,start_col+skip_cols*2 SAY CHR(197)
  @start_row+4,start_col+skip_cols*3 SAY CHR(197)
  @start_row+4,start_col+skip_cols*4 SAY CHR(197)
  @start_row+4,start_col+skip_cols*5 SAY CHR(197)
  @start_row+4,start_col+skip_cols*6 SAY CHR(197)
  @start_row+4,last_col SAY CHR(180)

  @start_row+6,start_col SAY CHR(195)
  @start_row+6,start_col+skip_cols SAY CHR(197)
  @start_row+6,start_col+skip_cols*2 SAY CHR(197)
  @start_row+6,start_col+skip_cols*3 SAY CHR(197)
  @start_row+6,start_col+skip_cols*4 SAY CHR(197)
  @start_row+6,start_col+skip_cols*5 SAY CHR(197)
  @start_row+6,start_col+skip_cols*6 SAY CHR(197)
  @start_row+6,last_col SAY CHR(180)

  @start_row+8,start_col SAY CHR(195)
  @start_row+8,start_col+skip_cols SAY CHR(197)
  @start_row+8,start_col+skip_cols*2 SAY CHR(197)
  @start_row+8,start_col+skip_cols*3 SAY CHR(197)
  @start_row+8,start_col+skip_cols*4 SAY CHR(197)
  @start_row+8,start_col+skip_cols*5 SAY CHR(197)
  @start_row+8,start_col+skip_cols*6 SAY CHR(197)
  @start_row+8,last_col SAY CHR(180)

  @start_row+10,start_col SAY CHR(195)
  @start_row+10,start_col+skip_cols SAY CHR(197)
  @start_row+10,start_col+skip_cols*2 SAY CHR(197)
  @start_row+10,start_col+skip_cols*3 SAY CHR(197)
  @start_row+10,start_col+skip_cols*4 SAY CHR(197)
  @start_row+10,start_col+skip_cols*5 SAY CHR(197)
  @start_row+10,start_col+skip_cols*6 SAY CHR(197)
  @start_row+10,last_col SAY CHR(180)

  @start_row+12,start_col SAY CHR(195)
  @start_row+12,start_col+skip_cols SAY CHR(197)
  @start_row+12,start_col+skip_cols*2 SAY CHR(197)
  @start_row+12,start_col+skip_cols*3 SAY CHR(197)
  @start_row+12,start_col+skip_cols*4 SAY CHR(197)
  @start_row+12,start_col+skip_cols*5 SAY CHR(197)
  @start_row+12,start_col+skip_cols*6 SAY CHR(197)
  @start_row+12,last_col SAY CHR(180)

  @last_row,start_col SAY CHR(192)
  @last_row,start_col+skip_cols SAY CHR(193)
  @last_row,start_col+skip_cols*2 SAY CHR(193)
  @last_row,start_col+skip_cols*3 SAY CHR(193)
  @last_row,start_col+skip_cols*4 SAY CHR(193)
  @last_row,start_col+skip_cols*5 SAY CHR(193)
  @last_row,start_col+skip_cols*6 SAY CHR(193)
  @last_row,last_col SAY CHR(217)

  @start_row,last_col+2 FILL TO last_row+3,last_col+3 COLOR W/N
* @last_row+2,start_col+1 FILL TO last_row+2,last_col+3 COLOR W/N
  @last_row+3,start_col+1 FILL TO last_row+3,last_col+3 COLOR W/N
  @last_row+1,start_col+1 SAY "Month:"
  @last_row+1,start_col+7 SAY "PgUp/PgDn" COLOR R/W
  @last_row+1,start_col+19 SAY "Day:"
  @last_row+1,start_col+23 SAY "->" COLOR R/W
  @last_row+1,last_col-8 SAY "Year:"
  @last_row+1,last_col-3 SAY "+/-" COLOR R/W
  @last_row+2,start_col+1 SAY "Insert Key:" COLOR R/W
  @last_row+2,start_col+12 SAY "Toggle on day"
  @last_row+2,start_col+28 SAY "Esc:" COLOR R/W
  @last_row+2,start_col+32 SAY "Quit"

RETURN


* --- procedure to clear grid -------------

PROCEDURE clear_grid
  @row,start_col+skip_cols-2 SAY "  "
  @row,start_col+skip_cols*2-2 SAY "  "
  @row,start_col+skip_cols*3-2 SAY "  "
  @row,start_col+skip_cols*4-2 SAY "  "
  @row,start_col+skip_cols*5-2 SAY "  "
  @row,start_col+skip_cols*6-2 SAY "  "
  @row,start_col+skip_cols*7-2 SAY "  "

  @last_row-1,start_col+skip_cols-2 SAY "  "
  @last_row-1,start_col+skip_cols*2-2 SAY "  "
  @last_row-1,start_col+skip_cols*3-2 SAY "  "
  @last_row-1,start_col+skip_cols*4-2 SAY "  "
  @last_row-1,start_col+skip_cols*5-2 SAY "  "
  @last_row-1,start_col+skip_cols*6-2 SAY "  "
  @last_row-1,start_col+skip_cols*7-2 SAY "  "

  @last_row-3,start_col+skip_cols-2 SAY "  "
  @last_row-3,start_col+skip_cols*2-2 SAY "  "
  @last_row-3,start_col+skip_cols*3-2 SAY "  "
  @last_row-3,start_col+skip_cols*4-2 SAY "  "
  @last_row-3,start_col+skip_cols*5-2 SAY "  "
  @last_row-3,start_col+skip_cols*6-2 SAY "  "
  @last_row-3,start_col+skip_cols*7-2 SAY "  "
RETURN

*=========END OF PROGRAM==========================================

