/*****
 *
 * TBR24.PRG
 * An improved skipper for arrays
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define           WHAT_IT_DOES              "ESC - Quit"

FUNCTION Tbr24()
   LOCAL oBrow, oCol, nKey
   LOCAL nSubscript

   LOCAL aArray := { "Spitfire" ,;
                     "Tornado"  ,;
                     "Harrier"  ,;
                     "Hawk"     ,;
                     "Phantom"  ,;
                     "Eagle"    ,;
                     "Victor"   ,;
                     "Vulcan"   ,;
                     "Valiant"  ,;
                     "TomCat"   ,;
                     "Prowler"  ,;
                     "Typhoon"  ,;
                     "Mustang"  ,;
                     "Hurricane",;
                     "Valkyrie"  }

   // Array subscript starts with first element
   nSubscript := 1

   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SETCOLOR(BGND_CLR)
   SCROLL()
   DISPBOX( 1, 14, MAXROW() - 13, 31, B_SINGLE, CLR_SPEC )
   @ MAXROW(), 0 SAY PADC(WHAT_IT_DOES, MAXCOL() + 1) ;
                          COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSENEW( 2, 15, MAXROW() - 14, 30 )
   oBrow:skipBlock     := {|nReq| ArraySkip(nReq, aArray, @nSubscript)}
   oBrow:goTopBlock    := {|| ArrayGoTop(@nSubscript)}
   oBrow:goBottomBlock := {|| ArrayGoBottom(aArray, @nSubscript)}
   oBrow:colorSpec     := CLR_SPEC
   oBrow:headSep       := HEADSEP

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_ARRAY, {|| aArray[nSubscript]})
   oBrow:addColumn(oCol)

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      // STEP 4
      nKey := INKEY(0)

      IF !TBMoveCursor( nKey, oBrow )
         IF nKey == K_ESC
            EXIT

         ENDIF

      ENDIF

   END
   SCROLL()
   RETURN (NIL)

/*****
 *
 * ArrayGoTop(<nSubscript>) --> NIL
 * nSubscript should be passed by reference
 *
 */

FUNCTION ArrayGoTop( nSubscript )
   nSubscript := 1
   RETURN (NIL)

/*****
 *
 * ArrayGoBottom(<aArray>, <nSubscript>) --> NIL
 * nSubscript should be passed by reference
 *
 */

FUNCTION ArrayGoBottom( aArray, nSubscript )
   nSubscript := LEN(aArray)
   RETURN (NIL)

/*****
 *
 * ArraySkip(<nRequest>, <aArray>, <nSubscript>) --> NIL
 * nSubscript should be passed by reference
 *
 */

FUNCTION ArraySkip( nRequest, aArray, nSubscript )
   LOCAL nActually := 0

   nActually := IF(ABS(nRequest) >= IF(nRequest >= 0,;
                  LEN(aArray) - nSubscript, nSubscript - 1),;
                    IF(nRequest >= 0, LEN(aArray) - nSubscript,;
                       1 - nSubscript), nRequest)
                 
   nSubscript += nActually
   RETURN (nActually)

// EOF - TBR24.PRG //

