/*****
 *
 * TBR15.PRG
 * Shifting between two TBrowse windows
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit                " +;
                                   "TAB - Shift between browses       " 

FUNCTION Tbr15()
   LOCAL oBrow1, oBrow2, oWorkBrow, nKey, oCol

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // For the example use the same 
   // test file with another name
   COPY FILE test.dbf TO test1.dbf
   DBUSEAREA( NEW, "DbfNtx", "test1" )

   DBUSEAREA( NEW, "DbfNtx", "test" )
   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   @ MAXROW(), 0 SAY PADC(WHAT_IT_DOES, MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow1 := TBROWSEDB( 3, 7, MAXROW() - 7, MAXCOL() - 8 )
   oBrow1:colSep    := COLSEP
   oBrow1:headSep   := HEADSEP
   oBrow1:footSep   := FOOTSEP
   oBrow1:colorSpec := COLORS_FOR_THE_FIRST_BROWSE

   oBrow2 := TBROWSEDB( 8, 12, MAXROW() - 2, MAXCOL() - 3 )
   oBrow2:colSep    := COLSEP
   oBrow2:headSep   := HEADSEP
   oBrow2:footSep   := FOOTSEP
   oBrow2:colorSpec := COLORS_FOR_THE_SECOND_BROWSE

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_BROW_1
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_5, {|| test1->fld5} )
   oCol:footing := FOOT_BROW_2
   oBrow2:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_6, {|| test1->fld6} )
   oBrow2:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_7, {|| test1->fld7} )
   oBrow2:addColumn(oCol)

   // Remember: The variable contains a REFERENCE
   // to the object
   // First stabilize the unselected
   // object
   ForceStable(oBrow2)
   // Stabilization will draw a highlight on 
   // the current cell
   //
   // You should deHilite() cell in the unselected object
   // Actually, this is not mandatory but,
   // is going to be a little "weird" if you have 
   // highlighted "cells" in both browses
   // The user is going to ask you in which one she/he is
   // currently on...
   oBrow2:deHilite()

   // This is going to be the current object
   oWorkBrow := oBrow1

   WHILE .T.
      // STEP 3
      ForceStable(oWorkBrow)

      IF (oWorkBrow:hitTop .OR. oWorkBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)         

      IF !TBMoveCursor(nKey, oWorkBrow)
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_TAB )
            oWorkBrow:deHilite()

            IF oWorkBrow == oBrow1
               oWorkBrow := oBrow2
               DBSELECTAREA("test1")

            ELSE
               oWorkBrow := oBrow1
               DBSELECTAREA("test")

            ENDIF

            // invalidate() is going to "repaint" the 
            // browse window without rereading data 
            // from disk (what refreshAll() does)
            oWorkBrow:invalidate()
            // Hilite the Cell
            oWorkBrow:hilite()
      
         ENDIF
   
      ENDIF

   END

   FERASE("test1.dbf")
   RETURN (NIL)

// EOF - TBR15.PRG //

