/*****
 *
 * TBR06.PRG
 * Using Tbrowse:cargo to change colors in all columns
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "F10 - Change colors      ESC - Quit"

FUNCTION Tbr6()
   LOCAL oBrow, oCol, nKey

   // Settings
   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // Open files
   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   oCol:footing := FOOT_LAST
   oCol:colorBlock := {|xBlockParm| ;
                       IF(xBlockParm > 4, { 6, 2 }, {1, 2}) }
   oBrow:addColumn( oCol )

   // cargo
   // This is the same principle used in TBColumn:cargo
   // But now we will use TBrowse:cargo
   oBrow:cargo := {|oParm| ChangeIt(oParm) }

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_F10 )
            IF oBrow:cargo != NIL
               EVAL(oBrow:cargo, oBrow)

            ENDIF

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * Changes colorblock
 *
 */

STATIC FUNCTION ChangeIt(oBrow)
   LOCAL GetList := {}  // For the Get System
   LOCAL nMenu   := 3
   LOCAL nNum    := 0.00
   LOCAL bColorBlock
   LOCAL nCnt, oCol
  
   // Save screen things
   PushScr()
   
   SET(_SET_SCOREBOARD, .F.)
   SETCOLOR(MENU_CLR)
   SETCURSOR(SC_NORMAL)

    // This is not a beautiful screen but it woks!
   SCROLL( 6, 20, 15, 39 )
   @  6,20 TO 15,39 DOUBLE
   @  7,22 SAY    MENU_SEL 
   @  9,22 PROMPT MENU_LESS
   @ 10,22 PROMPT MENU_GREA
   @ 11,22 PROMPT MENU_EQU 
   MENU TO nMenu

   @ 14,22 SAY MENU_VAL GET nNum PICTURE "999999.99"
   READ

   // Here, you decide what color you 
   // are going to use in your column
   IF nMenu == 1
      bColorBlock := {|| IF(test->fld5 < nNum, { 7, 2 },;
	                       { 1, 2 }) }

   ELSEIF nMenu == 2
      bColorBlock := {|| IF(test->fld5 > nNum, { 6, 2 },;
	                       { 1, 2 }) }

   ELSE
      bColorBlock := {|| IF(test->fld5 == nNum, { 8, 2 },;
	                       { 1, 2 }) }

   ENDIF

   // Assign colorblock to all columns
   FOR nCnt := 1 TO oBrow:colCount
      // colCount gives you the number of columns on
      // a TBrowse object
      oCol := oBrow:getColumn(nCnt)
      oCol:colorBlock := bColorBlock

   NEXT

   // Restore
   PopScr()

   oBrow:configure()
   oBrow:refreshAll()
   ForceStable(oBrow)

   RETURN (NIL)

// EOF - TBR06.PRG //
