/*****
 *
 * TBR30.PRG
 * Browsing text files - Third approach
 * Two columns of text
 *
 */

#include "inkey.ch"
#include "fileio.ch"
#include "setcurs.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define           WHAT_IT_DOES           "ESC - Quit"

#xtranslate       BOFile()      =>       (n == nFirstRec)
#xtranslate       EOFile()      =>       (n == nLastRec)

// Global stuff
STATIC cBuffer1
STATIC cBuffer2
STATIC n
STATIC nLastRec
STATIC nFirstRec

/*****
 *
 * Main Function
 * WARNING: This program does not handle line overflow
 *          for the second text column
 *
 */

FUNCTION Tbr30( cFile )
   LOCAL nHandle, oBrow, nKey, nMaxRow, nMaxCol
   LOCAL oCol

   // Open file
   nHandle := FOPEN( cFile, FO_READ )
   IF nHandle < 0
      SCROLL()
      QOUT( MSG_TBR29_ERR )
      QUIT

   ENDIF

   // Screen (not handled by TBrowse
   SETCURSOR(SC_NONE)
   SETBLINK(.F.)   // This way you have more colors
   SETCOLOR(BR_TXT_BGND_CLR)
   SCROLL()
   nMaxRow := MAXROW()
   nMaxCol := MAXCOLUMN
   SCROLL()
   // "Shadow"
   SETCOLOR(BR_TXT_BLACK)
   SCROLL( 3, 4, nMaxRow - 2, nMaxCol - 2)
   @ 0, 0 SAY PADC(BR_TXT_HEADER, nMaxCol + 1) COLOR BR_TXT_HEAD_CLR
   @ nMaxRow, 0 SAY PADC(WHAT_IT_DOES, nMaxCol + 1) COLOR MSG_ROW_CLR

   // Positioning
   nLastRec  := FindBottom(nHandle)
   nFirstRec := n := FindTop(nHandle)

   // Initialize buffers
   cBuffer1 := cBuffer2 := SPACE(RECSIZE)

   // STEP 1
   oBrow := TBROWSEDB( 2, 2, nMaxRow - 3, nMaxCol - 4)
   oBrow:skipBlock     := {|x| SkipRec(x, nHandle)}
   oBrow:goTopBlock    := {||  n := FindTop(nHandle)}
   oBrow:goBottomBlock := {||  n := FindBottom(nHandle)}
   oBrow:colorSpec     := BR_TXT_CLR_SPEC
   
   // STEP 2
   oCol  := TBCOLUMNNEW( , {|| cBuffer1} )
   oCol:width := RECSIZE
   oCol:colorBlock := {|| IF(!EMPTY(cBuffer2), {1,3}, {1,2})}
   oBrow:addColumn(oCol)

   oCol  := TBCOLUMNNEW( , {|| cBuffer2} )
   oCol:width := RECSIZE
   oCol:colorBlock := {|| IF(!EMPTY(cBuffer2), {1,3}, {1,2})}
   oBrow:addColumn(oCol)

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      // STEP 4
      nKey := INKEY(0)
      IF !TBMoveCursor( nKey, oBrow )
         IF nKey == K_ESC
            EXIT

         ENDIF

      ENDIF

   END

   SCROLL()
   RETURN (NIL)

/*****
 *
 * Main Skipper
 *
 */

FUNCTION SkipRec( nRequest, nHandle )
   LOCAL nActually := 0

   IF (nRequest == 0)
      ReadLine(nHandle, 0)

   ELSEIF (nRequest > 0)
      WHILE (nActually < nRequest) .AND. ;
            (!EOFile())
         ReadLine(nHandle, 1)
         nActually++

      END

   ELSEIF (nRequest < 0)
      WHILE (nActually > nRequest) .AND. ;
         (!BOFile())
         ReadLine(nHandle, -1)
         nActually--

      END

   ENDIF

   RETURN (nActually)

/*****
 *
 * Top of File
 *
 */

FUNCTION FindTop(nHandle)
   LOCAL cBuff
   LOCAL nAt := 0

   FSEEK(nHandle, 0, FS_SET)
   WHILE (nAt == 0)
      cBuff := SPACE(RECSIZE)
      FREAD(nHandle, @cBuff, RECSIZE)
      nAt := AT(CR, cBuff)

   END

   FSEEK(nHandle, -RECSIZE, FS_RELATIVE)
   
   RETURN (FSEEK(nHandle, nAt + 1, FS_RELATIVE))

/*****
 *
 * Bottom of File
 *
 */

FUNCTION FindBottom(nHandle)
   // Assume last byte is an LF
   RETURN (FSEEK(nHandle, 0, FS_END))

/*****
 *
 * Reads a line of text
 *
 */

FUNCTION ReadLine( nHandle, nRec )
   LOCAL cBuff
   LOCAL nAt

   cBuffer1 := cBuffer2 := cBuff := SPACE(RECSIZE)

   IF (nRec == 0)
      BackCRLF(nHandle, 1)

   ELSEIF (nRec < 0)
      BackCRLF(nHandle, 2)

   ENDIF

   FREAD(nHandle, @cBuff, RECSIZE)
   nAt := AT(CR, cBuff)
   IF (nAt == 0)
      // Line overflow
      cBuffer1 := cBuff
      cBuff := SPACE(RECSIZE)
      n := FSEEK(nHandle, 0, FS_RELATIVE)
      FREAD(nHandle, @cBuff, RECSIZE)
      //
      // WARNING:
      // Assuming CRLF is now in the buffer
      //
      nAt := AT(CR, cBuff)
      //
      // CR not in the buffer
      // ERROR!
      //
      // Program will go crazy!
         
   ENDIF

   FSEEK(nHandle, n, FS_SET)

   cBuff := SPACE(RECSIZE)
   FREAD(nHandle, @cBuff, nAt + 1)
   n := FSEEK(nHandle, 0, FS_RELATIVE)
   cBuff := TRIM(cBuff)
   cBuff := LEFT(cBuff, LEN(cBuff) - 2)
   
   IF (EMPTY(cBuffer1))
      cBuffer1 := cBuff

   ELSE
      cBuffer2 := cBuff

   ENDIF
   
   RETURN (NIL)

/*****
 *
 * Pointer at proper place
 *
 */

FUNCTION BackCRLF(nHandle, nTimes)
   LOCAL cBuff, nAt, nSize

   WHILE (nTimes > 0)
      IF (n == nFirstRec)
         n := FSEEK(nHandle, 0, FS_SET)
         EXIT

      ENDIF
      nSize := MIN(n, RECSIZE)
      cBuff := SPACE(nSize)
      FSEEK(nHandle, -nSize, FS_RELATIVE)
      FREAD(nHandle, @cBuff, nSize - 2)
      nAt := RAT(CR, cBuff)
      IF (nAt == 0)
         n := FSEEK(nHandle, -1, FS_RELATIVE)
         LOOP

      ELSE
         n := FSEEK(nHandle, (n - nSize) + (nAt + 1),;
                    FS_SET)

      ENDIF
      nTimes--

   END
   RETURN (NIL)

// EOF - TBR30.PRG //
