/*****
 *
 * TBR29.PRG
 * Browsing a text file - second approach
 *
 */

#include "inkey.ch"
#include "fileio.ch"
#include "setcurs.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define           WHAT_IT_DOES           "ESC - Quit"

#xtranslate       BOFile()      =>       (n == nFirstRec)
#xtranslate       EOFile()      =>       (n == nLastRec)

// Global stuff
STATIC   cBuffer
STATIC   n
STATIC   nLastRec
STATIC   nFirstRec

/*****
 *
 * Main Function
 * WARNING: This program does not handle line overflow
 *
 */

FUNCTION Tbr29( cFile )
   LOCAL nHandle, oBrow, nKey, nMaxRow, nMaxCol
   LOCAL oCol

   // Open file
   nHandle := FOPEN( cFile, FO_READ )
   IF nHandle < 0
      SCROLL()
      QOUT( MSG_TBR29_ERR )
      QUIT

   ENDIF

   // Screen (not handled by TBrowse
   SETCURSOR(SC_NONE)
   SETBLINK(.F.)   // This way you have more colors
   SETCOLOR(BR_TXT_BGND_CLR)
   SCROLL()
   nMaxRow := MAXROW()
   nMaxCol := MAXCOLUMN
   SCROLL()
   // "Shadow"
   SETCOLOR(BR_TXT_BLACK)
   SCROLL( 3, 4, nMaxRow - 2, nMaxCol - 2)
   SETCOLOR(BR_TXT_CLR_SPEC)
   @ 0, 0 SAY PADC(BR_TXT_HEADER, nMaxCol + 1) COLOR BR_TXT_HEAD_CLR
   @ nMaxRow, 0 SAY PADC(WHAT_IT_DOES, nMaxCol + 1) COLOR MSG_ROW_CLR

   // Positioning
   nLastRec  := FindBottom(nHandle)
   nFirstRec := n := FindTop(nHandle)

   // STEP 1
   oBrow := TBROWSEDB( 2, 2, nMaxRow - 3, nMaxCol - 4)
   oBrow:skipBlock     := {|x| SkipRec(x, nHandle)}
   oBrow:goTopBlock    := {||  n := FindTop(nHandle)}
   oBrow:goBottomBlock := {||  n := FindBottom(nHandle)}
   
   // STEP 2
   cBuffer := SPACE(RECSIZE)
   oCol := TBCOLUMNNEW( , {|| cBuffer} )
   oCol:width := nMaxCol - 5
   oBrow:addColumn(oCol)

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      // STEP 4
      nKey := INKEY(0)
      IF !TBMoveCursor( nKey, oBrow )
         IF nKey == K_ESC
            EXIT

         ENDIF

      ENDIF

   END

   SCROLL()
   RETURN (NIL)

/*****
 *
 * Main Skipper
 *
 */

FUNCTION SkipRec( nRequest, nHandle )
   LOCAL nActually := 0

   IF (nRequest == 0)
      ReadLine(nHandle, 0)

   ELSEIF (nRequest > 0)
      WHILE (nActually < nRequest) .AND. ;
            (!EOFile())
         ReadLine(nHandle, 1)
         nActually++

      END

   ELSEIF (nRequest < 0)
      WHILE (nActually > nRequest) .AND. ;
         (!BOFile())
         ReadLine(nHandle, -1)
         nActually--

      END

   ENDIF

   RETURN (nActually)

/*****
 *
 * Top of File
 *
 */

FUNCTION FindTop(nHandle)
   LOCAL cBuff := SPACE(RECSIZE)
   LOCAL nAt

   FSEEK(nHandle, 0, FS_SET)
   FREAD(nHandle, @cBuff, RECSIZE)
   nAt := AT(CR, cBuff)

   RETURN (FSEEK(nHandle, nAt + 1, FS_SET))

/*****
 *
 * Bottom of File
 *
 */

FUNCTION FindBottom(nHandle)
   // Assume last byte is an LF
   RETURN (FSEEK(nHandle, 0, FS_END))

/*****
 *
 * Reads a line of text
 *
 */

FUNCTION ReadLine( nHandle, nRec )
   LOCAL cBuff := SPACE( RECSIZE )
   LOCAL nAt

   IF (nRec == 0)
      BackCRLF(nHandle, 1)

   ELSEIF (nRec < 0)
      BackCRLF(nHandle, 2)

   ENDIF

   FREAD(nHandle, @cBuff, RECSIZE)
   nAt := AT(CR, cBuff)
   FSEEK(nHandle, n, FS_SET)

   cBuff := SPACE(RECSIZE)
   FREAD(nHandle, @cBuff, nAt + 1)
   n := FSEEK(nHandle, 0, FS_RELATIVE)
   cBuffer := SUBSTR(cBuff, 1, RAT(CR, cBuff) - 1)

   RETURN (NIL)

/*****
 *
 * Pointer at proper place
 *
 */

FUNCTION BackCRLF(nHandle, nTimes)
   LOCAL cBuff, nAt, nSize

   WHILE (nTimes > 0)
      IF (n == nFirstRec)
         n := FSEEK(nHandle, 0, FS_SET)
         EXIT

      ENDIF
      nSize := MIN(n, RECSIZE)
      cBuff := SPACE(nSize)
      FSEEK(nHandle, -nSize, FS_RELATIVE)
      FREAD(nHandle, @cBuff, nSize - 2)
      nAt := RAT(CR, cBuff)
      IF (nAt == 0)
         n := FSEEK(nHandle, -1, FS_RELATIVE)
         LOOP

      ELSE
         n := FSEEK(nHandle, (n - nSize) + (nAt + 1),;
                    FS_SET)

      ENDIF
      nTimes--

   END
   RETURN (NIL)

// EOF - TBR29.PRG //
