/*****
 *
 * TBR27.PRG
 * Modifying TBR25 to browse a 2-D array
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define           WHAT_IT_DOES              "ESC - Quit"

FUNCTION Tbr27()
   LOCAL oBrow, nKey, oCol
   LOCAL nSubscript
   LOCAL aArray := { { 12, 34 },;
                     { 28, 67 },;
                     { 72, 63 },;
                     { 33, 39 },;
                     { 51, 44 },;
                     { 27, 21 },;
                     { 89,  2 },;
                     { 0,  -1 } }

   // Array subscript starts with first element
   nSubscript := 1

   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SETCOLOR(BGND_CLR)
   SCROLL()
   DISPBOX( 1, 14, MAXROW() - 13, 31, B_SINGLE, CLR_SPEC )
   @ MAXROW(), 0 SAY PADC(WHAT_IT_DOES, MAXCOL() + 1) ;
                          COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSENEW( 2, 15, MAXROW() - 14, 30 )
   oBrow:skipBlock     := {|nReq| ArraySkip(nReq, aArray, @nSubscript)}
   oBrow:goTopBlock    := {|| ArrayGoTop(@nSubscript)}
   oBrow:goBottomBlock := {|| ArrayGoBottom(aArray, @nSubscript)}
   oBrow:colorSpec     := CLR_SPEC
   oBrow:headSep       := HEADSEP
   oBrow:colSep        := COLSEP

   // STEP 2
   // One subarray per column
   oCol := TBCOLUMNNEW( HEAD_COL_1,;
                          {|| aArray[nSubscript, 1]})
   oBrow:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_COL_2,;
                          {|| aArray[nSubscript, 2]})
   oBrow:addColumn(oCol)

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF (oBrow:hitTop .OR. oBrow:hitBottom)
         TONE(1000,4)

      ENDIF

      //STEP 4
      nKey := INKEY(0)

      IF !TbMoveCursor( nKey, oBrow )
         IF nKey == K_ESC
            EXIT

         ENDIF

      ENDIF

   END
   SCROLL()
   RETURN (NIL)

// EOF - TBR27.PRG //
