/*****
 *
 * TBR26.PRG
 * An ACHOICE()-style function using TBrowse
 *
 */

#include "inkey.ch"
#include "setcurs.ch"

#include "samples.ch"

/*****
 *
 * ACHOOSE(<nTop>,<nLeft>,<nBottom>,<nRight>,<aItems>
 *          [,<aLogic>][,<aMsg>][,<nMsgRow>][,<bBlock]
 *          [,<cClrStr>])
 *
 * nTop, nLeft, nBottom, nRight  -  window coordinates
 * aItems  -  Array with Menu Items
 * aLogic  -  Array with .T. or .F. for each item in menu
 * aMsg    -  Array with messages for each item in menu
 * nMsgRow -  Line to display messages
 * bBlock  -  Codeblock to be executed while waiting for a key
 * cClrStr -  Color pattern (as a string)
 *
 */

FUNCTION AChoose( nTop, nLeft, nBottom, nRight, aItems,;
                  aLogic, aMsg, nMsgRow, bBlock, cClrStr )

   LOCAL oBrow, nKey, oCol
   LOCAL nNewPos, nLen, nInitPos, nWindow
   LOCAL lIsMsg, nWidth, cSaveClr
   LOCAL nSubs, nRet, nActually

   // Save
   PushScr()

   SETCURSOR(SC_NONE)

   // Parameter checking
   nLen    := LEN( aItems )
   cClrStr := IF(cClrStr == NIL, BR_CLRS, cClrStr)

   lIsMsg := (VALTYPE(aMsg) == "A")
   nMsgRow := IF(nMsgRow == NIL, MAXROW(), nMsgRow)

   // No logical array so, create one!
   IF VALTYPE(aLogic) != "A"
      aLogic := ARRAY(nLen)
      AFILL( aLogic, .T. )

   ENDIF

   nInitPos := 0
   nWindow  := nBottom - nTop
   nWidth   := nRight - nLeft - 1
   nRet     := 0

   bBlock := IF(bBlock == NIL, {|| .F.}, bBlock)

   // Draw the Box and Gauge
   cSaveClr := SETCOLOR(;
               SUBSTR(cClrStr, 1, AT(",",cClrStr) - 1))
   SCROLL(nTop - 1, nLeft - 1, nBottom + 1, nRight + 1)
   DISPBOX(nTop - 1, nLeft - 1, nBottom + 1, nRight + 1)
   DISPBOX(nTop, nRight + 1, nBottom, nRight + 1, CHR(219),;
            SCROLL_BAR_BGND)
   @ nTop,nRight + 1 SAY CHR(219) COLOR SCROLL_BUTTON

   // STEP 1
   oBrow := TBROWSENEW( nTop, nLeft, nBottom, nRight )
   oBrow:colorSpec := cClrStr

   // nSubs is the array subscript 
   nSubs := 1

   // Go Top and Go Bottom Blocks
   oBrow:goTopBlock    := {|| nSubs := 1 }
   oBrow:goBottomBlock := {|| nSubs := nLen }
   oBrow:skipBlock := {|nRequest| nActually := IF(ABS(nRequest) >= ;
                          IF(nRequest >= 0,;
                             nLen - nSubs, nSubs - 1),;
                                IF(nRequest >= 0, nLen - nSubs,;
                                   1 - nSubs),nRequest),;
                                      nSubs += nActually, ;
                                         nActually }

   // STEP 2
   oCol := TBCOLUMNNEW(, {|| aItems[nSubs]})
   
   // Colors for Selectable and Unselectable Items
   oCol:colorBlock := {|| IF(aLogic[nSubs], {1, 2}, {1, 3})}
   oCol:width      := nWidth
   //
   // About Column Width:
   //
   // When browsing array elements, you need to pay attention
   // to their size. This is very importante because TBcolumn
   // will work based in the size of the first element of
   // the array being being browsed.
   // We are assuming the width between left and right margins
   //
   oBrow:addColumn(oCol)

   WHILE .T.
      ForceStable(oBrow)

      IF (oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // Update Bar Gauge
      nNewPos := nWindow / (nLen / nSubs)
      IF nSubs == 1
         nNewPos := 0

      ELSEIF nSubs == nLen
         nNewPos := nWindow

      ENDIF
      IF ( nInitPos != nNewPos )
         @ nTop + nInitPos,nRight + 1 SAY CHR(219) ;
                                      COLOR SCROLL_BAR_BGND
         @ nTop + nNewPos, nRight + 1 SAY CHR(219) ;
                                      COLOR SCROLL_BUTTON
         nInitPos := nNewPos

      ENDIF
      // Messages?
      IF lIsMsg
         @ nMsgRow, 0 SAY SPACE(MAXCOL() + 1) COLOR ;
           SUBSTR(cClrStr, RAT(",", cClrStr) + 1)
         @ nMsgRow, 0 SAY aMsg[nSubs] COLOR ;
           SUBSTR(cClrStr, RAT(",", cClrStr) + 1)

      ENDIF
      WHILE ((nKey := INKEY(0.1)) == 0)
         // Evaluate a code block
         EVAL(bBlock)

      END

      IF !TBMoveCursor( nKey, oBrow )
         // Key was not handled there
         // Lets try here
         IF ( nKey == K_ESC )
            EXIT 

         ELSEIF ( nKey == K_ENTER )
            // Is the item selectable?
            IF aLogic[nSubs]
               // If so, return array subscript for 
               // the element
               nRet := nSubs
               EXIT

            ENDIF

         ENDIF

      ENDIF

   END

   PopScr()

   RETURN (nRet)

// EOF - TBR26.PRG //
