/*****
 *
 * TBR25.PRG
 * Browsing a 1-D array
 * Same as TBR24 with generic skippers.
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define           WHAT_IT_DOES              "ESC - Quit"

FUNCTION Tbr25()
   LOCAL oBrow, oCol
   LOCAL nSubscript
   LOCAL aArray :=;
                  { "Sidewinder",;
                    "Dragon",;
                    "Excalibur",;
                    "Hurricane",;
                    "Blowpipe",;
                    "Spitfire",;
                    "Hawk",;
                    "Vulcan",;
                    "Victor",;
                    "Valiant",;
                    "Hellcat",;
                    "Tornado",;
                    "Harrier",;
                    "Fighter",;
                    "Typhoon"    }

   nSubscript := 1

   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SETCOLOR(BGND_CLR)
   SCROLL()
   DISPBOX( 1, 14, MAXROW() - 13, 31, B_SINGLE, CLR_SPEC )
   @ MAXROW(), 0 SAY PADC(WHAT_IT_DOES, MAXCOL() + 1) ;
                          COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSENEW( 2, 15, MAXROW() - 14, 30 )

   oBrow:skipBlock     := {|x| SkipArray(x, @nSubscript, aArray)}   // NOTE!
   oBrow:goTopBlock    := {||  GoTopArray(@nSubscript)}             // NOTE!
   oBrow:goBottomBlock := {||  GoBottomArray(@nSubscript, aArray)}  // NOTE!
   
   oBrow:colorSpec := CLR_SPEC
   oBrow:headSep   := HEADSEP

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_ARRAY, {|| aArray[nSubscript]})
   oBrow:addColumn(oCol)

   BrowseArray(oBrow)

   SCROLL()

   RETURN (NIL)

/*****
 *
 * Browse Array
 *
 */

FUNCTION BrowseArray( oObj )
   LOCAL nKey

   WHILE .T.
      // STEP 3
      nKey := IncrStable( oObj )

      IF oObj:stable
         // STEP 4
         nKey := INKEY(0)

      ENDIF

      IF !TbMoveCursor( nKey, oObj )
         IF nKey == K_ESC
            EXIT

         ENDIF

      ENDIF

   END

   RETURN (.T.)

/*****
 *
 * Skippers
 *
 */

FUNCTION GoTopArray(nSubscript)
   // By reference
   nSubscript := 1
   RETURN (NIL)

FUNCTION GoBottomArray(nSubscript, aArray)
   // By reference
   nSubscript := LEN(aArray)
   RETURN (NIL)

FUNCTION SkipArray( nRequest, nSubscript, aArray)
   LOCAL nActually

   nActually := IF(ABS(nRequest) >= IF(nRequest >= 0,;
                  LEN(aArray) - nSubscript, nSubscript - 1),;
                    IF(nRequest >= 0, LEN(aArray) - nSubscript,;
                       1 - nSubscript),;
                          nRequest)

   nSubscript += nActually
 
   RETURN(nActually)

// EOF - TBR25.PRG //
