/*****
 *
 * TBR22.PRG
 * Multiple fields in a column of a TBrowse object
 *
 */

#include "inkey.ch"
#include "box.ch"
#include "setcurs.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define        WHAT_IT_DOES        "ESC - Quit"

FUNCTION MultiField()
   LOCAL oBrow, oColumn, nKey
   LOCAL nMaxRow, nMaxCol
   LOCAL lContinue := .T.

   // This variable holds which indicates in which line
   // you are ( line 1 for Desc1, 2 for Desc2 and so on)
   // 
   // It starts as line 1
   //
   LOCAL nLine := 1

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // Open file
   DBUSEAREA( NEW, "DbfNtx", "Samples" )
   DBSETINDEX( "Samples" )

   // Screen (not handled by TBrowse)
   SET(_SET_SCOREBOARD, .F.)
   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SCROLL()
   nMaxRow := MAXROW()
   nMaxCol := MAXCOL()
   DISPBOX( 0, 0, nMaxRow - 1, nMaxCol, B_SINGLE, CLR_SPEC )
   @ nMaxRow, 0 SAY PADC( WHAT_IT_DOES,;
                           nMaxCol + 1) COLOR MSG_ROW_CLR

   // Create Browse Object
   oBrow := TBROWSENEW( 1, 1, nMaxRow - 2, nMaxCol - 1 )
   
   // Cosmetics
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // Custom Skippers
   //
   // nLine is passed by reference
   //
   // It means field contents or ""
   // for the first and the third columns depending
   // whether nLine is 1 or not
   // For the second column, nLine will be used
   // to decide which field (Desc1, Desc2, Desc3, Desc4)
   // will be retrieved!
   // 
   oBrow:skipBlock     := {|nSkipRequest| SkipDB(nSkipRequest, @nLine)}
   oBrow:goTopBlock    := {|| GoTopDB(@nLine)}
   oBrow:goBottomBlock := {|| GoBottomDB(@nLine)}

   // Column objects
   //
   oColumn := TBCOLUMNNEW( FILE_NAME, {|| IF(nLine == 1, Samples->Name, "")})
   oColumn:footing := FOOT_SAMP
   oBrow:addColumn( oColumn )

   // As you can see, the "trick" is the line counter
   // which will point out the filed you want to 
   // show on the screen. 
   oColumn := TBCOLUMNNEW( FILE_DESC, {|| WhichField(nLine)} )
   oColumn:footing := FOOT_VERS
   oBrow:addColumn( oColumn )

   oColumn := TBCOLUMNNEW( FILE_PLACE, {|| IF(nLine == 1, Samples->Where, "")} )
   oColumn:footing := FOOT_OBJS
   oBrow:addColumn( oColumn )

   // Keep file name on the screen
   oBrow:freeze := 1

   // Browse it!
   WHILE lContinue

      // STEP 3
      ForceStable(oBrow)
   
      IF (oBrow:hitTop .OR. oBrow:hitBottom)
         // Make some noise!
         TONE(1000, 2)

      ENDIF

      // STEP 4
      nKey := INKEY(0)         

      // Process key
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            lContinue := .F.

         ENDIF
   
      ENDIF

   END

   DBCLOSEALL()
   SCROLL()
   SETPOS( 0, 0 )

   RETURN (NIL)           

/*****
 *
 * Bottom of file
 *
 */

STATIC FUNCTION GoBottomDB( nLine )
   // Parameter is passed by reference
   //
   DBGOBOTTOM()
   //
   // Since you are pointing to the last record
   // your last line should be 1, 2, 3 or 4 depending 
   // whether or not you have data to fill those lines
   //
   nLine := LastLine()
   RETURN (NIL)

/*****
 *
 * Top of File
 *
 */

STATIC FUNCTION GoTopDB( nLine )
   // Parameter is passed by reference
   //
   DBGOTOP()
   //
   // Since you are pointing to the first record
   // your current line should be 1
   //
   nLine := 1
   RETURN (NIL)

/*****
 *
 * Skip records
 *
 */

STATIC FUNCTION SkipDB( nRequest, nLine )
   // nLine is passed by reference
   //
   LOCAL nActually := 0

   IF nRequest == 0
      DBSKIP(0)

   ELSEIF nRequest > 0 .AND. !EOF()
      WHILE nActually < nRequest
         //
         // Which one is the field to display?
         //
         IF (nLine == 1 .AND. !EMPTY(Samples->Desc2)) .OR.;
            (nLine == 2 .AND. !EMPTY(Samples->Desc3)) .OR.;
            (nLine == 3 .AND. !EMPTY(Samples->Desc4)) 
            ++nLine

         ELSE
            // We are able to go to the next record since
            // all 3 fields (Desc2, Desc3, Desc4) are empty
            DBSKIP(+1)
            nLine := 1

         ENDIF
         IF EOF()
            DBSKIP(-1)
            nLine := LastLine()
            EXIT

         ENDIF
         nActually++

      END

   ELSEIF nRequest < 0
      WHILE nActually > nRequest
         // Go to previous line
         IF nLine > 1
            --nLine

         ELSE
            DBSKIP(-1)
            IF !BOF()
               nLine := LastLine()

            ELSE
               // You need this. Believe me!
               nLine := 1
               GOTO RECNO()
               EXIT

            ENDIF

         ENDIF
         nActually--

      END

   ENDIF
   RETURN (nActually)

/*****
 *
 * Which field?
 * I know this is a "little" hard-wired
 * but I can't resist to do this way (it is so simple!)
 *
 */

STATIC FUNCTION WhichField(nLine)
   // Line 1 holds the second field in the record (Desc1) 
   // and so on...
   RETURN (FIELDGET(nLine + 1))

/*****
 *
 * Returns the last non-empty description field
 * I am again using the same hard-wiring as above
 * but it is so simple...
 *
 */

STATIC FUNCTION LastLine()
   LOCAL nField := LAST_DESC

   WHILE .T.
      IF !EMPTY(FIELDGET(nField + 1))
         EXIT

      ENDIF
      nField--

   END
   RETURN (nField)

// EOF - TBR22.PRG //
