/*****
 *
 * TBR21.PRG
 * A parent-to-child browse
 * Child file has a WHILE condition
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit             TAB - Shift between browses"

FUNCTION Main()
   LOCAL oBrowParent, oCol, nKey, oBrowChild, oBrowWork
   LOCAL nWhichRecno

   SETBLINK(.F.)
   SETCURSOR(SC_NONE)
   SCROLL()
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "file2" )
   DBSETINDEX( "file2" )

   DBUSEAREA( NEW, "DbfNtx", "file1" )
   DBSETINDEX( "file1" )

   // STEP 1
   // No custom skippers are required for the first browse
   DISPBOX( 2, 6, 10, 35, B_DOUBLE, COLORS_FOR_THE_FIRST_BROWSE )
   oBrowParent := TBROWSEDB( 3, 7, 9, 34 )
   oBrowParent:colSep    := COLSEP
   oBrowParent:headSep   := HEADSEP
   oBrowParent:footSep   := FOOTSEP
   oBrowParent:colorSpec := COLORS_FOR_THE_FIRST_BROWSE

   DISPBOX( 12, 6, 22, 72, B_DOUBLE, COLORS_FOR_THE_SECOND_BROWSE )
   oBrowChild := TBROWSEDB( 13, 7, 21, 71 )
   oBrowChild:skipBlock     := {|nSkip| Skipper(nSkip, BlockIt(file1->invno == file2->invnumber))}
   oBrowChild:goTopBlock    := {|| GoTopDB( file1->invno )}
   oBrowChild:goBottomBlock := {|| GoBottomDB( file1->invno )}
   oBrowChild:colSep    := COLSEP
   oBrowChild:headSep   := HEADSEP
   oBrowChild:footSep   := FOOTSEP
   oBrowChild:colorSpec := COLORS_FOR_THE_SECOND_BROWSE

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_PURCH_DATE, BlockIt(file1->purdate) )
   oCol:footing := FOOT_PARENT
   oBrowParent:addColumn(oCol)
   oCol := TBColumnNew( HEAD_INVOICE, BlockIt(file1->invno) )
   oBrowParent:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_INVOICE, BlockIt(file2->invnumber) )
   oCol:footing := FOOT_CHILD
   oBrowChild:addColumn(oCol)
   oCol := TBCOLUMNNEW( HEAD_ITEM, BlockIt(file2->item) )
   oBrowChild:addColumn(oCol)
   oCol := TBCOLUMNNEW( HEAD_DESCR, BlockIt(file2->itemdesc) )
   oBrowChild:addColumn(oCol)

   ForceStable(oBrowChild)
   oBrowChild:deHilite()

   // Current object
   oBrowWork := oBrowParent

   nWhichRecno := 0
   WHILE .T.
      // STEP 3
      nKey := IncrStable(oBrowWork)

      IF (NEXTKEY() == 0) .AND. (nWhichRecno != file1->(RECNO()))
         nWhichRecno := file1->(RECNO())
         file2->( DBSEEK(file1->invno) )
         file2->( oBrowChild:refreshAll() )
         file2->( ForceStable(oBrowChild) )
         file2->( oBrowChild:deHilite() )
         
      ENDIF

      IF oBrowWork:stable
         // STEP 4
         nKey := INKEY(0)         

      ENDIF

      // Process key
      IF !TBMoveCursor( nKey, oBrowWork )
         IF ( nKey == K_ESC )
            EXIT

         ELSEIF ( nKey == K_TAB )
            oBrowWork:deHilite()
            IF oBrowWork == oBrowChild
               oBrowWork := oBrowParent
               DBSELECTAREA( "file1" )

            ELSE
               oBrowWork := oBrowChild
               DBSELECTAREA( "file2" )

            ENDIF
            oBrowWork:hilite()
      
         ENDIF
   
      ENDIF

   END

   RETURN (NIL)

// EOF - TBR21.PRG //

