/*****
 *
 * TBR20.PRG
 * A scoped TBrowse (BROWSE WHILE)
 * Faster GoTop and GoBottom block
 * Works ONLY if condition has to do 
 * with index expression
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit"

FUNCTION Tbr20()
   LOCAL oBrow, oCol, nKey, bCond
   LOCAL cCond

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   // Go to start condition
   test->(DBSEEK("I"))

   // WHILE (scope) condition
   cCond := "I"
   bCond := BlockIt("I" $ test->fld3)

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:colorSpec := CLR_SPEC

   // Custom Skippers
   oBrow:skipBlock     := {|nToSkip| Skipper(nToSkip, bCond)}
   oBrow:goTopBlock    := {|| GoTopDb(cCond)}
   oBrow:goBottomBlock := {|| GoBottomDb(cCond)}

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, BlockIt(test->fld1) )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, BlockIt(test->fld2) )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, BlockIt(test->fld3) )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, BlockIt(test->fld4) )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, BlockIt(test->fld5) )
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      // STEP 4
      nKey := INKEY(0)         
      
      // Process key
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * Skip to top of condition
 *
 */

STATIC FUNCTION GoTopDb(cCond)
   DBSEEK(cCond)
   RETURN (NIL)

/*****
 *
 * Skip to the bottom of condition
 *
 */

STATIC FUNCTION GoBottomDb(cCond)
   DBSEEK(SUBSTR(cCond, 1, LEN(cCond) - 1) +;
            CHR(ASC(SUBSTR(cCond, LEN(cCond))) + 1), .T.)
   DBSKIP(-1)
   RETURN (NIL)

/*****
 *
 * Main Skippper
 *
 */

STATIC FUNCTION Skipper( nRequest, bCond )
   // nRequest is the number of records to be skipped
   // nActually is the actual number of records skipped
   LOCAL nActually := 0

   IF (nRequest == 0)
      DBSKIP(0)

   ELSEIF (nRequest > 0) .AND. (!EOF())
      // Keep skipping until number of skips
      // requested is satisfied
      WHILE (nActually < nRequest)
         DBSKIP(1)
         // Evaluate condition for each record
         IF !EVAL(bCond) .OR. EOF()
            DBSKIP(-1)
            EXIT

         ENDIF
      
         // Skip counter 
         nActually++

      END

   ELSEIF (nRequest < 0)
      WHILE (nActually > nRequest)
         DBSKIP(-1)
         // This is check is important!
         // BOF bangs do not sit on phanton record
         // Rather, the top record is evaluated, 
         // and may meet the condition
         IF BOF()
            EXIT

         ENDIF
         // Evaluate condition for each record
         IF !EVAL(bCond)
            DBSKIP(1)
            EXIT

         ENDIF

         // Skip counter
         nActually--

      END

   ENDIF
   // Returns number of records actually skipped
   RETURN (nActually)

// EOF - TBR20.PRG //
