/*****
 *
 * TBR17.PRG
 * Moving/resizing the TBrowse window
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit       " +;
                                   "ALT_M - Move window       " +;
                                   "ALT_S - Shrink/Grow window"
#undef         CLR_SPEC
#define        CLR_SPEC            "N/BG*,N/W*"

FUNCTION Tbr17()
   LOCAL oBrow, oCol, nKey

   LOCAL nOldMaxRow := MAXROW()
   LOCAL nOldMaxCol := MAXCOL()

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SCROLL()
   PushScr()

   SETMODE(50, 80)

   SETCURSOR(SC_NONE)
   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL( 0, 0, MAXROW() - 1, MAXCOL() )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 1, 1, MAXROW() - 18, MAXCOL() - 50 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, FIELDBLOCK("fld1") )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, FIELDBLOCK("fld2") )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, FIELDBLOCK("fld3") )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, FIELDBLOCK("fld4") )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, FIELDBLOCK("fld5") )
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            EXIT

         ELSEIF ( nKey == K_ALT_S )
            SizeIt(oBrow)
            SCROLL( 0, 0, MAXROW() - 1, MAXCOL() )

         ELSEIF ( nKey == K_ALT_M )
            MoveIt(oBrow)
            SCROLL( 0, 0, MAXROW() - 1, MAXCOL() )

         ENDIF

      ENDIF

   END

   PopScr()
   RETURN (NIL)

/*****
 *
 * "Moves" the window
 * MoveIt(oBrowse) --> NIL
 *
 */

FUNCTION MoveIt(oObj)
   // Remember: Objects are passed by REFERENCE
   LOCAL nKey, t, l, b, r

   t := oObj:nTop    
   l := oObj:nLeft   
   b := oObj:nBottom 
   r := oObj:nRight  

   // Screen
   PushScr()
   DISPBOX( t, l, b, r, CHR(219), HI_INTENSITY_BORDER )

   WHILE .T.
      nKey := INKEY(0)

      DISPBEGIN()
      PopScr(.F.)
      PushScr()
      DISPEND()

      IF ( nKey == K_UP )
         IF ( t > 0 )
            --t
            --b

         ENDIF
         
      ELSEIF ( nKey == K_DOWN )
         IF ( b < MAXROW() - 1 )
            ++b
            ++t

         ENDIF

      ELSEIF ( nKey == K_LEFT )
         IF ( l != 0 )
            --l
            --r

         ENDIF

      ELSEIF ( nKey == K_RIGHT )
         IF ( r != MAXCOL() )
            ++r
            ++l

         ENDIF

      ELSEIF ( nKey == K_ENTER )
         EXIT

      ENDIF
   
      DISPBOX( t, l, b, r, CHR(219), HI_INTENSITY_BORDER )

   END

   PopScr(.F.)

   // Objects are passed by REFERENCE
   // When you modify the instance variables
   // nTop, nLeft, nBottom, nRight
   // you are modifying at the b object above
   // because obj has a reference to b
   //
   oObj:nTop    := t
   oObj:nLeft   := l
   oObj:nBottom := b
   oObj:nRight  := r

   RETURN (NIL)

/*****
 *
 * "Sizes" the window
 * SizeIt(<oBrowse>) --> NIL
 *
 */

FUNCTION SizeIt( obj )
   LOCAL nKey, t, l, b, r

   t := obj:nTop   
   l := obj:nLeft  
   b := obj:nBottom
   r := obj:nRight 

   PushScr()
   DISPBOX( t, l, b, r, CHR(219), HI_INTENSITY_BORDER )

   WHILE .T.
      nKey := INKEY(0)

      DISPBEGIN()
      PopScr(.F.)
      PushScr()
      DISPEND()

      IF ( nKey == K_UP )
         t := IF( t > 0, --t, t )
         
      ELSEIF ( nKey == K_DOWN )
         b := IF( b < MAXROW() - 1, ++b, b )

      ELSEIF ( nKey == K_LEFT )
         l := IF( l > 0, --l, l )

      ELSEIF ( nKey == K_RIGHT )
         r := IF( r < MAXCOL(), ++r, r )

      ELSEIF ( nKey == K_SH_UP )
         b := IF( b > (t + 2), --b, b )
         
      ELSEIF ( nKey == K_SH_DOWN )
         t := IF( t < (b - 2), ++t, t )

      ELSEIF ( nKey == K_SH_LEFT )
         r := IF( r > (l + 35), --r, r )

      ELSEIF ( nKey == K_SH_RIGHT )
         l := IF( l < (r - 35), ++l, l )

      ELSEIF ( nKey == K_ENTER )
         EXIT

      ENDIF

      DISPBOX( t, l, b, r, CHR(219), HI_INTENSITY_BORDER )

   END

   PopScr(.F.)

   obj:nTop    := t
   obj:nLeft   := l
   obj:nBottom := b
   obj:nRight  := r

   RETURN (NIL)

// EOF - TBR17.PRG //
