/*****
 *
 * TBR16.PRG
 * Browsing fields of the same database in two TBrowse objects
 * Moving columns between browses
 * Replicating cursor movement in both browse objects
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit       " +;
                                   "TAB - Shift between browses     " +;
                                   "F10 - Move columns"

FUNCTION Tbr16()
   LOCAL oBrow1, oBrow2, oWorkBrow, nKey, oCol
   LOCAL nRecNo

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX("test3")

   SETCURSOR(SC_NONE)
   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   @ MAXROW(), 0 SAY PADC(WHAT_IT_DOES, MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow1 := TBROWSEDB( 1, 1, MAXROW() - 12, MAXCOL() - 1 )
   oBrow1:colSep    := COLSEP
   oBrow1:headSep   := HEADSEP
   oBrow1:footSep   := FOOTSEP
   oBrow1:colorSpec := COLORS_FOR_THE_FIRST_BROWSE

   oBrow2 := TBROWSEDB( MAXROW() - 10, 1, MAXROW() - 2, MAXCOL() - 1 )
   oBrow2:colSep    := COLSEP
   oBrow2:headSep   := HEADSEP
   oBrow2:footSep   := FOOTSEP
   oBrow2:colorSpec := COLORS_FOR_THE_SECOND_BROWSE

   // STEP 2
   oCol := TBCOLUMNNEW( "RECNO()", {|| RECNO()} )
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_BROW_1
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oCol:footing := FOOT_BROW_1
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oCol:footing := FOOT_BROW_1
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oCol:footing := FOOT_BROW_1
   oBrow1:addColumn(oCol)

   oCol := TBCOLUMNNEW( "RECNO()", {|| RECNO()} )
   oBrow2:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   oCol:footing := FOOT_BROW_2
   oBrow2:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_6, {|| test->fld6} )
   oCol:footing := FOOT_BROW_2
   oBrow2:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_7, {|| test->fld7} )
   oCol:footing := FOOT_BROW_2
   oBrow2:addColumn(oCol)

   oBrow1:freeze := 1
   oBrow2:freeze := 1

   ForceStable(oBrow2)
   oBrow2:deHilite()

   // This is going to be the current object
   oWorkBrow := oBrow1

   WHILE .T.
      IF oWorkBrow:colPos <= oWorkBrow:freeze
         oWorkBrow:colPos := oWorkBrow:freeze + 1

      ENDIF

      // STEP 3
      ForceStable(oWorkBrow)

      IF (oWorkBrow:hitTop .OR. oWorkBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)         

      IF !TBMoveCursor(nKey, oWorkBrow)
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_F10 )
            // Current column will be transfered
            // from one browse to another only if you
            // have more than the minumum number of columns
            //
            IF oWorkBrow:colCount > MINIMUM_NUMBER_OF_COLUMNS
               // Take the column out
               oCol := oWorkBrow:delColumn(oWorkBrow:colPos)
               
               IF oWorkBrow == oBrow1
                  // Insert column 
                  oBrow2:insColumn(oBrow2:freeze + 1, oCol)
                  // Watch for for record pointer
                  //
                  DBGOTO(RECNO())
                  // Stabilize
                  ForceStable(oBrow2)
                  oBrow2:deHilite()

               ELSE
                  oBrow1:insColumn(oBrow1:freeze + 1, oCol)
                  DBGOTO(RECNO())
                  ForceStable(oBrow1)
                  oBrow1:deHilite()

               ENDIF

               // To be in the safe side
               ForceStable(oWorkBrow)

            ELSE
               ALERT(MSG_NO_MOVE)

            ENDIF

         ELSEIF ( nKey == K_TAB )
            oWorkBrow:deHilite()
            oWorkBrow := IF(oWorkBrow == oBrow1, oBrow2, oBrow1)
            oWorkBrow:invalidate()
            oWorkBrow:hilite()
      
         ENDIF
   
      ELSE
         // It is necessary that you preserve
         // the current record number of the database
         // before any stabilization is done on the
         // "other" object - whichever one that may be.
         // Remember, that when you STABILIZE() something,
         // the record pointers have moved to the new record
         // that you expect it to be. This will, naturally,
         // reflect a different starting point for the main
         // stabilize() of object "oWorkBrow", above.
         //
			nRecNo := RECNO()      // Save record number
         IF (oWorkBrow == oBrow1)
            TBMoveCursor(nKey, oBrow2)
            ForceStable(oBrow2)
            oBrow2:deHilite()
   
         ELSE
            TBMoveCursor(nKey, oBrow1)
            ForceStable(oBrow1)
            oBrow1:dehilite()

         ENDIF
			DBGOTO( nRecNo ) // Reset record pointer, so that
                          // the stabilize() done on object
                          // "oWorkBrow" STARTS from the ORIGINAL 
                          // starting point, and not from the
                          // NEW record that was reflected by
                          // the ForceStable() above

      ENDIF

   END

   RETURN (NIL)

// EOF - TBR16.PRG //
