/*****
 *
 * TBR14.PRG
 * A "phantom" column in TBrowse
 *
 */

// Include Header Files
#include "inkey.ch"
#include "box.ch"
#include "setcurs.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit"

FUNCTION Tbr14()
   LOCAL oBrow, oCol, nKey

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )
   
   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4})
   oBrow:addColumn(oCol)

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5})
   oBrow:addColumn(oCol)

   oCol := TBCOLUMNNEW()
   oCol:heading := HEAD_PHANTOM
   // Also, add a "picture"
   oCol:block   := {|| TRANSFORM(test->fld4 * test->fld5,;
                                   "999,999,999.99")} 
   oBrow:addColumn(oCol)

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)         

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ENDIF

      ENDIF

   END
   RETURN (NIL)

// EOF - TBR14.PRG //
