/*****
 *
 * TBR12.PRG
 * Using PICTURES for editing
 * Painting the current data row with one color
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit          ENTER - Edit"
                                   
FUNCTION Tbr12()
   LOCAL oBrow, oCol, nKey

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   // width is an instance variable which controls
   // the width of a TBColumn object
   //
   oCol := TBCOLUMNNEW( WHICH_REC, {|| RECNO()} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, FIELDBLOCK("fld2") )
   oCol:cargo := ""
   oCol:width := 10
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, FIELDBLOCK("fld3") )
   oCol:cargo := "@!"
   oCol:width := 30
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, FIELDBLOCK("fld4") )
   oCol:cargo := ""
   oCol:width := 5
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, FIELDBLOCK("fld5") )
   oCol:cargo := "99,999.99"
   oCol:width   := 10
   oBrow:addColumn( oCol )

   oBrow:freeze := 1

   WHILE .T.
      IF ( oBrow:colPos <= oBrow:freeze )
         oBrow:colPos := oBrow:freeze + 1

      ENDIF

      // Regular color
      oBrow:colorRect({oBrow:rowPos,  oBrow:freeze + 1,;
                       oBrow:rowPos, oBrow:colCount}, {1, 1})

      // STEP 3
      DISPBEGIN()
      ForceStable(oBrow)

      // Bar color
      oBrow:colorRect({oBrow:rowPos, oBrow:freeze + 1,;
                   oBrow:rowPos, oBrow:colCount}, {7, 2})
      // Since you are painting a group of cells in a
      // different colour, you should hilite the
      // current cell (specially if you are going to edit)
      oBrow:hilite()
      DISPEND()

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)         

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_ENTER )
            DoGet(oBrow,, (oBrow:getColumn(oBrow:colPos)):cargo)

         ENDIF

      ENDIF

   END

   RETURN (NIL)
  
// EOF - TBR12.PRG //

