/*****
 *
 * TBR09.PRG
 * Fixes the intentional bug in TBR8 and shows 
 * how to use FIELDBLOCK()
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "ESC - Quit             ENTER - Edit"

FUNCTION Tbr9()
   LOCAL oBrow, oCol, nKey

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   // Due to the fact that ahead in this example
   // we will edit the field, we need to assign a get-set
   // block to the object
   //
   // Use FIELDBLOCK("field")
   // FIELDBLOCK() assumes you are using a field in the current
   // work area
   // If you need to use a field in another area 
   // use FIELDWBLOCK()
   //
   oCol := TBCOLUMNNEW( HEAD_1, FIELDBLOCK("fld1") )
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, FIELDBLOCK("fld2") )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, FIELDBLOCK("fld3") )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, FIELDBLOCK("fld4") )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, FIELDBLOCK("fld5") )
   oCol:footing := FOOT_LAST
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      nKey := IncrStable(oBrow)

      IF obrow:stable
         IF ( oBrow:hitTop .OR. oBrow:hitBottom )
            TONE(87.3,1)
            TONE(40,3.5)

         ENDIF

         // STEP 4
         nKey := INKEY(0)

      ENDIF

      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_ENTER )
            DoGet( oBrow )

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * @...GET
 *
 */

STATIC FUNCTION DoGet( oObj )
   LOCAL oCol, oGet, nKey

   PushSets()

   // Cursors are for GETs, so:
   SETCURSOR(SC_NORMAL)
   SET(_SET_SCOREBOARD, .F.)

   // Make sure browse is stable
   ForceStable(oObj)

   oCol := oObj:getColumn( oObj:colPos )

   // Create a corresponding GET and READ it
   oGet := GetNew(ROW(), COL(), oCol:block,;
               oCol:heading,, oObj:colorSpec)
   READMODAL( {oGet} )

   // Force redisplay of current row
   oObj:refreshCurrent()

   // Check exit key
   nKey := LASTKEY()
   IF ( nKey == K_UP .OR. nKey == K_DOWN .OR. ;
      nKey == K_PGUP .OR. nKey == K_PGDN )
      KEYBOARD CHR( nKey )

   ENDIF
   
   PopSets()
   RETURN (NIL)

// EOF - TBR09.PRG //
