/*****
 *
 * TBR07.PRG
 * Using TBrowse:insColumn() and TBrowse:delColumn()
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

#define        WHAT_IT_DOES        "F10 - Insert/Delete column      ESC - Quit"

FUNCTION Tbr7()
   LOCAL oBrow, oCol, nKey
   LOCAL lLogic := .F.

   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   oCol:footing := FOOT_LAST
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_F10 )
            IF lLogic
               lLogic := .F.
               // insColumn is a method which allows a column
               // object to be inserted into the middle of a 
               // browse. The return value is a reference to
               // the column object being inserted
               oBrow:insColumn( oBrow:colPos, oCol )

            ELSE
               lLogic := .T.
               // delColumn is a method which allows a column
               // object to be deleted from a browse. The return 
               // value is a reference to the column object being
               // deleted
               oCol := oBrow:delColumn( oBrow:colPos )

            ENDIF

            // configure()/refreshAll() are automatic when you
            // insert/delete a column

         ENDIF

      ENDIF

   END
   RETURN (NIL)

// EOF - TBR07.PRG //
