/*****
 *
 * TBR05.PRG
 * Using TBColumn:cargo and changing colors 
 * based on a condition given at runtime
 *
 */

#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "samples.ch"
#include "tbrowse.ch"

#define        WHAT_IT_DOES        "F10 - Change colors      ESC - Quit"

FUNCTION Tbr5()
   LOCAL oBrow, oCol, nKey, oTemp

   // Settings
   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // Open files
   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   // Cursors are for GETs, so turn it off
   // The SC_XXXX contants are defined in setcurs.ch
   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )
   @ MAXROW(), 0 SAY PADC( WHAT_IT_DOES,;
                           MAXCOL() + 1) COLOR MSG_ROW_CLR

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep    := COLSEP
   oBrow:headSep   := HEADSEP
   oBrow:footSep   := FOOTSEP
   oBrow:colorSpec := CLR_SPEC

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   oCol:footing := FOOT_LAST
   oCol:colorBlock := {|xBlockParm| ;
                       IF(xBlockParm > 4, { 6, 2 }, {1, 2}) }
   // cargo
   // is an instance variable of ANY DATA TYPE, allowing
   // arbitrary information to be attached to a TBColumn object and
   // retrieved later
   oCol:cargo := {|oObj| Recolor(oObj)}
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      ForceStable(oBrow)

      IF ( oBrow:hitTop .OR. oBrow:hitBottom )
         TONE(87.3,1)
         TONE(40,3.5)

      ENDIF

      // STEP 4
      nKey := INKEY(0)
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ELSEIF ( nKey == K_F10 )
            //
            // colPos returns the number of the current column
            // Columns are numbered for left to right
            //
            // getColumn() will return one reference to a 
            // TBrowse object
            //
            oTemp := oBrow:getColumn( oBrow:colPos )
            //
            // Check to see if you are at the right place
            // oTemp is a reference to the current column
            //
            IF (oTemp:cargo != NIL)
               oTemp:colorBlock := EVAL( oTemp:cargo, oTemp )

               oBrow:configure()
               // Causes the TBrowse object to 
               // re-examine all instance variables and TBColumn 
               // objects, and them reconfigure its internal settings
               // as required

               oBrow:refreshAll()
               // Internally marks all data rows as
               // invalid, causing them to be refilled and redisplayed
               // during the NEXT stabilize loop

            ENDIF

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * Changes colorblock
 *
 */

STATIC FUNCTION Recolor(oCol)
   LOCAL GetList := {}  // For the Get System
   LOCAL nMenu   := 3
   LOCAL nNum    := 0.00
   LOCAL bColorBlock
  
   // Check to see if field is numeric
   IF VALTYPE(EVAL(oCol:block)) == "N"
      // Save screen things
      PushScr()
   
      SET(_SET_SCOREBOARD, .F.)
      SETCOLOR(MENU_CLR)
      SETCURSOR(SC_NORMAL)

       // This is not a beautiful screen but it woks!
      SCROLL( 6, 20, 15, 39 )
      @  6,20 TO 15,39 DOUBLE
      @  7,22 SAY    MENU_SEL 
      @  9,22 PROMPT MENU_LESS
      @ 10,22 PROMPT MENU_GREA
      @ 11,22 PROMPT MENU_EQU 
      MENU TO nMenu

      @ 14,22 SAY MENU_VAL GET nNum PICTURE "999999.99"
      READ

      // Here, you decide what color you 
      // are going to use in your column
      IF nMenu == 1
         bColorBlock := {|nParm| IF(nParm < nNum, { 7, 2 },;
	                          { 1, 2 }) }

      ELSEIF nMenu == 2
         bColorBlock := {|nParm| IF(nParm > nNum, { 6, 2 },;
	                          { 1, 2 }) }

      ELSE
         bColorBlock := {|nParm| IF(nParm == nNum, { 8, 2 },;
	                          { 1, 2 }) }

      ENDIF

      // Restore
      PopScr()

   ENDIF

   // Return the proper block (or NIL)
   RETURN (bColorBlock)

/*****
 *
 * Forces stabilization
 *
 */

STATIC FUNCTION ForceStable(oObj)
   // DISPBEGIN()/DISPEND()
   // They buffer your screen output so,
   // everything is going to show up at
   // the same time
   // This is useful to give the feeling of
   // speed even in slow machines
   DISPBEGIN()
   WHILE !oObj:stabilize()
   END
   DISPEND()
   RETURN (NIL)

// EOF - TBR05.PRG //
