/*****
 *
 * TBR03.PRG
 * Adds column freezing, cursor positioning
 * Cursor movement methods are now into 
 * a user defined function
 *
 */

// Include Header Files
#include "inkey.ch"
#include "setcurs.ch"
#include "box.ch"

#include "tbrowse.ch"
#include "samples.ch"

FUNCTION Tbr3()
   LOCAL oBrow, oCol, nKey

   // Settings
   SET(_SET_PATH, WHERE_TO_FIND_FILES)

   // Open files
   DBUSEAREA( NEW, "DbfNtx", "test" )
   DBSETINDEX( "test3" )

   // Cursors are for GETs, so turn it off
   // The SC_XXXX contants are defined in setcurs.ch
   SETCURSOR(SC_NONE)

   SETBLINK(.F.)
   SETCOLOR(BGND_CLR)
   SCROLL()
   SETCOLOR(BROW_CLR)       
   SCROLL( 2, 6, MAXROW() - 2, MAXCOL() - 7 )
   DISPBOX( 2, 6, MAXROW() - 2, MAXCOL() - 7, B_DOUBLE )

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, MAXROW() - 3, MAXCOL() - 8 )
   oBrow:colSep  := COLSEP
   oBrow:headSep := HEADSEP
   oBrow:footSep := FOOTSEP

   // STEP 2
   oCol := TBCOLUMNNEW( HEAD_1, {|| test->fld1} )
   // Footer for this column
   oCol:footing := FOOT_FIRST
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_2, {|| test->fld2} )
   oBrow:addColumn( oCol )
   
   oCol := TBCOLUMNNEW( HEAD_3, {|| test->fld3} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_4, {|| test->fld4} )
   oBrow:addColumn( oCol )

   oCol := TBCOLUMNNEW( HEAD_5, {|| test->fld5} )
   // Footer for this column
   oCol:footing := FOOT_LAST
   oBrow:addColumn( oCol )

   // One useful thing: freeze one or more columns on the
   // screen. You could accomplish this using the instance
   // variable freeze. It defines the number of data columns
   // frozen on the left side of the display
   oBrow:freeze := 1

   // If later you need to "defrost" the column, just 
   // use b:freeze := 0
              
   WHILE .T.

      // Do not allow cursor to move into frozen columns
      // (This is Optional!)
      // You will use the instance variable colPos to get
      // current cursor column position and assign it
      IF ( oBrow:colPos <= oBrow:freeze )
         oBrow:colPos := oBrow:freeze + 1

      ENDIF

      // STEP 3
      WHILE ( !oBrow:stabilize() )
         nKey := INKEY()
         IF ( nKey != 0 )
            EXIT // abort if a key is waiting

         ENDIF

      END

      IF ( oBrow:stable )
         // Is always a good idea tell the user about
         // end or beginning of file
         // oBrow:hitTop contais a .T. if an attempt was made 
         // to navigate beyond the beginning of data source
         // oBrow:hitBottom contais a .T. if an attempt was made
         // to navigate beyond the end of data source

         IF ( oBrow:hitTop .OR. oBrow:hitBottom )
            TONE(87.3,1)
            TONE(40,3.5)

         ENDIF
         nKey := INKEY(0)         

      ENDIF

      // STEP 4
      IF !TBMoveCursor( nKey, oBrow )
         IF ( nKey == K_ESC )
            SCROLL()
            EXIT

         ENDIF

      ENDIF

   END
   RETURN (NIL)

/*****
 *
 * Cursor Movement Methods
 *
 */

STATIC FUNCTION TBMoveCursor( nKey, oBrow )
   LOCAL nFound
   // Declaring this array as static will speed things up,
   // since Clipper will not create/destroy it every time
   // you call this function
   STATIC aKeys := ;
       { K_DOWN      , {|obj| obj:down()},;
         K_UP        , {|obj| obj:up()},;
         K_PGDN      , {|obj| obj:pageDown()},;
         K_PGUP      , {|obj| obj:pageUp()},;
         K_CTRL_PGUP , {|obj| obj:goTop()},;
         K_CTRL_PGDN , {|obj| obj:goBottom()},;
         K_RIGHT     , {|obj| obj:right()},;
         K_LEFT      , {|obj| obj:left()},;
         K_HOME      , {|obj| obj:home()},;
         K_END       , {|obj| obj:end()},;
         K_CTRL_LEFT , {|obj| obj:panLeft()},;
         K_CTRL_RIGHT, {|obj| obj:panRight()},;
         K_CTRL_HOME , {|obj| obj:panHome()},;
         K_CTRL_END  , {|obj| obj:panEnd()} }

   nFound := ASCAN( aKeys, nKey )
   IF (nFound != 0)
      EVAL( aKeys[++nFound], oBrow )

   ENDIF
   RETURN (nFound != 0)

// EOF - TBR03.PRG //
