/*****
 *
 * TBR02.PRG
 * Same as TBR1 with a keystroke handler,
 * heading and column separators.
 *
 */

// This will make handling keystrokes 
// a lot easier!
#include "inkey.ch"

FUNCTION Tbr2()
   LOCAL oBrow, oCol, nKey

   USE \browsers\database\test INDEX \browsers\database\test3 NEW

   SETCOLOR("N/W")
   SCROLL()
   SETCOLOR("W+/BG,GR+/B")
   SCROLL( 2, 6, 22, 72 )
   @ 2, 6 TO 22,72 DOUBLE

   // STEP 1
   oBrow := TBROWSEDB( 3, 7, 21, 71 )

   // This time, we will use header and columns separators:
   // colSep contains an optional character used to draw a 
   // vertical separator if there is another column to the
   // left of it.
   // headSep contains an optional character string used
   // to draw a horizontal separator between the heading and
   // data values.

   oBrow:headSep := CHR(205) + CHR(209) + CHR(205) // 
   oBrow:colSep  := CHR(32) + CHR(179) + CHR(32)   //  

   // STEP 2
   // This example uses five fields.
   oCol := TBCOLUMNNEW( "Field 1", {|| test->fld1} )
   oBrow:addColumn( oCol )
   oCol := TBCOLUMNNEW( "Field 2", {|| test->fld2} )
   oBrow:addColumn( oCol )
   oCol := TBCOLUMNNEW( "Field 3", {|| test->fld3} )
   oBrow:addColumn( oCol )
   oCol := TBCOLUMNNEW( "Field 4", {|| test->fld4} )
   oBrow:addColumn( oCol )
   oCol := TBCOLUMNNEW( "Field 5", {|| test->fld5} )
   oBrow:addColumn( oCol )

   WHILE .T.
      // STEP 3
      // Stabilization
      WHILE ( !oBrow:stabilize() )
         nKey := INKEY()
         IF ( nKey != 0 )
            EXIT // abort stabilization if a key is waiting

         ENDIF

      END

      // stable is an instance variable which reports
      // if the TBrowse object is stable
      IF ( oBrow:stable )
         nKey := INKEY(0)

      ENDIF
      // Up to this point nothing changed. But we need to
      // include a keystroke handler to handle our cursor
      // movement methods

      // STEP 4
      // Process a key.
      // Choose the cursor movement method
      // based on the key pressed
      // The key definitions K_XXXX
      // are in inkey.ch header file
      IF ( nKey == K_DOWN )
         oBrow:down()

      ELSEIF ( nKey == K_UP )
         oBrow:up()

      ELSEIF ( nKey == K_PGDN )
         oBrow:pageDown()

      ELSEIF ( nKey == K_PGUP )
         oBrow:pageUp()

      ELSEIF ( nKey == K_CTRL_PGUP )
         oBrow:goTop()

      ELSEIF ( nKey == K_CTRL_PGDN )
         oBrow:goBottom()

      ELSEIF ( nKey == K_RIGHT )
         oBrow:right()

      ELSEIF ( nKey == K_LEFT )
         oBrow:left()

      ELSEIF ( nKey == K_HOME )
         oBrow:home()

      ELSEIF ( nKey == K_END )
         oBrow:end()

      ELSEIF ( nKey == K_CTRL_LEFT )
         oBrow:panLeft()

      ELSEIF ( nKey == K_CTRL_RIGHT )
         oBrow:panRight()

      ELSEIF ( nKey == K_CTRL_HOME )
         oBrow:panHome()

      ELSEIF ( nKey == K_CTRL_END )
         oBrow:panEnd()

      ELSEIF ( nKey == K_ESC )
         SCROLL()
         EXIT

      ENDIF

   END
   RETURN (NIL)

// EOF - TBR02.PRG //
