/*****
 *
 * TBR01.PRG
 * Shows data on the screen. Quits when key is pressed.
 *
 */

FUNCTION Tbr1()
   // Your variables
   LOCAL oBrow, oCol, nKey

   // First open your files
   // Use NEW in lieu of SELECT 0
   USE \browsers\database\test INDEX \browsers\database\test3 NEW

   // Colors
   SETCOLOR("N/W")
   SCROLL()
   SETCOLOR("W+/BG,GR+/B")

   // STEP 1
   // Create a TBrowse object
   // TBrowseDB( top, left, bottom, right ) ===> Object
   //
   oBrow := TBROWSEDB( 3, 7, 21, 71 )

   // Note that TBrowseDB() creates an object with no column
   // objects. In order to make the object usable, a column 
   // must be added for each field to display.
   // This example uses three fields.

   // STEP 2
   // Create TBColumn object and add it to TBrowse
   //
   // TBColumnNew( cHeading, bBlock ) =====> Object
   // Returns a new column object with specified heading 
   // and data retrieval block

   oCol := TBCOLUMNNEW( "Field 1", {|| test->fld1} )

   // addColumn( objColumn ) =====> self
   // Adds a new column object to the browse object and 
   // TBrowse:colCount is increased by one.

   oBrow:addColumn( oCol )

   // Repeat the same to the other fields
   oCol := TBCOLUMNNEW( "Field 2", {|| test->fld2} )
   oBrow:addColumn( oCol )
   oCol := TBCOLUMNNEW( "Field 3", {|| test->fld3} )
   oBrow:addColumn( oCol )

   // Time to put this thing to work
   WHILE .T.
      // STEP 3
      // Stabilize TBrowse object (display it on the screen)
      //
      // stabilize() =====> lStable
      // Performs incremental stabilization. Stabilization is 
      // performed in increments so that it can be interrupted
      // by any asynchronous event.
      // A value of .T. is returned indicating the object 
      // is stable

      WHILE ( !oBrow:stabilize() )
      END

      // STEP 4
      // Wait for a key
      //
      nKey := INKEY(0)

      // Key pressed, get out of here
      EXIT

   END
   RETURN (NIL)

// EOF - TBR01.PRG //
