*
SET HEADING OFF
SET SAFETY OFF
* = file is TALLY.CMD  rev 1.10    01/05/83  10pm
SET TALK OFF
SET INTENSITY OFF
STORE .T. TO NO_DRIVE
DO WHILE NO_DRIVE
* ---clear any files currently in use ---------------
SELE B
USE
SELE A
USE
CLEAR
?
? '                      dBASE III PROGRAM - TALLY'
? '==========================================================================='
? 'This program will analyze a given field in a dBASE III file, and list the'
? 'number of occurrences for each unique value within that field - i.e.'
? 'You could list the number of occurrences (records) for each state.'
?
? 'NOTE: If you have a large file (2000-3000 rec.) and very few like values'
? '      this run will take about as long as building an index for the field.'
?
? '==========================================================================='
? '                                        Richard F. Malm  rev. 1.10 (1/5/85)'
STORE ' ' TO DRIVE
@ 15,0 SAY 'ENTER DRIVE WHICH YOUR FILE IS ON - OR BLANK TO QUIT ' GET DRIVE
READ
STORE UPPER(DRIVE) TO DRIVE
IF DRIVE = ' '
   STORE .F. TO NO_DRIVE
   LOOP
ENDIF
SET DEFA TO &DRIVE
STORE .T. TO NO_FILE
DO WHILE NO_FILE
   CLEAR
   ? '------ DBASE FILES ON DRIVE &DRIVE -------'
   ?
   DISP FILES
   STORE '        ' TO FILE
   @ 24,0 SAY 'ENTER FILE NAME FOR TALLY - OR BLANK FOR NEW DRIVE ' GET FILE
   READ
   STORE UPPER(FILE) TO FILE
   IF FILE = ' '
      STORE .F. TO NO_FILE
      LOOP
   ENDIF
   STORE FILE+'.DBF' TO CK_FILE
   IF .NOT. FILE('&CK_FILE')
      ?
      ? 'Sorry I did not list that file .....'
      STORE 0 TO COUNT
      DO WHILE COUNT # 50
         STORE COUNT + 1 TO COUNT
      ENDDO
      LOOP
   ELSE
      STORE .F. TO NO_FILE
   ENDIF
ENDDO WHILE NO_FILE
* ---if no file selected try for another drive---
IF FILE = ' '
   STORE .F. TO NO_FILE
   LOOP
ENDIF
* -----------------------------------------------
USE &FILE
COPY STRU EXTENDED TO STRU
USE STRU
GO BOTTOM
STORE RECNO() TO MaxItem
STORE .T. TO NoItem
DO WHILE NoItem
   CLEAR
   ? '- FOLLOWING IS A DIRECTORY OF YOUR DATA BASE -'
   ?
   ? 'ITEM #   ITEM NAME'
   ? '======   ========='
   DISP ALL
   ?
   STORE '  ' TO ITEM_NO
   @ 24,0 SAY 'Enter item number for TALLY ' GET ITEM_NO
   READ
   IF ITEM_NO = ' '
      STORE .F. TO NoItem
      LOOP
   ENDIF
   IF VAL(ITEM_NO) < 1 .OR. VAL(ITEM_NO) > MaxItem
      ?
      ? 'Please enter a number between 1 and',MaxItem,'.....'
      STORE 0 TO COUNT
      DO WHILE COUNT # 50
         STORE COUNT + 1 TO COUNT
      ENDDO
      LOOP
   ELSE
      STORE .F. TO NoItem
ENDDO WHILE NoItem
* ----if no item go back for new drive or to quit------
IF ITEM_NO = ' '
   LOOP
ENDIF
* -----------------------------------------------------
GOTO &ITEM_NO
            * store item info to mem var
STORE FIELD_NAME TO FD_NAME
STORE FIELD_TYPE TO FD_TYPE
STORE FIELD_LEN TO FD_LEN
STORE FIELD_DEC TO FD_DEC
?
? 'Doing setup ...'
*
GO TOP
DO WHILE .NOT. EOF()
   DELETE
   SKIP
ENDDO
PACK
APPEND BLANK
REPLACE FIELD_NAME WITH 'ITEM_COUNT'
REPLACE FIELD_TYPE WITH 'N'
REPLACE FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH 'ITEM'
REPLACE FIELD_TYPE WITH 'C'
REPLACE FIELD_LEN WITH FD_LEN
USE
IF FILE('tallywk.DBF')
   DELETE FILE tallywk.DBF
ENDIF
CREATE &drive.:tally-wk from stru
use
DELETE FILE STRU.DBF
SELE A
  USE &FILE
  GO TOP
SELE B
  USE tally-wk
STORE .T. TO FIRST_TM
SELE A
STORE 0 TO REC
DO WHILE .NOT. EOF()
STORE REC+1 TO REC
IF REC=50
   STORE 0 TO REC
   DISP 'Records processed'
ENDIF
   * if item of interest is numeric convert to a string
   IF FD_TYPE='N'
      STORE STR(&FD_NAME,FD_LEN,FD_DEC) TO STRING
   ELSE
      STORE &FD_NAME TO STRING
   ENDIF
   SELE B
*
   IF FIRST_TM = .T.
      APPEND BLANK
      REPLACE ITEM_COUNT WITH 1
      REPLACE ITEM WITH STRING
      INDEX ON ITEM TO tally-wk
      STORE .F. TO FIRST_TM
      CLEAR
      ? 'Reading data file....'
   ELSE
      FIND '&STRING'
      IF .NOT. (EOF() .OR. BOF())
         REPLACE ITEM_COUNT WITH ITEM_COUNT+1
      ELSE
         APPEND BLANK
         REPLACE ITEM_COUNT WITH 1
         REPLACE ITEM WITH STRING
       ENDIF
   ENDIF FIRST_TM
         SELE A
         SKIP
ENDDO WHILE.NOT. EOF
SELE B
USE tally-wk
GO BOTTOM
STORE RECNO() TO REC_COUNT
SET INDEX TO tally-wk
CLEAR
?
? 'Would you like a printer copy of count and variables in'
ACCEPT 'in alphabetic order ? (Y/ENTER)' TO QUESTION
IF SUBSTR(UPPER(QUESTION),1) = 'Y'
   STORE ' ' TO DUMMY
   @ 5,0 SAY 'Turn the printer on and push <ENTER>' GET DUMMY
   READ
   SET PRINT ON
ENDIF
CLEAR
DISP 'LIST OF COUNT AND',TRIM(FD_NAME),', IN NAME ORDER - file is &FILE' OFF
? '       COUNT   VAR. NAME'
? '       =====   ========='
STORE 0 TO COUNT
STORE ' ' TO STOP_NOW
GO TOP
DO WHILE .NOT. EOF()
   DISP ITEM_COUNT,'  ',ITEM OFF
   SKIP
   STORE COUNT+1 TO COUNT
   IF COUNT = 19
      STORE 0 TO COUNT
      ?
      @ 24,0 SAY 'Push enter to continue or (S to stop)' GET STOP_NOW
      READ
      IF UPPER(STOP_NOW)='S'
         GO BOTTOM
      ENDIF
   ENDIF COUNT=19
ENDDO WHILE .NOT. EOF
STORE ' ' TO DUMMY
?
@ 24,0 SAY 'Push ENTER to continue....' GET DUMMY
READ
SET PRINT OFF
CLEAR
?
? 'Re-indexing by item count...'
INDEX ON STR(ITEM_COUNT,5)+SUBSTR(ITEM,1,5) TO tyitem
SET INDEX TO tyitem
CLEAR
?
ACCEPT 'Would you like a printer copy in max. count order (Y/ENTER)' TO QUESTION
IF SUBSTR(UPPER(QUESTION),1) = 'Y'
   STORE ' ' TO DUMMY
   @ 4,0 SAY 'Turn the printer on and push <enter>' GET DUMMY
   READ
   SET PRINT ON
ENDIF
CLEAR
DISP 'LIST OF COUNT AND',TRIM(FD_NAME),', IN MAX. COUNT ORDER - file is &FILE' OFF
? '       COUNT   VAR. NAME'
? '       =====   ========='
STORE REC_COUNT TO REC_NO
STORE 0 TO COUNT
STORE ' ' TO STOP_NOW
GO BOTTOM
DO WHILE REC_NO > 0
   DISP ITEM_COUNT,'  ',ITEM OFF
   SKIP-1
   STORE COUNT+1 TO COUNT
   STORE REC_NO-1 TO REC_NO
   IF COUNT = 19
      STORE 0 TO COUNT
      ?
      @ 24,0 SAY 'Push ENTER to continue (S to stop)' GET STOP_NOW
      READ
      IF UPPER(STOP_NOW)='S'
         STORE 0 TO REC_NO
      ENDIF
   ENDIF
ENDDO WHILE REC_NO > 0
STORE ' ' TO STOP_NOW
?
@ 24,0 SAY 'Push ENTER to continue....' GET STOP_NOW
READ
USE
SET PRINT OFF
*!! There will be no automatic colon following this prompt string.
ACCEPT 'Should I delete all work files (Y/ENTER) ?' to QUESTION
IF SUBSTR(UPPER(QUESTION),1)='Y'
   USE
   DELETE FILE tally-wk.DBF
   DELETE FILE tally-wk.NDX
   DELETE FILE tyitem.NDX
   ? 'All work files deleted...'
ENDIF
SELE A
USE
ENDDO WHILE NO_DRIVE
SET TALK ON
SET INTENSITY ON
RETURN
