* Program: SysTest.PRG
*  Notice: Placed in the Public Domain on August 4, 1993.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        FAX: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXFORUM 3rd-Party section or MAIL
*  Update: Version 1.00 -- August 4, 1993
*        : Version 1.01 -- September 1, 1993
*        : Version 1.02 -- December 1, 1993
*        : Version 1.10 -- July 8, 1994
*  Action: For testing system configuration limits in FoxPro
*        :    on all platforms where FoxPro runs.
*  Syntax: DO SysTest [WITH <C method>]
*        : <method> = "SYS" | "SET" | "ON" | "MIS" | "VAR" |
*        :            "FILE" | "CONFIG" | "GRAPHIC" | "FONT"
*        :            Default <method> is all of the methods
*   Notes: Requires FoxPro version 2.5 or greater for DOS,
*        :    Windows, Macintosh, or UNIX.
*

* Preprocessor directives.
#define cSYSTESTVERS    "1.10"
#define cBOOTDRIVE      "C:"
#define cEQUALS         " == "
#define cMAXFILESOPEN    255
#define cMAXSYSFUNC     2100
#define cMAXSYSMETRIC     34
#define cMESSAGEWRITE   "*** " + cMESSAGE + ": ***"
#define cMSGSTART       "*** SysTest version", cSYSTESTVERS,;
                        "on", DATE(), "at", TIME(), "***"
#define cMSGENDFILE     "*** Testing Complete ***"
#define cMSGENDWAIT     "Test complete and results written to "
#define cMSGNOOPEN      "Cannot open file."
#define cMSGNOFIND      "Cannot find file."
#define cMSGFILEOPEN    "Files Open: "
#define cMSGFILEERROR   "Error Opening: "
#define cMSGFILEREPORT  "Error Reported: "
#define cMSGFILECLOSE   "Closing Open Files"
#define cMSGFILEHANDLES "No more available OS file handles"
#define cPADRLEN        22
#define cOUTPUTFILE     IIF(_UNIX,"systest.txt","SysTest.TXT")
#define cSKIPSYSFUNC    3,998,999,1020,1021,1022,1037,;
                        2002,2008,2009,2013,2015,2017,2027

* Begin code.
PARAMETERS T__Method
RELEASE ALL EXCEPT T__*
PRIVATE ALL LIKE T__*

* Set up.
SET TALK OFF
CLOSE ALL
SET SAFETY OFF
SET ALTERNATE TO cOUTPUTFILE
SET ALTERNATE ON
SET SAFETY ON
ON ERROR STORE .T. TO T__IsError
SET EXACT OFF

IF _DOS OR _UNIX  && character platforms
   DEFINE WINDOW T__win FROM 0,0 TO 5,5;
      TITLE cOUTPUTFILE CLOSE FLOAT SYSTEM COLOR SCHEME 8
ELSE              && graphical platforms _WINDOWS and _MAC
   DEFINE WINDOW T__win FROM 0,0 TO 5,5;
      TITLE cOUTPUTFILE CLOSE FLOAT SYSTEM
ENDIF
ZOOM WINDOW T__win MAX
ACTIVATE WINDOW T__win
?? cMSGSTART

* SYS() functions.
STORE .F. TO T__IsError, T__IsFoxHelp
IF EMPTY(m.T__Method) OR UPPER(m.T__Method)="SYS"
   #define cMESSAGE "Testing SYS() Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   DECLARE T__SysTopics[1]
   T__SysTopics = ""
   SET HELP OFF
   SELECT FoxHelp.Topic;
      FROM (SYS(2004)+"FoxHelp.dbf");
      INTO ARRAY T__SysTopics;
      WHERE FoxHelp.Topic = "SYS("
   IF USED("FoxHelp")
      T__IsFoxHelp = .T.
      USE IN FoxHelp
   ENDIF
   SET HELP ON
   FOR T__i = 0 TO cMAXSYSFUNC
      IF INLIST(m.T__i, cSKIPSYSFUNC)
         LOOP
      ENDIF
      T__IsError = .F.
      IF NOT EMPTY(SYS(m.T__i))
         IF NOT m.T__IsError
            T__scan = ASCAN(T__SysTopics,;
                            "SYS("+LTRIM(STR(m.T__i))+") ")
            ? "SYS(" + STR(m.T__i,4) + ") " +;
              PADR(IIF(m.T__scan==0,;
                      IIF(m.T__IsFoxHelp,"Undocumented",""),;
                      ALLTRIM(SUBSTR(T__SysTopics[T__scan],;
                           AT(" ",T__SysTopics[T__scan])))),;
                      cPADRLEN)+;
              cEQUALS + SYS(m.T__i)
         ENDIF
      ENDIF
   ENDFOR
   RELEASE T__scan, T__SysTopics, T__i
   #undef cMESSAGE
ENDIF

* Open Systest.dbf and filter on current platform for SET(),
* ON(), system variables, and miscellaneous functions.
USE (LOCFILE("SysTest.dbf", "DBF", "Where is SysTest.dbf?"));
    NOUPDATE
DO CASE
   CASE _DOS
      SET FILTER TO Is_DOS
   CASE _WINDOWS
      SET FILTER TO Is_Windows
   CASE _MAC
      SET FILTER TO Is_Mac
   CASE _UNIX
      SET FILTER TO Is_UNIX
ENDCASE
T__TempIdx = SYS(3)+".idx"
SET SAFETY OFF
INDEX ON Class+Keyword TO (m.T__TempIdx)
SET SAFETY ON

* SET() functions.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="SET");
      AND USED("SysTest")
   #define cMESSAGE "Testing SET() Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   SCAN FOR Class="SET"
      ? PADR("SET("+TRIM(Keyword)+")", cPADRLEN)+;
        cEQUALS, SET(TRIM(Keyword))
      IF Is_Option
         ? PADR("SET("+TRIM(Keyword)+",1)", cPADRLEN)+;
           cEQUALS, SET(TRIM(Keyword),1)
      ENDIF
   ENDSCAN
   #undef cMESSAGE
ENDIF

* ON() functions.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="ON");
      AND USED("SysTest")
   #define cMESSAGE "Testing ON() Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   SCAN FOR Class="ON"
      ? PADR("ON("+TRIM(Keyword)+")", cPADRLEN)+;
        cEQUALS, ON(TRIM(Keyword))
   ENDSCAN
   #undef cMESSAGE
ENDIF

* Miscellaneous configuration functions.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="MIS");
      AND USED("SysTest")
   #define cMESSAGE "Testing Miscellaneous Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   SCAN FOR Class="MIS"
      ? PADR(TRIM(Keyword), cPADRLEN)+;
        cEQUALS, EVALUATE(TRIM(Keyword))
   ENDSCAN
   #undef cMESSAGE
ENDIF

* System memory variables.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="VAR");
      AND USED("SysTest")
   #define cMESSAGE "Testing System Memory Variables"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   SCAN FOR Class="VAR"
      ? PADR(TRIM(Keyword), cPADRLEN)+;
        cEQUALS, EVALUATE(TRIM(Keyword))
   ENDSCAN
   #undef cMESSAGE
ENDIF

USE IN SysTest
ERASE (m.T__TempIdx)

* SYSMETRIC() and WFONT() functions.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="GRAPHIC") AND;
   (_WINDOWS OR _MAC)
   #define cMESSAGE "Testing SYSMETRIC() Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   DECLARE T_help[1]
   T_help = ""
   SET HELP OFF
   SELECT FoxHelp.Details;
      FROM (SYS(2004)+"FoxHelp.dbf");
      INTO ARRAY T_help;
      WHERE FoxHelp.Topic = "SYSMETRIC("
   IF USED("FoxHelp")
      USE IN FoxHelp
   ENDIF
   SET HELP ON
   T_help[1] = STRTRAN(T_help[1], CHR(9), " ")
   DECLARE T__array[cMAXSYSMETRIC]
   T__array = ""
   STORE 0 TO _MLINE, T__len
   FOR T__i = 1 TO MEMLINES(T_help[1])
      T__string = ALLTRIM(MLINE(T_help[1], 1, _MLINE))
      IF VAL(m.T__string)>0
         T__array[VAL(m.T__string)] =;
            LTRIM(SUBSTR(m.T__string, AT(" ", m.T__string)))
         IF LEN(T__array[VAL(m.T__string)])>m.T__len
            T__len = LEN(T__array[VAL(m.T__string)])
         ENDIF
      ENDIF
   ENDFOR
   IF m.T__len==0
      T__len = 8
   ENDIF
   FOR T__i = 1 TO cMAXSYSMETRIC
      ? "SYSMETRIC(" + STR(m.T__i,2) + ") " +;
        PADR(T__array[m.T__i], m.T__len)+;
        cEQUALS + STR(SYSMETRIC(m.T__i),4)
   ENDFOR
   #undef cMESSAGE
   #define cMESSAGE "Testing WFONT() Functions"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   FOR T__i = 1 TO 3
      ? PADR("WFONT("+STR(m.T__i,1)+', "")', cPADRLEN)+;
        cEQUALS, WFONT(m.T__i, "")
   ENDFOR
   RELEASE T__i, T_help, T__string, T__array, T__len
   #undef cMESSAGE
ENDIF

* Available fonts and sizes.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="FONT") AND;
      (_WINDOWS OR _MAC)
   #define cMESSAGE "Testing Available Fonts"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   =AFONT(T__fonts)
   FOR T__i = 1 TO ALEN(T__fonts)
      T__string = T__fonts[m.T__i] + ": "
      IF AFONT(T__sizes, T__fonts[m.T__i])
         FOR T__j = 1 TO ALEN(T__sizes)
            T__string = m.T__string+;
               IIF(m.T__j==1, "", ", ")+;
               IIF(T__sizes[m.T__j]==-1,;
                   "scalable", LTRIM(STR(T__sizes[m.T__j])))
         ENDFOR
      ENDIF
      ? m.T__string
   ENDFOR
   RELEASE T__i, T__j, T__fonts, T__sizes, T__string
   #undef cMESSAGE
ENDIF

* File contents of Config.fp? and OS configuration files.
T__IsError = .F.
IF (EMPTY(m.T__Method) OR UPPER(m.T__Method)="CONFIG")
   FOR T__i = 1 TO 3
      DO CASE
         CASE m.T__i==1
            T__file = SYS(2019)
            IF EMPTY(m.T__file)
               IF _UNIX
                  T__file = "config.fpu"
               ELSE
                  T__file = SYS(2004)+"CONFIG.FP"+;
                     IIF(_WINDOWS, "W", IIF(_MAC, "M", ""))
               ENDIF
            ENDIF
         CASE m.T__i==2
            DO CASE
               CASE _MAC  && test only Config.fpm
                  EXIT
               CASE _UNIX
                  * Files beginning with a dot (.) cannot be
                  * opened, so copy to temp file and open it.
                  RUN cp $HOME/.profile /tmp/profile.tmp
                  *///Pipe thru SED to add CR?
                  T__file = "/tmp/profile.tmp"
               OTHERWISE  && dos or windows
                  T__file = cBOOTDRIVE + "\CONFIG.SYS"
            ENDCASE
         CASE m.T__i==3
            DO CASE
               CASE _UNIX
                  * Files beginning with a dot (.) cannot be
                  * opened, so copy to temp file and open it.
                  RUN cp $ENV /tmp/shell.tmp
                  *///Pipe thru SED to add CR?
                  T__file = "/tmp/shell.tmp"
               OTHERWISE  && dos or windows
                  T__file = cBOOTDRIVE + "\AUTOEXEC.BAT"
            ENDCASE
      ENDCASE
      * IIF is for 2.5 compatibility without SYS(2027).
      #define cMESSAGE "Testing File "+;
                       IIF(_MAC OR _UNIX,;
                           SYS(2027,m.T__file), m.T__file)
      WAIT WINDOW NOWAIT cMESSAGE
      ?
      ? cMESSAGEWRITE
      IF FILE(m.T__file)
         T__handle = FOPEN(m.T__file)
         IF m.T__handle>-1
            DO WHILE NOT FEOF(m.T__handle)
               ? FGETS(m.T__handle)
            ENDDO
            =FCLOSE(m.T__handle)
            IF _UNIX AND m.T_i>1
               * Remove temp files used to read
               * profile and shell.
               ERASE (m.T__file)
            ENDIF
         ELSE
            ? cMSGNOOPEN
         ENDIF
      ELSE
         ? cMSGNOFIND
      ENDIF
   ENDFOR

   * Run OS-specific utilities.
   DO CASE
      CASE _UNIX  && read vmstat output
         T__file = "/tmp/vmstat.tmp"
         WAIT WINDOW NOWAIT cMESSAGE
         ?
         ? cMESSAGEWRITE
         RUN vmstat -s > &T__file
         T__handle = FOPEN(m.T__file)
         IF m.T__handle>-1
            DO WHILE NOT FEOF(m.T__handle)
               ? FGETS(m.T__handle)
            ENDDO
            =FCLOSE(m.T__handle)
            ERASE (m.T__file)
         ELSE
            ? cMSGNOOPEN
         ENDIF
   ENDCASE
   RELEASE T__file, T__handle, T__i
   #undef cMESSAGE
ENDIF

* File opening.
T__IsError = .F.
IF EMPTY(m.T__Method) OR UPPER(m.T__Method)="FILE"
   #define cMESSAGE "Testing Open Files"
   WAIT WINDOW NOWAIT cMESSAGE
   ?
   ? cMESSAGEWRITE
   ?
   * The open Alternate file counts as one file, and this
   * compiled program may count as one file because it's
   * already open when run right after the prg is modified.
   T__offset = FOPEN(PROGRAM()+".FXP", 11)
   IF m.T__offset==-1
      T__offset = 2
   ELSE
      =FCLOSE(m.T__offset)
      T__offset = 1
   ENDIF

   T__ErrorNo  = 0
   T__ErrorMsg = ""
   SET SAFETY OFF
   DECLARE T__files[cMAXFILESOPEN]
   FOR T__i = 1 TO cMAXFILESOPEN
      T__files[m.T__i] = SYS(3)
      CREATE TABLE (T__files[m.T__i]) (Temp C(1))
      IF m.T__IsError
         T__ErrorNo  = LTRIM(STR(ERROR()))
         T__ErrorMsg = IIF(ERROR()==0,;
                           cMSGFILEHANDLES, TRIM(MESSAGE(1)))
         EXIT
      ELSE
         @ ROW(), 0 SAY cMSGFILEOPEN+;
                        STR(m.T__i+m.T__offset, 3)
      ENDIF
   ENDFOR
   SET SAFETY ON
   @ ROW(), 0 SAY ""
   ?? cMSGFILEOPEN   + STR(m.T__i-1+m.T__offset, 3), " ",;
      cMSGFILEERROR  + STR(m.T__i+m.T__offset, 3)
   ?  cMSGFILEREPORT + T__ErrorNo, T__ErrorMsg
   WAIT WINDOW NOWAIT cMSGFILECLOSE
   FOR T__i = 1 TO cMAXFILESOPEN
      IF EMPTY(T__files[m.T__i])
         EXIT
      ENDIF
      USE IN (m.T__i)
      IF FILE(T__files[m.T__i]+".DBF")
         ERASE (T__files[m.T__i]+".DBF")
      ENDIF
   ENDFOR
   RELEASE T__offset, T__files, T__i, T__ErrorNo, T__ErrorMsg
   #undef cMESSAGE
ENDIF

* Close alternate file and remove end-of-file marker CHR(26).
SET CONSOLE OFF
?
? cMSGENDFILE
SET CONSOLE ON
ON ERROR
CLOSE ALL
T__handle = FOPEN(cOUTPUTFILE, 2)
IF NOT m.T__handle==-1
   =FSEEK(m.T__handle, -1, 2)
   IF FREAD(m.T__handle,1)==CHR(26)
      =FCHSIZE(m.T__handle, FSEEK(m.T__handle, -1, 2))
   ENDIF
   =FCLOSE(m.T__handle)
ENDIF

* Clean up and exit.
ACTIVATE SCREEN
SET TALK ON
RELEASE WINDOW T__win
WAIT WINDOW NOWAIT cMSGENDWAIT + cOUTPUTFILE
MODIFY COMMAND cOUTPUTFILE NOEDIT
RETURN
*** SysTest.prg *********************************************