******************************************************************************
*                                                                            *
*       This is a group of FoxBASE+/dBASE IV UDFs which return system        *
*       information using BIN routines.  I wrote these things as part        *
*       of preliminary work for a library of UDFs for dBASE IV that I        *
*       am writing for Ashton-Tate.  However, the library has been re-       *
*       positioned as an add-on for the Professional Compiler, so I          *
*       hereby release these into the public domain.  ITOH() and HTOI()      *
*       are in here just, well, because they're in here, don't ask           *
*       me why [grin].                                                       *
*                                                                            *
*       I do not guarantee these UDFs or the associated BIN routines,        *
*       nor will I bear any responsibility for the results you obtain.       *
*       They have not been thoroughly tested, but they appear to work        *
*       just fine.  If you examine the code, you will see that they can      *
*       also be used from dBASE III Plus by changing the UDFs to             *
*       procedures.  Results may be different in some cases, but I cannot    *
*       take the time to test with all versions of Dbase at this time.       *
*                                                                            *
*       If you like these routines, you can subscribe to the Synergy         *
*       BBS where I post the latest versions, etc., for $75 (one-time        *
*       fee).  I plan to adapt the code for Clipper sometime in the          *
*       relatively near future.                                              *
*                                                                            *
*       I CANNOT support this code for users who do not subscribe to the     *
*       BBS, so please do not call me with problems unless I have first      *
*       received your check for $75.00.   However, feel free to use the      *
*       code within your applications without registering.  You may not      *
*       charge any fee for this code, since you didn't write it [grin].      *
*                                                                            *
*       Note: to use these routines from dBASE IV, you must first change     *
*       all the PROCEDURE keywords to FUNCTION.  I imagine the same holds    *
*       true for dBXL/Quicksilver.  In version 1.0 of dBASE IV, LOAD is not  *
*       supported in UDFs, so you'll have to pre-load the BIN routines       *
*       If you're crazy enough to use dBASE IV 1.0.                          *
*                                                                            *
*       COMMNDLN() does not work under IV, nor does ISANSI().                *
*                                                                            *
*       Enjoy.                                                               *
*                                                                            *
*       R. Russell Freeland                                                  *
*       Synergy Corp.                                                        *
*       6289 W. Sunrise Blvd. Suite 256                                      *
*       Ft. Lauderdale, FL 33313                                             *
*                                                                            *
*       5/19/89                                                              *
*                                                                            *
******************************************************************************


******************************************************************************
* ARGV0() -- Get drive/path name of dBASE program                            *
*                                                                            *
* Syntax:                                                                    *
* mvar=ARGV0() (no arguments)                                                *
* Returns: <ExpC> drive/path name of dBASE or runtime program                *
* Requires DOS 3.something, not sure which                                   *
******************************************************************************

PROCEDURE ARGV0

PRIVATE tempstr
tempstr=SPACE(127)  && is this big enough?
LOAD Argv0
CALL Argv0 WITH tempstr
RELEASE MODULE Argv0
RETURN TRIM(tempstr)

******************************************************************************
* COMMNDLN() -- Get first argument on dBASE command line                     *
*                                                                            *
* Syntax:                                                                    *
* mvar=COMMNDLN() (no arguments)                                             *
* Returns: <ExpC> first argument on command line                             *
******************************************************************************

PROCEDURE COMMNDLN
PRIVATE tempstr
tempstr=SPACE(127)
LOAD Commndln
CALL Commndln WITH tempstr
RELEASE MODULE Commndln
RETURN TRIM(tempstr)


******************************************************************************
* HANDLES() -- Get count of available file handles                           *
*                                                                            *
* Syntax:                                                                    *
* mvar=HANDLES() (no arguments)                                              *
* Returns: <ExpN> number of available file handles                           *
******************************************************************************

PROCEDURE HANDLES
PRIVATE char
char = " "
LOAD Filehand
CALL Filehand WITH char
RELEASE MODULE Filehand
RETURN ASC(char)


******************************************************************************
* VALDRIVE() -- Find out which are valid drive letters on an MS-DOS system.  *
*                                                                            *
* Syntax:                                                                    *
* mvar=VALDRIVE() (no arguments)                                             *
* Returns: <ExpC> list of valid drive letters                                *
* Suggested uses: check to see if network drives are operational, see if     *
* a drive is online for backup, etc.                                         *
* DOES NOT CHECK FOR DRIVE READINESS, just to see what's on the system       *
******************************************************************************

PROCEDURE VALDRIVE
PRIVATE tempstring
tempstring=SPACE(26)
LOAD Valdrive
CALL Valdrive WITH tempstring
RELEASE MODULE Valdrive
RETURN TRIM(tempstring)

******************************************************************************
* ISANSI() -- Check for presence of ANSI-type device driver                  *
*                                                                            *
* Syntax:                                                                    *
* mvar=ISANSI() (no arguments)                                               *
* Returns: <ExpL> true if installed                                          *
******************************************************************************

PROCEDURE ISANSI

PRIVATE temp_log,scor_stat
temp_log = .F.
LOAD Isansi
CALL Isansi WITH temp_log
*scor_stat=SET("SCOR")
*SET SCOREBOARD OFF
RELEASE MODULE Isansi
*SET SCOREBOARD &scor_stat
RETURN temp_log

******************************************************************************
* LASTDRIV() -- Find letter of DOS LASTDRIVE                                 *
*                                                                            *
* Syntax:                                                                    *
* mvar=LASTDRIV() (no arguments)                                             *
* Returns: <ExpC> drive letter of LASTDRIVE                                  *
******************************************************************************

PROCEDURE LASTDRIV

PRIVATE tempstr
tempstr=" "

LOAD Lastdriv
CALL Lastdriv WITH tempstr
RELEASE MODULE Lastdriv

RETURN tempstr

******************************************************************************
* ISSUBST() -- Find out if drive letter is SUBST'ed                          *
*                                                                            *
* Syntax:                                                                    *
* mvar=ISSUBST("A") (to find out if "A:" is SUBST'ed)                        *
* Returns: <ExpN> 1=yes, 0=no, -1=invalid drive letter                       *
******************************************************************************

PROCEDURE ISSUBST

PARAMETER dr_letter

PRIVATE currentd

currentd=CURDIR(dr_letter)

DO CASE
CASE currentd = CHR(255)
        RETURN -1
CASE currentd <> UPPER(dr_letter)
        RETURN 1
OTHERWISE
        RETURN 0
ENDCASE

******************************************************************************
* CURDIR() -- Get current logged directory for any drive                     *
*                                                                            *
* Syntax:                                                                    *
* mvar=CURDIR("A") (to find logged directory on drive "A:"                   *
* Returns: <ExpC> Drive letter, semicolon, directory                         *
*          If drive is SUBST'ed, drive letter will be different              *
******************************************************************************

PROCEDURE CURDIR

PARAMETER dr_letter

PRIVATE tempstr

tempstr=UPPER(dr_letter)+SPACE(128)
LOAD Curdir
CALL Curdir WITH tempstr
RELEASE MODULE Curdir

IF tempstr=CHR(255)
        RETURN CHR(255)
ENDIF
RETURN TRIM(tempstr)


******************************************************************************
* CHIP() -- get type of processor(s)                                         *
*                                                                            *
* Syntax:                                                                    *
* mvar=CHIP()  (no argument)                                                 *
*                                                                            *
* Returns: <ExpC> "8088|8086|80186|80188|80286|80386|V20|V30"                *
*                 + "P" if in protected mode                                 *
*                 + "/"+"8087|80287|80387" if Intel coprocessor detected     *
******************************************************************************

PROCEDURE CHIP

PRIVATE chipsstr,protchar,mainproc,coproc

chipsstr="  "
protchar=""
LOAD Chip
CALL Chip WITH chipsstr
RELEASE MODULE Chip

mainproc = ASC(chipsstr)
IF MOD(mainproc,2) = 1        && if odd, in protected mode
        protchar = "P"
        mainproc = mainproc - 1
ENDIF
mainproc=LTRIM(STR(mainproc)) && make into a string

IF mainproc$"38,28"
      mainproc=mainproc+"6"
ENDIF
IF mainproc$"20,30"
      mainproc="V"+mainproc
ENDIF
coproc=ASC(RIGHT(chipsstr,1))
DO CASE
CASE coproc = 1
      coproc="/8087"
CASE coproc = 2
      coproc="/80287"
CASE coproc = 3
      coproc="/80387"
OTHERWISE
      coproc = ""
ENDCASE
prefix=IIF("V"$mainproc,"","80")
mainproc=prefix+mainproc+protchar

RETURN mainproc+coproc

******************************************************************************
* EMS() -- get version number of Expanded Memory Driver                      *
*                                                                            *
* Syntax:                                                                    *
* mvar=EMS() (no argument)                                                   *
*                                                                            *
* Returns: <ExpC> "0" if no EMS present, or version number as string         *
******************************************************************************

PROCEDURE EMS

PRIVATE ems_version

LOAD Ems
ems_version = " "
CALL Ems WITH ems_version
RELEASE MODELE Ems
IF ems_version = " "
      RETURN "0"
ENDIF
ems_version = ASC(ems_version)
ems_version = ITOH(ems_version)
ems_version = LEFT(ems_version,LEN(ems_version)-1)+"."+RIGHT(ems_version,1)

RETURN ems_version

******************************************************************************
* EXTM() -- get amount of extended memory                                    *
*                                                                            *
* Syntax:                                                                    *
* mvar=EMS(ExpN)                                                             *
* Where:                                                                     *
*        ExpN  = memvar into which to return amount of free extended memory  *
*                (a numeric dummy constant can be passed)                    *
*                                                                            *
*  NOTE: Foxplus does not retain changes made to parameters within a UDF     *
*        (at least as of version 2.1), so you'll need to modify the code     *
*        slightly to get back the amount of free extended memory.            *
*                                                                            *
* Returns: <ExpN> amount of extended memory in machine                       *
******************************************************************************

PROCEDURE EXTM

PARAMETER free

PRIVATE totl

Load Extm
totl = "    "
CALL Extm WITH totl
free=CONVWORD(totl,3)
totl=CONVWORD(totl,1)
RELEASE MODULE Extm
RETURN totl

******************************************************************************
* ITOH() -- convert (positive) integer to hex representation                 *
*                                                                            *
* Syntax:                                                                    *
* mvar = ITOH(ExPN)                                                          *
*                                                                            *
* Returns: <ExpC> "-1" if negative, or hex representation                    *
******************************************************************************

PROCEDURE ITOH

PARAMETER num

PRIVATE hex_string,dec,dec2,remainder

IF num < 0
      RETURN "-1"
ENDIF

hex_string = ""
dec = num

DO WHILE dec > 15
      dec2 = INT(dec/16)
      remainder = dec - dec2*16
      remainder = SUBSTR("0123456789ABCDEF",remainder+1,1)
      hex_string = remainder + hex_string
      dec = dec2
ENDDO

dec = SUBSTR("0123456789ABCDEF",dec+1,1)
hex_string = dec + hex_string

RETURN hex_string


******************************************************************************
* HTOI() -- convert hex string to integer                                    *
*                                                                            *
* Syntax:                                                                    *
* mvar = HTOI(ExPC)                                                          *
*                                                                            *
* Returns: <ExpN> -1 if invalid, or numeric representation                   *
******************************************************************************

PROCEDURE HTOI

PARAMETER hex_string
PRIVATE hexnum,dec,add,mystring,mlen

mystring = hex_string
dec = 0
factor = 1
mlen=LEN(mystring)

DO WHILE mlen > 0
      mystring = LEFT(mystring,mlen)
      add = RIGHT(mystring,1)
      hexnum = AT(add,"0123456789ABCDEF")
      IF hexnum = 0
            RETURN -1
      ENDIF
      hexnum = hexnum - 1
      dec = dec + (hexnum * factor)
      mlen = mlen - 1
      factor = factor * 16
ENDDO
RETURN dec

******************************** internal

PROCEDURE convword

parameters string,pos

RETURN (ASC(SUBSTR(string,pos+1,1))-1)*256+ASC(SUBSTR(string,pos,1))-1

