*:*****************************************************************************
*:
*:        Program: SWABOUT.PRG
*:         System: SilverTalk III for Windows
*:         Author: John P. Halovanic
*:      Copyright (c) 1994, SilverWare Inc.
*:  Last modified: 02-17-94 at 16:30:22
*:
*:      Called by: SWTALK.PRG                        
*:
*:          Calls: SWCASVER()         (function in ?)
*:               : SWASYNCVER()       (function in ?)
*:
*:      Documented 01:25:00                                FoxDoc version 3.00a
*:*****************************************************************************
PARAMETERS nTimeOut
PRIVATE nLib, cVer

IF EMPTY(nTimeOut)
	nTimeOut = 0
	
ENDIF

nLib = 0
cVer = SPACE(30)

SET SKIP OF MENU _MSYSMENU .T.			&& Disable main menu

IF EMPTY(nTimeOut)
	nTimeOut = 0
	
ENDIF

IF SYSMETRIC(25) == 26				&& System small font detected
	nRowSize = 23.9
	nColSize = 105.400
	
	nBmpX    = 24.000
	nBmpY    = 102.000
	
	nSayRow1 = 4.615
	nSayCol1 = 76.400
	nSayRow2 = 21.154
	nSayCol2 = 84.200
	nSayRow3 = 0.615
	nSayCol3 = 74.400
	nSayRow4 = 0.462
	nSayCol4 = 1.400
	nSayRow5 = 22.077
	nSayCol5 = 41.400
	
	nSize1X  = 4.000
	nSize1Y  = 16.375
	nSize1Z  = 0.000
	nSize2X  = 1.563
	nSize2Y  = 11.500
	nSize2Z  = 0.500
	nSize3X  = 2.000
	nSize3Y  = 15.333
	nSize3Z  = 0.000
	
ELSE				&& System large font detected
	nRowSize = 22.100
	nColSize = 74.000
	
	nBmpX    = 22.375
	nBmpY    = 72.857
	
	nSayRow1 = 3.688
	nSayCol1 = 54.571
	nSayRow2 = 19.688
	nSayCol2 = 60.286
	nSayRow3 = 0.438
	nSayCol3 = 52.143
	nSayRow4 = 0.438
	nSayCol4 = 1.429
	nSayRow5 = 20.000
	nSayCol5 = 28.857
	
	nSize1X  = 4.000
	nSize1Y  = 16.375
	nSize1Z  = 0.000
	nSize2X  = 1.875
	nSize2Y  = 10.125
	nSize2Z  = 0.500
	nSize3X  = 2.000
	nSize3Y  = 16.333
	nSize3Z  = 0.000
	
ENDIF

DEFINE WINDOW swabout ;
	AT  0.000, 0.000  ;
	SIZE nRowSize,nColSize ;
	TITLE "About SilverFox" ;
	FONT "MS Sans Serif", 8 ;
	NOFLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	DOUBLE ;
	COLOR RGB(,,,255,255,255)
MOVE WINDOW swabout CENTER

ACTIVATE WINDOW swabout NOSHOW

@ 0.000,0.000 SAY "tux.bmp" BITMAP ;
	SIZE nBmpX,nBmpY ;
	STYLE "T"

@ nSayRow1,nSayCol1 SAY "by SilverWare Inc." + CHR(13) + ;
	"3010 LBJ Freeway" + CHR(13) + ;
	"Dallas, Tx  75234" + CHR(13) + ;
	"(214) 247-0131"  ;
	SIZE nSize1X,nSize1Y,nSize1Z ;
	PICTURE "@J" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT" ;
	COLOR RGB(0,0,255,,,,)


@ WROWS()-3,WCOLS()-25 GET nContinue ;
	PICTURE "@*HT Continue" ;
	SIZE nSize2X,nSize2Y,nSize2Z ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 10 ;
	STYLE "B"

@ nSayRow3,nSayCol3 SAY "SilverFox (SPCS)" + CHR(13) + ;
	"for Windows"  ;
	SIZE nSize3X,nSize3Y,nSize3Z ;
	PICTURE "@J" ;
	FONT "MS Sans Serif", 12 ;
	STYLE "BT" ;
	COLOR RGB(255,0,0,,,,)

@ nSayRow4,nSayCol4 SAY "Copyright (c) 1994"  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "T" ;
	COLOR RGB(0,255,0,,,,)


cVer = SWAsyncVer(1)

@ nSayRow5,nSayCol5 SAY SUBSTR(cVer,AT("Version",cVer),12) ;
	FONT "MS Sans Serif", 12 ;
	STYLE "BIT"


ACTIVATE WINDOW swabout

DO CASE
	CASE nTimeOut == 0
		READ MODAL CYCLE
	CASE nTimeOut > 0
		READ MODAL CYCLE TIMEOUT nTimeOut
		
ENDCASE

RELEASE WINDOW swabout

SET SKIP OF MENU _MSYSMENU .F.				&& Enable main menu

RETURN
*: EOF: SWABOUT.PRG
