******************************************************************************
*   Program Name: SAVECDX.PRG          Copyright: (c) 1992, James Basler
*   Date Created: 08/11/94              Language: FoxPro
*   Time Created: 13:07:19                Author: James Basler
*
* Initial Release
*  Version 1.0
*    Creates a program file (type .PRG) with the extension .MAK that is
*    capable of recreating the index tags within a database file.
*
*    If you already have the database open, it will use the database as-is,
*    that is, it will also create the code for reindexing any open .NDX files.
*
*    This is expecially useful if you are changing the structure of a
*    database that may involve fields with index tags on them.  The .MAK file
*    program may then be modified to accomodiate the changes that you make to
*    the database structure so that you can merely run the program and
*    recreate the .CDX file in keeping to your new changes to the database
*    structure.
*
*    Usage:  DO SAVECDX WITH "database"
*
* Update(s)
*  Vers 2.0
*    10/31/94  Added functionality to allow re-creation of the original
*              database structure as well as the indexes.  If the original
*              database file is missing at the time the object .MAK program
*              is run, you will be given the opportunity to create the
*              database automatically.
******************************************************************************
PARAMETER dbname

CLEAR

DO CASE

   CASE TYPE([dbname]) = [L]
      mmsg1= [Error:  Database name must be passed as a PARAMETER.]
      mmsg2 = [Press a Key to Exit Function]
      do errwin with mmsg1,mmsg2
      RETURN

   CASE TYPE([dbname]) = [C]
      dbname = upper(dbname)
      IF [.DBF] $ UPPER(dbname)
         dbname = LEFT(dbname,AT([.],dbname)-1)
      ENDIF
      IF !FILE(dbname+[.DBF])
         mmsg1 = [Error: File Not Found, ]+dbname+[.DBF]
         mmsg2 = [Press a Key to Exit Function]
         do errwin with mmsg1,mmsg2
         RETURN
      ENDIF

ENDCASE

IF USED(dbname)
   wait [SELECTING ]+dbname+[.DBF] WINDOW NOWAIT
   SELECT (dbname)
ELSE
   wait [USING ]+dbname+[.DBF without .NDX's] WINDOW NOWAIT
   USE (dbname)
ENDIF

*  COUNT NUMBER OF TAGS ASSOCIATED WITH DATABASE
wait [Determing Associated Index Tags for ]+dbname+[.DBF] WINDOW NOWAIT
numtags=1
DO WHILE !EMPTY(TAG(numtags))
   numtags=numtags+1
ENDDO
numtags=numtags-1
IF numtags=0
   mmsg1 = [No TAGS found to be associated with ]+dbname
   mmsg2 = [Press a Key to Exit Function]
   do errwin with mmsg1,mmsg2
   RETURN
ENDIF

*  LOAD array with index tag information from .CDX and open .NDX's
DECLARE TAGS[numtags,3]
FOR x = 1 to numtags
   TAGS[x,1] = TAG(x)
   TAGS[X,2] = SYS(14,X)
   TAGS[X,3] = IIF(!EMPTY(NDX(X)),[NDX],[CDX])
NEXT
*  Write out a .PRG type file to create indexes
makefile = dbname+[.MAK]
SET PRINTER TO (makefile)
SET PRINTER ON

wait [Writing Index Tag Definitions for ]+dbname+[.DBF] WINDOW NOWAIT

? [******************************************************************************]
? [*                            PROGRAM: ]+dbname+[.MAK]
? [*]
? [*      Used to Recreate the Indexes in the .CDX file ]+dbname+[.CDX]
? [*]
? [*          If database is not found, it can recreate ]+dbname+[.DBF]
? [*]
? [*            This program was automatically generated by SAVECDX.PRG]
? [******************************************************************************]

? [WAIT "Press a Key to Begin Indexing ]+dbname+[" Window]
? [IF LASTKEY() = 27]
? [   RETURN]
? [ENDIF]
? [CLOSE DATABASES]

? [IF !FILE("]+dbname+[.DBF")]
? [   mmsg1 = "Error opening ]+dbname+[.DBF"]
? [   mmsg2 = "Create it ?"]
? [   IF ASKYNWIN(mmsg1,mmsg2,"N") = "Y"]
? [       DO CREATDB]
? [   ELSE]
? [      ?  "Error opening ]+dbname+[.DBF"]
? [      CANCEL]
? [   ENDIF]
? [ENDIF]

? [USE ]+DBNAME+ [ EXCLUSIVE]
?
? [IF USED("]+dbname+[")]
? [   m.msafety = SET("SAFETY")]
? [   m.mtalk = SET("TALK")]
? [   SET SAFETY OFF]
? [   SET TALK ON]
? [   CLEAR]
? [   ?  "RECREATING TAGS IN .CDX (and open .NDX's) OF DATABASE FILE:]+dbname+[.DBF"]
FOR X= NUMTAGS to 1 step -1
   IF TAGS[X,3] = [CDX]
      ? [   INDEX ON ]+TAGS[X,2]+ [ TAG ]+TAGS[X,1]
   ELSE
      ? [   INDEX ON ]+TAGS[X,2]+ [ TO ]+TAGS[X,1]+[.NDX]
   ENDIF
NEXT
? [ELSE]
? [    ?  "Error opening ]+dbname+[.DBF"]
? [ENDIF]
? [SET TALK &mtalk.]
? [SET SAFETY &msafety.]
? [RETURN]
? []
? []
? [**************************************************************************]
? [                           PROCEDURE CREATDB]
? [**************************************************************************]
? [PROCEDURE CREATDB]
wait [Writing Database Creation Structure for ]+dbname+[.DBF] WINDOW NOWAIT

DO CREADBF

? [RETURN]
? []
? []
? [**************************************************************************]
? [                           FUNCTION ASKYNWIN]
? [**************************************************************************]
? [FUNCTION askynwin]
? [PARAMETER mmsg1,mmsg2,mask]
? [PRIVATE mcursor,mdevice,mprint,mconsole,mask,mmsg1,mmsg2]
? []
? [mcursor  = SET("CURSOR")]
? [mdevice  = SET("DEVICE")]
? [mprint   = SET("PRINT")]
? [mconsole = SET("CONSOLE")]
? []
? [SET CURSOR OFF]
? [SET CONSOLE ON]
? [?? CHR(7)]
? [SET DEVICE TO SCREEN]
? [SET PRINT OFF]
? []
? [DO CASE]
? []
? [   CASE PARAMETERS() = 2]
? [      mask = mmsg2]
? [      mmsg2 = ""]
? [      windepth = 0]
? []
? [   CASE PARAMETERS() = 1]
? [      mask = "N"]
? [      windepth = 0]
? [      mmsg2 = ""]
? []
? [   OTHERWISE]
? [      windepth = 1]
? [ENDCASE]
? []
? [mask = UPPER(mask)]
? []
? [nsrows = SROWS()]
? []
? [lenbox = MAX(LEN(mmsg1)+5,LEN(mmsg2)+4)]
? [IF MOD(lenbox,2) <> 0]
? [   lenbox=lenbox+1]
? [ENDIF]
? [sbox = 40-(lenbox/2)]
? [MLINE = (nsrows/2)-1]
? [DEFINE WINDOW askwinue FROM MLINE-windepth,sbox TO MLINE+2,sbox+lenbox COLOR W+/R SHADOW]
? [ACTIVATE WINDOW askwinue]
? []
? [DO CASE]
? []
? [   CASE windepth = 0]
? [      @ 0,(lenbox/2)-(LEN(mmsg1)/2)-1 SAY mmsg1 GET mask  PICTURE '@!Y' VALID(mask = "Y" .OR. mask = "N") ERROR("Valid Choices: 'Y' OR 'N'")]
? []
? [   CASE windepth = 1]
? [      @ 0,(lenbox/2)-(LEN(mmsg1)/2) SAY mmsg1]
? [      @ 1,(lenbox/2)-(LEN(mmsg2)/2)-1 SAY mmsg2 GET mask PICTURE '@!Y'  VALID(mask = "Y" .OR. mask = "N") ERROR("Valid Choices: 'Y' OR 'N'")]
? []
? [ENDCASE]
? []
? [SET CURSOR ON]
? [READ]
? [SET CURSOR OFF]
? []
? [DEACTIVATE WINDOW askwinue]
? [RELEASE WINDOW askwinue]
? [SET CURSOR    &mcursor.]
? [SET DEVICE TO &mdevice.]
? [SET PRINT     &mprint.]
? [SET CONSOLE   &mconsole.]
? []
? [RETURN mask]


? [*** EOF(]+dbname+[.MAK)]
SET PRINTER OFF
SET PRINTER TO

WAIT [.PRG file  ]+dbname+[.MAK  Created] WINDOW
RETURN




******************************************************************************
*      Procedure: CREADBF              Copyright: (c) 1994, James Basler
*   Date Created: 10/31/94              Language: FoxPro
*   Time Created: 14:57:35                Author: James Basler
******************************************************************************
PROCEDURE CREADBF

=AFIELDS(DBFIELD)
IF ALEN(DBFIELD,1) <= 140   && LIMIT TO 140 FIELD: MAX OF 2048 CHARS IN A COMMAND
   DO CREATDB1
ELSE
   DO CREATDB2
ENDIF



******************************************************************************
*      Procedure: CREATDB1             Copyright: (c) 1994, James Basler
*   Date Created: 10/31/94              Language: FoxPro
*   Time Created: 13:50:03                Author: James Basler
*
*   CREATE A TABLE USING TEXT FORMAT  EG: "CREATE TABLE dbfname (field1 C(20),
*                                          field2 C(20), field3 N(5,2))
******************************************************************************
PROCEDURE CREATDB1
STORE [] TO MCREATE
? [CREATE TABLE ]+GETALIAS(DBF())+[ ;]
?
?? [  (]
Y=0
FOR X = 1 TO ALEN(DBFIELD,1)
   Y = Y+1
   FNAME = DBFIELD[X,1]
   FTYPE = DBFIELD[X,2]
   IF FTYPE=[N] .OR. FTYPE = [F]
      FSIZE = LTRIM(STR(DBFIELD[X,3]))+[,]+LTRIM(STR(DBFIELD[X,4]))
   ELSE
      FSIZE = LTRIM(STR(DBFIELD[X,3]))
   ENDIF
   MCREATE = MCREATE+FNAME+[ ]+FTYPE+[(]+FSIZE+[)]+[,]
   IF Y = 5 .OR. X = ALEN(DBFIELD,1)
      IF X <> ALEN(DBFIELD,1)
         ?? [  ]+MCREATE +[ ;]
         ?
      ELSE
         ?? [  ]+LEFT(MCREATE,LEN(MCREATE)-1) +[ )]
      ENDIF
      MCREATE = []
      Y=0
   ENDIF
NEXT

RETURN

******************************************************************************
*      Procedure: CREATDB2             Copyright: (c) 1994, James Basler
*   Date Created: 10/31/94              Language: FoxPro
*   Time Created: 13:54:50                Author: James Basler
*
*   CREATE A TABLE USING AN ARRAY
******************************************************************************
PROCEDURE CREATDB2

? [DECLARE DBFIELD(]+LTRIM(STR(ALEN(DBFIELD,1)))+[,4]+[)]
FOR X = 1 TO ALEN(DBFIELD,1)
   FOR Y = 1 TO 4
      ?  [DBFIELD(]+LTRIM(STR(X))+[,]+LTRIM(STR(Y))+[) = ]
      IF TYPE("DBFIELD[X,Y]") = [N] .OR. TYPE("DBFIELD[X,Y]") = [F]
         ?? LTRIM(STR(DBFIELD[X,Y]))
      ELSE
         ?? ["]+DBFIELD[X,Y]+["]
      ENDIF
   NEXT
NEXT
? [CREATE TABLE ]+GETALIAS(DBF())+[ ;]
? [  FROM ARRAY DBFIELD]

RETURN



******************************************************************************
*      Procedure: GETALIAS
*         Author: James Basler             Copyright: (c) 1992, James Basler
*   Date Created: 08/07/92                  Language: FoxPro
*   Time Created: 16:59:00                    Author: James Basler
******************************************************************************
FUNCTION getalias
*   take a full path filename ?:\?????\????????.DBF and derive the alias name from it
PARAM fname

PRIVATE fname,fullfile
IF [\] $ fname
   fullfile = SUBSTR(fname,RAT([\],fname)+1,12)   && Get rid of the path
ELSE
   fullfile = fname
ENDIF

IF [.] $ fullfile                                  && Contains a file extension
   falias = LEFT(fullfile,LEN(fullfile)-4)
ELSE
   falias = fullfile
ENDIF
RETURN falias


*****************************************************************************
*      Procedure: ERRWIN               Copyright: (c) 1992, James Basler
*   Date Created: 01/30/92              Language: FoxPro
*   Time Created: 09:56:42                Author: James Basler
*
* Provide error box for such things as missing files, etc.
*
* PARAMETERS: mmsg1,  mmsg2
*   mmsg1 = Line number 1 of message box window (REQUIRED)
*   mmsg2 = Line number 2 of message box window (OPTIONAL)
*
*  EXAMPLE: mmsg1 = [Error: Insufficient Priveledges ]
*           mmsg2 = [Strike a Key to Continue]
*           DO ERRWIN WITH mmsg1,mmsg2
*
*****************************************************************************
PROCEDURE errwin
PARAMETER mmsg1,mmsg2
PRIVATE mcursor,DEVICE,mprint,mconsole

mcursor  = SET([CURSOR])
mdevice  = SET([DEVICE])
mprint   = SET([PRINT])
mconsole = SET([CONSOLE])

SET CURSOR OFF
SET CONSOLE ON
?? CHR(7)
SET DEVICE TO SCREEN
SET PRINT OFF

windepth = 1
nsrows = SROWS()
IF TYPE([mmsg2]) = [L]                           && Logical mean that no value was passed in
   mmsg2 = []
   windepth = 0
ENDIF
lenbox = MAX(LEN(mmsg1)+4,LEN(mmsg2)+4)          && get num/chars to determine size of window needed
IF MOD(lenbox,2) <> 0                            && If num/chars uneven, padd spaces to make chars to left= chars to right
   lenbox=lenbox+1
ENDIF
sbox = 40-(lenbox/2)
MLINE = nsrows/2
DEFINE WINDOW errwinue FROM MLINE-windepth,sbox TO MLINE+2,sbox+lenbox COLOR W+/R SHADOW
ACTIVATE WINDOW errwinue
@ 0,(lenbox/2)-(LEN(mmsg1)/2) SAY mmsg1
IF windepth > 0
   @ 1,(lenbox/2)-(LEN(mmsg2)/2) SAY mmsg2
ENDIF
WAIT []
DEACTIVATE WINDOW errwinue
RELEASE WINDOW errwinue
SET CURSOR    &mcursor.
SET DEVICE TO &mdevice.
SET PRINT     &mprint.
SET CONSOLE   &mconsole.

RETURN

