*  Program Ŀ
*   Application: TRO 2 FoxFire! function                                    
*   Description: Function to add FoxFire calls to TRO painlessly            
*     File Name: STRTFF.PRG                                                 
*        Author: Geary F. Rachel, OMNI Micro Consultants                    
*  Date created: 07-12-94              Date updated: 07-12-94              
*  Time created: 06:43:55pm            Time updated: 06:43:55pm            
*       Docs By: Geary F. Rachel                                            
*     Copyright: Donated to Public Domain                                   
* 
*\ add this function to the bottom of O_Main.prg in the TRO system.
*\ Call this function from the menu with parameters as explained in
*\ FoxFire Developer's Manual, or as found in FFoxfire.prg
*\
*\ Example:  do startfoxfire with "REQUEST","" ,"" ,"" ,"MyReport"


function startfoxfire
   parameter tcWhichFunction, tcVar1, tcWhichDept, tcWhichConfig, ;
             tcWhichRequest, tnTimeout, tlMacroOk

   *\ limited parameter checking here
   *\ foxfire itself performs much more extensive parameter checking

   IF type('tcWhichFunction') != "C"
      tcWhichFunction = "REQUEST"
   ENDIF
   IF type('tcVar1') != "C"
      tcVar1 = ""
   ENDIF
   IF type('tcWhichDept') != "C"
      tcWhichDept = ""
   ENDIF
   IF type('tcWhichConfig') != "C"
      tcWhichConfig = ""
   ENDIF
   IF ! (type('tcWhichRequest') $ "LC")
      tcWhichRequest = .F.
   ENDIF
   IF type('tnTimeOut') != "N"
      tnTimeOut = .F.
   ENDIF
   IF type('tlMacroOk') != "L"
      tlMacroOk = .F.
   ENDIF


   do o_sleep with "sleep close"
   set skip of pad tro_sleep of _msysmenu .t.
   tro_path = fullpath('')

   do case
      case _Dos
         set default to <FF4dos path or merged x platform FF>
         do foxfire.app with ;
            tcWhichFunction, tcVar1, tcWhichDept , ;
            tcWhichConfig, tcWhichRequest, tnTimeout, tlMacroOk
      case _Windows
         set defa to <FF4Windos path or merged x platform FF>
         do foxfire.app with ;
            tcWhichFunction, tcVar1, tcWhichDept , ;
            tcWhichConfig, tcWhichRequest, tnTimeout, tlMacroOk
      case _Mac
         *\ FF for Mac not available yet  (is it?) 07/12/94

      * Case _unix
         *\ not yet implemented at the engine level  07/12/94
   endcase

   set defa to (tro_path)
   do O_Sleep with "awaken"

return .t.

