/*  Program ...:  Strdct.C
    Author ....:  Erik A McBeth
    Date ......:  February 1, 1990
    Version ...:  dBASE IV 1.0, 1.1
                  (Tested compilers/assemblers)
                  Turbo C 1.5, 2.0  TASM 1.0
                  Microsoft C 5.1   MASM 5.1

    C program which can be used to sort data in dictionary order
    in which you have symbols first, then letters, then numbers.

    To create bin file:
        Compile Strdct.C to Strdct.OBJ
        LINK Strdct+Getregs,Strdct,,,  See Strlib.h
        EXE2BIN Strdct

    The Strdct.BIN file can then be called from inside dBASE
        LOAD Strdct
	CALL Strdct WITH string
        in dBASE IV you can also do
	   ? CALL("Strdct",string)
	in dBASE IV you can also use this in indexing
	   INDEX ON CALL("Strdct",string+"") TO index
	place the "" in there so the field is not permanently
	changed.

*/

#include "strdct.h"

void far main() /* very important, make sure we get a far return */
{

/*   Tried to make this look familiar to 'C' programmers, notice the
     use of argc and argv, I've set argc to have a value of 2 to
     simulate the routine being call from the DOS prompt */

      int  argc;
      unsigned char far *argv[6];

      Getregs(); /* Assign memory registers */

/*    Translate the parameter passed by dBASE IV into something we
      can use, the argv[2] and argv[3] are placed here to show
      you how to read multiple parameters */

     argc    = CX+1; /* Number of arguments */
     argv[1] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  0));
     argv[2] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  4));
     argv[3] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  8));

     if (argc>1)  /* Do we have a string to use? */
       Strdct(argv[1]);

}

Strdct(str)
unsigned char far *str;
{

/*     Had to do it this way, couldn't do "trnslt[]={"  */

     /* Read from ameng.so (Framework III)
	   Table is case sensitive 
	   Table is in ascending order */
	static unsigned char trnslt[256];

	trnslt[  0]=  0; trnslt[  1]=  1; trnslt[  2]=  2; trnslt[  3]=  3; 
	trnslt[  4]=  4; trnslt[  5]=  5; trnslt[  6]=  6; trnslt[  7]=  7; 
	trnslt[  8]=  8; trnslt[  9]=  9; trnslt[ 10]= 10; trnslt[ 11]= 11; 
	trnslt[ 12]= 12; trnslt[ 13]= 13; trnslt[ 14]= 14; trnslt[ 15]= 15; 
	trnslt[ 16]= 16; trnslt[ 17]= 17; trnslt[ 18]= 18; trnslt[ 19]= 19; 
	trnslt[ 20]= 20; trnslt[ 21]= 21; trnslt[ 22]= 22; trnslt[ 23]= 23; 
	trnslt[ 24]= 24; trnslt[ 25]= 25; trnslt[ 26]= 26; trnslt[ 27]= 27; 
	trnslt[ 28]= 28; trnslt[ 29]= 29; trnslt[ 30]= 30; trnslt[ 31]= 31; 
	trnslt[' ']=' '; trnslt['!']='!'; trnslt['\"']='\"'; trnslt['#']='#'; 
	trnslt['$']='$'; trnslt['%']='%'; trnslt['&']='&'; trnslt['\'']='\''; 
	trnslt['(']='('; trnslt[')']=')'; trnslt['*']='*'; trnslt['+']='+'; 
	trnslt[',']=','; trnslt['-']='-'; trnslt['.']='.'; trnslt['/']='/'; 
	trnslt['0']=140; trnslt['1']=141; trnslt['2']=142; trnslt['3']=143; 
	trnslt['4']=144; trnslt['5']=145; trnslt['6']=146; trnslt['7']=147; 
	trnslt['8']=148; trnslt['9']=149; trnslt[':']='0'; trnslt[';']='1'; 
	trnslt['<']='2'; trnslt['=']='3'; trnslt['>']='4'; trnslt['?']='5'; 
	trnslt['@']='6'; trnslt['A']='k'; trnslt['B']='n'; trnslt['C']='o'; 
	trnslt['D']='q'; trnslt['E']='r'; trnslt['F']='t'; trnslt['G']='u'; 
	trnslt['H']='v'; trnslt['I']='w'; trnslt['J']='x'; trnslt['K']='y'; 
	trnslt['L']='z'; trnslt['M']='{'; trnslt['N']='|'; trnslt['O']='~'; 
	trnslt['P']=128; trnslt['Q']=129; trnslt['R']=130; trnslt['S']=131; 
	trnslt['T']=132; trnslt['U']=133; trnslt['V']=135; trnslt['W']=136; 
	trnslt['X']=137; trnslt['Y']=138; trnslt['Z']=139; trnslt['[']=150; 
	trnslt['\\']=151; trnslt[']']=152; trnslt['^']=153; trnslt['_']=154; 
	trnslt['`']=155; trnslt['a']='7'; trnslt['b']='>'; trnslt['c']='?'; 
	trnslt['d']='A'; trnslt['e']='B'; trnslt['f']='G'; trnslt['g']='H'; 
	trnslt['h']='I'; trnslt['i']='J'; trnslt['j']='N'; trnslt['k']='P'; 
	trnslt['l']='Q'; trnslt['m']='R'; trnslt['n']='S'; trnslt['o']='U'; 
	trnslt['p']='['; trnslt['q']='\\'; trnslt['r']=']'; trnslt['s']='^'; 
	trnslt['t']='_'; trnslt['u']='`'; trnslt['v']='e'; trnslt['w']='f'; 
	trnslt['x']='g'; trnslt['y']='h'; trnslt['z']='j'; trnslt['{']=156; 
	trnslt['|']=157; trnslt['}']=158; trnslt['~']=159; trnslt[127]=160; 
	trnslt[128]='p'; trnslt[129]='_'; trnslt[130]='C'; trnslt[131]='8'; 
	trnslt[132]='9'; trnslt[133]=':'; trnslt[134]=';'; trnslt[135]='@'; 
	trnslt[136]='D'; trnslt[137]='E'; trnslt[138]='F'; trnslt[139]='K'; 
	trnslt[140]='L'; trnslt[141]='M'; trnslt[142]='l'; trnslt[143]='m'; 
	trnslt[144]='s'; trnslt[145]=  0; trnslt[146]=  0; trnslt[147]='V'; 
	trnslt[148]='W'; trnslt[149]='X'; trnslt[150]='b'; trnslt[151]='c'; 
	trnslt[152]='i'; trnslt[153]=127; trnslt[154]=134; trnslt[155]=161; 
	trnslt[156]=162; trnslt[157]=163; trnslt[158]=164; trnslt[159]=165; 
	trnslt[160]='<'; trnslt[161]='O'; trnslt[162]='Y'; trnslt[163]='d'; 
	trnslt[164]='T'; trnslt[165]='}'; trnslt[166]='='; trnslt[167]='Z'; 
	trnslt[168]=166; trnslt[169]=167; trnslt[170]=168; trnslt[171]=169; 
	trnslt[172]=170; trnslt[173]=171; trnslt[174]=172; trnslt[175]=173; 
	trnslt[176]=174; trnslt[177]=175; trnslt[178]=176; trnslt[179]=177; 
	trnslt[180]=178; trnslt[181]=179; trnslt[182]=180; trnslt[183]=181; 
	trnslt[184]=182; trnslt[185]=183; trnslt[186]=184; trnslt[187]=185; 
	trnslt[188]=186; trnslt[189]=187; trnslt[190]=188; trnslt[191]=189; 
	trnslt[192]=190; trnslt[193]=191; trnslt[194]=192; trnslt[195]=193; 
	trnslt[196]=194; trnslt[197]=195; trnslt[198]=196; trnslt[199]=197; 
	trnslt[200]=198; trnslt[201]=199; trnslt[202]=200; trnslt[203]=201; 
	trnslt[204]=202; trnslt[205]=203; trnslt[206]=204; trnslt[207]=205; 
	trnslt[208]=206; trnslt[209]=207; trnslt[210]=208; trnslt[211]=209; 
	trnslt[212]=210; trnslt[213]=211; trnslt[214]=212; trnslt[215]=213; 
	trnslt[216]=214; trnslt[217]=215; trnslt[218]=216; trnslt[219]=217; 
	trnslt[220]=218; trnslt[221]=219; trnslt[222]=220; trnslt[223]=221; 
	trnslt[224]=222; trnslt[225]=  0; trnslt[226]=223; trnslt[227]=224; 
	trnslt[228]=225; trnslt[229]=226; trnslt[230]=227; trnslt[231]=228; 
	trnslt[232]=229; trnslt[233]=230; trnslt[234]=231; trnslt[235]=232; 
	trnslt[236]=233; trnslt[237]=234; trnslt[238]=235; trnslt[239]=236; 
	trnslt[240]=237; trnslt[241]=238; trnslt[242]=239; trnslt[243]=240; 
	trnslt[244]=241; trnslt[245]=242; trnslt[246]=243; trnslt[247]=244; 
	trnslt[248]=245; trnslt[249]=246; trnslt[250]=247; trnslt[251]=248; 
	trnslt[252]=249; trnslt[253]=250; trnslt[254]=251; trnslt[255]=252; 

/*  Go through the string and substitute the new value based on the
    value of the old character */

    for(;*str;str++) {
         *str = trnslt[(int)*str];
      }

}
