* STOD() - converts any date string (almost) to a valid date expression
* An improvement on the CTOD() date function - much more user friendly.
* Xbase has a DTOS() return YYYYMMDD, but no function for converting YYYYMMDD
* (Created on a Saturday night after years of difficulty with dates!)
* 1994 Computer Applications Company  703-486-2222  Rick Shaddock

* Syntax:  STOD(<expC>)         Returns: MM/DD/YYYY format

* Supported formats for <expC> for 03/05/1994
* Mar 15, 94           15 Mar 94           3/15/94     15/3/94     94/3/15
* Mar 15, 1994         15 Mar 1994         3/15/1994   15/3/1994   1994/3/15
* March 15, 94         15 March 94         03/15/94    15/03/94    94/03/15
* March 15, 1994       15 March 1994       03/15/1994  15/03/1994  1994/03/15
* March 15th 94        15th of March 94    3-15-94     15-3-94     1994-3-15
* March 15th 1994      15th of March 1994  3-15-1994   15-3-1994   1994-3-15
* March Fifteenth 94   Fifteenth March 94  03-15-94    15-03-94    94-03-15
* March Fifteenth 1994 Fifteenth of March  03-15-1994  15-03-1994  1994-03-15
* Mid March 94         940315              3.15.94     15.3.94     94.3.15
* Middle March 1994    19940315            3.15.1994   15.3.1994   1994.3.15
* March the 15th, 94   Ides of March 94    03.15.94    15.03.94    94.03.15
* March the 15th, 1994 Ides of March 1994  03.15.1994  15.03.1994  1994.03.15
* 315                  0315                1503        31594       031594

* Inconsistent separators are allowed or no separator at all
* 3.15/94          3 15-94     3/15-94    3/15.94    31594   150394

* Assumes current month and year if only day is given (ex. March 1994)
* Mar 15    March 15   15 Mar   15th of March    3/15    15/3   03-15   3.15     
* 15		15th       Fifteenth		Mid

* Removes extra words and spaces
* 	? stod('March the 15th of 1994') 

* If the first number is greater than 12, it is assumed to be a day
*	? stod('15-3-94')   returns 03/15/94 (D-M-Y format)
*   ? stod('3-15-94')   returns 03/15/94 (M-D-Y format)

* Holidays
*	? stod('Independence Day 1776')   returns 07/04/1776
*	? stod('Labor Day 92')			  returns 09/07/92 (first Monday)
*	? stod('Labor Day')				  returns 09/05/94 (first Monday)
*   ? stod('Christmas')               returns 12/25/94 (current year)

* Days of the week (this coming week assumed)
*   Mon    Tuesday    Last Wed    Last Thursday    Next Fri    Next Saturday

* Works for special key words and period endings
*   ? stod('Year End 94') returns 12/31/94
*	? stod('Today')       returns today's date
* 	? stod('Last Week')   returns 7 days before today's date
*	? stod('Feb End')     returns 02/28/94   (not leap year)
*   ? stod('Feb End 92')  returns 02/29/92   (leap year)

* Example of use of STOD() in a Valid procedure:
*		m.cDate =space(20)				&& Initialize character varible
*		@ 10,5 say 'Date:' get m.cDate	&& Get character var for date
*		read							&& read into memory
*		dDate =stod(m.cDate)			&& dDate is a true date variable
* 		m.cDate =dtoc(dDate)			&& Convert back to MM/DD/YY form
*		show gets						&& Display standard form date

* A test data table is available for testing with the command:
*	use STODTEST.DBF
*   browse fields String, Date=stod(String)

* Uses hUngarian code notation:  (not the STANDARD but the BEST!)
* FILENAMES and ALIAS's are in CAPS
* Field Names Are In Initial Caps
* pRivate vAriables wIth 1St lEtter iNdicating c,n,l,d,m  2nd lEtter in cAps
* pUBLIC vARIABLES  with 1st letter iNDICATING fIELD tYPE, rEST cAPS
* language commands and functions in all lower case
* -------------------------------------------------------------------------------

parameter cDate

if set('Talk') ='ON'
	set talk off
	cSetTalk ='ON'
else
	cSetTalk ='OFF'
endif

* Process parameter
	private cDate, cWait, cMDY, cFormat
	m.cDate =ltrim(rtrim(m.cDate))	&& Remove blanks
	m.cDate =upper(m.cDate)			&& Put the date string in all caps
	m.oDate =m.cDate				&& original date

* Variables
	cWait ='nowait'
	cMDY ='MDY'
	cYear =''
	cMonth=''
	cDay  =''
	cFormat =''
	dDate ={  /  /  }

* Determine date format
	cFormat =set("date")		&& Determine format
	if cFormat # "AMERICAN"
		=chr(7)
		wait window 'Should be American Format - Month Day Year' &cWait
		set date American
	endif

* If blank
	if empty(m.cDate)
		=chr(7)
		wait window 'Blank' &cWait
		do pCleanUp1 
		return {//}
	endif

* Remove extra words and blanks
	do while ' THIS ' $ ' ' +m.cDate
		m.cDate =stuff(m.cDate,at('THIS ',m.cDate),5,' ')
	enddo
	do while ' THE ' $ ' ' +m.cDate
		m.cDate =stuff(m.cDate,at('THE ',m.cDate),4,' ')
	enddo
	do while ' OF ' $ m.cDate
		m.cDate =stuff(m.cDate,at(' OF ',m.cDate),4,' ')
	enddo
	do while 'DAY' $ m.cDate
		m.cDate =stuff(m.cDate,at('DAY',m.cDate),3,'')
	enddo
	do while ',' $ m.cDate
		* replaces comma with space 
		m.cDate =stuff(m.cDate,at(',',m.cDate),1,' ')
	enddo
	if len(m.cDate) =3 and substr(m.cDate,2,2) $ 'ST ND RD TH'
		* remove 1st, 2nd, 3rd, 4th
		m.cDate ='0' +substr(m.cDate,1,1)
	endif
	if len(m.cDate) =4 and substr(m.cDate,3,2) $ 'ST ND RD TH'
		* remove 10th, 22nd, 33rd, 44th
		m.cDate =substr(m.cDate,1,2)
	endif
	do while '  ' $ m.cDate
		* remove extra spaces
		m.cDate =stuff(m.cDate,at('  ',m.cDate),2,' ')
	enddo
	m.cDate =alltrim(m.cDate)
*	? m.cDate

* Special day name cases which assume this year as a starting point
	do case
	case m.cDate ='TOMORROW'
		dDate =date() +1
	case m.cDate ='TODAY' or m.cDate ='TO' or m.cDate ='NOW'
		dDate =date()
	case m.cDate ='YESTER'
		dDate =date() -1
	case m.cDate ='LAST WEEK' or m.cDate ='LAST WK' or m.cDate ='WK LAST'
		dDate =date() -7
	case m.cDate ='NEXT WEEK' or m.cDate ='NEXT WK' or m.cDate ='WK NEXT'
		dDate =date() +7
	case m.cDate ='LAST MO' or m.cDate ='MO LAST'
		dDate =gomonth(date(),-1)
	case m.cDate ='NEXT MO' or m.cDate ='MO NEXT'
		dDate =gomonth(date(),1)
	case m.cDate ='LAST YEAR' or m.cDate ='LAST YR' or m.cDate ='YR LAST'
		dDate =gomonth(date(),-12)
	case m.cDate ='NEXT YEAR' or m.cDate ='NEXT YR' or m.cDate ='YR NEXT'
		dDate =gomonth(date(),12)
	case m.cDate ='D-'
		dDate =ctod('06/01/45')
	case 'FRI' $ m.cDate and ('13' $ m.cDate or 'THIRTE' $ m.cDate)
		if 'LAST' $ m.cDate
			nSign =-1
		else
			nSign =+1
		endif
		dSearch =date()
		do while not (cdow(dSearch) ='Friday' and day(dSearch) =13)
			dSearch =dSearch +nSign
		enddo
		return dSearch
	endcase

* Days of the week early return, assumes current time
	do case
	case m.cDate ='SUN' or m.cDate ='NEXT SUN' or m.cDate ='LAST SUN'
		dDate =pWeekDay('SUN')
	case m.cDate ='MON' or m.cDate ='NEXT MON' or m.cDate ='LAST MON'
		dDate =pWeekDay('MON')
	case m.cDate ='TUE' or m.cDate ='NEXT TUE' or m.cDate ='LAST TUE'
		dDate =pWeekDay('TUE')
	case m.cDate ='WED' or m.cDate ='NEXT WED' or m.cDate ='LAST WED'
		dDate =pWeekDay('WED')
	case m.cDate ='THU' or m.cDate ='NEXT THU' or m.cDate ='LAST THU'
		dDate =pWeekDay('THU')
	case m.cDate ='FRI' or m.cDate ='NEXT FRI' or m.cDate ='LAST FRI'
		dDate =pWeekDay('FRI')
	case m.cDate ='SAT' or m.cDate ='NEXT SAT' or m.cDate ='LAST SAT'
		dDate =pWeekDay('SAT')
	endcase		

* See if we know the date yet
	if not empty(m.dDate)
		do pCleanUp1
		return dDate
	endif

* Convert all Separators to spaces for ease in trimming and consistency
	cSep =''				&& Start with no separator
	if ' ' $ m.cDate		&& Spaces
		cSep =' '
	endif
	if '-' $ m.cDate		&& Dashes
		do pSepConv with '-'
		cSep =' '
	endif
	if '/' $ m.cDate		&& Slashes
		do pSepConv with '/'
		cSep =' '
	endif
	if '.' $ m.cDate		&& Dots
		do pSepConv with '.'
		cSep =' '
	endif
	if '*' $ m.cDate		&& Pipes
		do pSepConv with '*'
		cSep =' '
	endif
	if '  ' $ m.cDate 		&& Double pipes
		do pSepConv with '||'
		cSep =' '
	endif

* See if there are any digits standing alone
	* if so, put in a leading zero
	if m.cDate ='1 ' or m.cDate ='2 ' or m.cDate ='3 ' or ;
	   m.cDate ='4 ' or m.cDate ='5 ' or m.cDate ='6 ' or ;
	   m.cDate ='7 ' or m.cDate ='8 ' or m.cDate ='9 ' 
		m.cDate ='0' +m.cDate
	endif
	
	do case
	case ' 1 '$ m.cDate
		cDate =stuff(m.cDate,at(' 1 ',m.cDate),3,' 01')
	case ' 2 '$ m.cDate
		cDate =stuff(m.cDate,at(' 2 ',m.cDate),3,' 02')
	case ' 3 '$ m.cDate
		cDate =stuff(m.cDate,at(' 3 ',m.cDate),3,' 03')
	case ' 4 '$ m.cDate
		cDate =stuff(m.cDate,at(' 4 ',m.cDate),3,' 04')
	case ' 5 '$ m.cDate
		cDate =stuff(m.cDate,at(' 5 ',m.cDate),3,' 05')
	case ' 6 '$ m.cDate
		cDate =stuff(m.cDate,at(' 6 ',m.cDate),3,' 06')
	case ' 7 '$ m.cDate
		cDate =stuff(m.cDate,at(' 7 ',m.cDate),3,' 07')
	case ' 8 '$ m.cDate
		cDate =stuff(m.cDate,at(' 8 ',m.cDate),3,' 08')
	case ' 9 '$ m.cDate
		cDate =stuff(m.cDate,at(' 9 ',m.cDate),3,' 09')
	case ' 0 '$ m.cDate
		wait window ' Should be no zeros' &cWait
		cDate =stuff(m.cDate,at(' 0 ',m.cDate),3,' 00')
	otherwise 
		*OK
	endcase		

* Special cases - year undetermined
	do case
	case m.cDate ='YEAR END' or m.cDate ='END YEAR'
		m.cDate ='1231' +alltrim(substr(m.cDate,9))
	case m.cDate ='YR END' or m.cDate ='END YR'
		m.cDate ='1231' +alltrim(substr(m.cDate,7))
	case m.cDate ='YEAR START' or m.cDate ='START YEAR' or ;
		 m.cDate ='YEAR BEGIN' or m.cDate ='BEGIN YEAR'
 		m.cDate ='0101' +alltrim(substr(m.cDate,11))
	case m.cDate ='YR START' or m.cDate ='START YR' or ;
		 m.cDate ='YR BEGIN' or m.cDate ='BEGIN YR'
		m.cDate ='0101' +alltrim(substr(m.cDate,9))
	case "NEW YEAR'S EVE" $ m.cDate
		m.cDate =pWordNum ("NEW YEAR'S EVE",'1231')
	case 'NEW YEAR' $ m.cDate
		m.cDate =pWordNum ('NEW YEAR','0101')
	case 'EPIPHANY' $ m.cDate
		m.cDate =pWordNum ('EPIPH','0106')
	case 'MAHARISHI' $m.cDate
		m.cDate =pWordNum ('MAHARISHI','0112')
	case 'IDES' $ m.cDate and 'MARCH' $ m.cDate
		m.cDate =pWordNum ('IDES MARCH','0315')
	case 'APRIL' $ m.cDate and 'FOOL' $ m.cDate
		m.cDate =pWordNum ('APRIL FOOL','0401')
	case "TAX" $ m.cDate
		m.cDate =pWordNum ('TAX','0401')
	case "MEMOR" $ m.cDate
		m.cDate =pWordNum ('MEMOR','0530')
	case "FLAG" $ m.cDate
		m.cDate =pWordNum ('FLAG','0614')
	case "CANADA" $ m.cDate
		m.cDate =pWordNum ('CANADA','0704')
	case "INDEPEND" $ m.cDate
		m.cDate =pWordNum ('INDEPEND','0704')
	case "BASTIL" $ m.cDate
		m.cDate =pWordNum ('BASTIL','0714')
	case "LABOR" $ m.cDate
		cMonth ='09'
		if m.cDate ='LABOR'
			* Beginning with Labor
			cYear  =substr(m.cDate,rat(' ',m.cDate+' '))
		else
			cYear  =substr(m.cDate,at('LABOR',m.cDate)-1)
		endif
		if val(cYear) =0
			cYear =str(year(date()),4)
		endif
		dStart =ctod('9/1/'+cYear)
		for nX =0 to 7
			dSearch =dStart +nX
			if cdow(dSearch) ='Monday'
				exit
			endif
		endfor
		return dSearch
	case "SHADDOCK" $ m.cDate
		m.cDate =pWordNum ('SHAD','1007')
	case "COLUMBUS" $ m.cDate
		m.cDate =pWordNum ('COLUMB','1012')
	case "HALLOWEEN" $ m.cDate
		m.cDate =pWordNum ('HALLO','1031')
	case "CHRISTMAS" $ m.cDate 
		m.cDate =pWordNum ('CHRIST','1225')
	case 'XMAS' $ m.cDate
		m.cDate =pWordNum ('XMAS','1225')
	endcase

	do case
	case "JAN" $ m.cDate 
		cMDY =iif(m.cDate='JAN','MDY','DMY')
		m.cDate =pWordNum('JAN','01')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "FEB" $ m.cDate 
		cMDY =iif(m.cDate='FEB','MDY','DMY')
		m.cDate =pWordNum('FEB','02')
		if 'END' $ m.cDate
			m.cDate =pWordNum('END','28')
			m.cYear =substr(m.oDate,rat(' ',m.oDate))
			if val(cYear) =0
				cYear  =str(year(date()))
			endif
			* Determine if it is a leap year
			if mod(val(m.cYear),4) =0
				m.cDate ='02 29' +m.cYear
			else
				m.cDate ='02 28' +m.cYear
			endif
			cMDY ='MDY'
		endif

	case "MAR" $ m.cDate 
		cMDY =iif(m.cDate='MAR','MDY','DMY')
		m.cDate =pWordNum('MAR','03')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "APR" $ m.cDate 
		cMDY =iif(m.cDate='APR','MDY','DMY')
		m.cDate =pWordNum('APR','04')
		m.cDate =iif('END'$m.cDate, pWordNum('END','30'), m.cDate)
	case "MAY" $ m.cDate 
		cMDY =iif(m.cDate='MAY','MDY','DMY')
		m.cDate =pWordNum('MAY','05')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "JUN" $ m.cDate 
		cMDY =iif(m.cDate='JUN','MDY','DMY')
		m.cDate =pWordNum('JUN','06')
		m.cDate =iif('END'$m.cDate, pWordNum('END','30'), m.cDate)
	case "JUL" $ m.cDate 
		cMDY =iif(m.cDate='JUL','MDY','DMY')
		m.cDate =pWordNum('JUL','07')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "AUG" $ m.cDate 
		cMDY =iif(m.cDate='AUG','MDY','DMY')
		m.cDate =pWordNum('AUG','08')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "SEP" $ m.cDate 
		cMDY =iif(m.cDate='SEP','MDY','DMY')
		m.cDate =pWordNum('SEP','09')
		m.cDate =iif('END'$m.cDate, pWordNum('END','30'), m.cDate)
	case "OCT" $ m.cDate 
		cMDY =iif(m.cDate='OCT','MDY','DMY')
		m.cDate =pWordNum('OCT','10')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	case "NOV" $ m.cDate 
		cMDY =iif(m.cDate='NOV','MDY','DMY')
		m.cDate =pWordNum('NOV','11')
		m.cDate =iif('END'$m.cDate, pWordNum('END','30'), m.cDate)
	case "DEC" $ m.cDate 
 		cMDY =iif(m.cDate='DEC','MDY','DMY')
		m.cDate =pWordNum('DEC','12')
		m.cDate =iif('END'$m.cDate, pWordNum('END','31'), m.cDate)
	endcase

* Convert Day strings to numbers
	do case
	case 'FIRST' $ m.cDate
		m.cDate =stuff(m.cDate,at('FIRST',m.cDate),5,'01')
	case 'SECOND' $ m.cDate
		m.cDate =stuff(m.cDate,at('SECOND',m.cDate),6,'02')
	case 'THIRD' $ m.cDate
		m.cDate =stuff(m.cDate,at('THIRD',m.cDate),5,'03')
	case 'FOURTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('FOURTH',m.cDate),6,'04')
	case 'FIFTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('FIFTH',m.cDate),5,'05')
	case 'SIXTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('SIXTH',m.cDate),5,'06')
	case 'SEVENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('SEVENTH',m.cDate),7,'07')
	case 'EIGTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('EIGTH',m.cDate),5,'08')
	case 'NINTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('NINTH',m.cDate),5,'09')
	case 'TENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('TENTH',m.cDate),5,'10')
	case 'ELEVENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('ELEVENTH',m.cDate),8,'11')
	case 'TWELVTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('TWELVTH',m.cDate),7,'12')
	case 'THIRTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('THIRTEENTH',m.cDate),10,'13')
	case 'FOURTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('FOURTEENTH',m.cDate),10,'14')
	case 'FIFTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('FIFTEENTH',m.cDate),9,'15')
	case 'SIXTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('SIXTEENTH',m.cDate),9,'16')
	case 'SEVENTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('SEVENTEENTH',m.cDate),11,'17')
	case 'EIGHTEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('EIGHTEENTH',m.cDate),10,'18')
	case 'NINETEENTH' $ m.cDate
		m.cDate =stuff(m.cDate,at('NINETEENTH',m.cDate),10,'19')
	case 'TWENTIETH' $ m.cDate
		m.cDate =stuff(m.cDate,at('TWENTIETH',m.cDate),9,'20')
	case 'THIRTIETH' $ m.cDate
		m.cDate =stuff(m.cDate,at('THIRTIETH',m.cDate),9,'30')
	case 'MIDDLE' $ m.cDate 
		m.cDate =stuff(m.cDate,at('MIDDLE',m.cDate),6,'15')
	case 'MID' $ m.cDate 
		m.cDate =stuff(m.cDate,at('MID',m.cDate),3,'15')
	endcase	

	do case
	case 'ST' $ m.cDate
		m.cDate =stuff(m.cDate,at('ST',m.cDate),2,'')
	case 'ND' $ m.cDate
		m.cDate =stuff(m.cDate,at('ND',m.cDate),2,'')
	case 'RD' $ m.cDate
		m.cDate =stuff(m.cDate,at('RD',m.cDate),2,'')
	case 'TH' $ m.cDate
		m.cDate =stuff(m.cDate,at('TH',m.cDate),2,'')
	endcase

	* Remove spaces
	do while ' ' $ m.cDate
		m.cDate =stuff(m.cDate,at(' ',m.cDate),1,'')
	enddo

	do case
	* The date is converted to all digits by now
	* Priority of assumtions: MDY,DMY,YMD,YDM; DD before D
	* Current year is assumed, then 4 digit YYYY
	* Days evaluated in range order M(1-12), D(1-31), Y(1-9999)
	case val(m.cDate) =0
		* Zero value - may be holiday with no year
		m.cDate =m.cDate +' ' +str(year(date()),4)
		cMDY =''
	case len(m.cDate) =1 and val(m.cDate) <=9
		cFormat ='D'     &&              1..9
		cYear  =str(year(date()))
		cMonth =str(month(date()))
		cDay   =m.cDate
		cMDY ='MDY'
	case len(m.cDate) =2 and val(m.cDate) <=99
		cFormat ='DD'    &&             01..31
		cYear  =str(year(date()))
		cMonth =str(month(date()))
		cDay   =m.cDate
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
			cMDY ='DONE'
		else
			cFormat ='MD'	&&			32..99
			cMonth =substr(m.cDate,1,1)
			cDay   =substr(m.cDate,2,1)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
				cMDY ='DONE'
			else
				cFormat ='DM'
				cMonth =substr(m.cDate,2,1)
				cDay   =substr(m.cDate,1,1)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
					cMDY ='DONE'
				else
					cFormat ='Other ## possibilities'
					* YY assume 1/1/YY
				endif
			endif
		endif
	case len(m.cDate) =3 and val(m.cDate) <=999
		cFormat ='MDD'   &&            100..999
		cYear  =str(year(date()))
		cMonth =substr(m.cDate,1,1)
		cDay   =substr(m.cDate,2,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='MMD'
			cMonth =substr(m.cDate,1,2)
			cDay   =substr(m.cDate,3,1)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
				cMDY ='DONE'
			else
				cFormat ='DDM'
				cMonth =substr(m.cDate,3,1)
				cDay   =substr(m.cDate,1,2)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
					cMDY ='DONE'
				else
					cFormat ='DMM'
					cMonth =substr(m.cDate,2,2)
					cDay   =substr(m.cDate,1,1)
					if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
						cMDY ='DONE'
					else
						cFormat ='Other ### possibilities'
						* YMD      1st/21st century
						* YDM 
					endif
				endif
			endif
		endif
	case len(m.cDate) =4 and val(m.cDate) <=9999 
		cFormat ='MMDD'  &&           1000..9999
		cYear  =str(year(date()))
		cMonth =substr(m.cDate,1,2)
		cDay   =substr(m.cDate,3,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='DDMM'
			cMonth =substr(m.cDate,3,2)
			cDay   =substr(m.cDate,1,2)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
				cMDY ='DONE'
			else
				cFormat ='Other #### possibilites'
				* MDYY
				* DMYY
				* YYMD
				* YYDM
				* YMDD    1st/21st century
				* YDMM
			endif
		endif
	case len(m.cDate) =5 and val(m.cDate) <=99999
		cFormat ='MDDYY' &&          10000..99999
		cYear  =substr(m.cDate,4,2)
		cMonth =substr(m.cDate,1,1)
		cDay   =substr(m.cDate,2,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='MMDYY'
			cMonth =substr(m.cDate,1,2)
			cDay   =substr(m.cDate,3,1)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
				cMDY ='DONE'
			else
				cFormat ='DDMYY'
				cMonth =substr(m.cDate,3,1)
				cDay   =substr(m.cDate,1,2)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
					cMDY ='DONE'
				else
					cFormat ='DMMYY'
					cMonth =substr(m.cDate,2,2)
					cDay   =substr(m.cDate,1,1)
					if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
						cMDY ='DONE'
					else
						cFormat ='YYMDD'
						cYear  =substr(m.cDate,1,2)
						cMonth =substr(m.cDate,3,1)
						cDay   =substr(m.cDate,4,2)
						if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
							cMDY ='DONE'
						else
							cFormat ='YYMMD'
							cMonth =substr(m.cDate,3,2)
							cDay   =substr(m.cDate,5,1)
							if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
								cMDY ='DONE'
							else
								cFormat ='YYDDM'
								cMonth =substr(m.cDate,5,1)
								cDay   =substr(m.cDate,3,2)
								if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
									cMDY ='DONE'
								else
									cFormat ='YYDMM'
									cMonth =substr(m.cDate,4,2)
									cDay   =substr(m.cDate,3,1)
									if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
										cMDY ='DONE'
									else
										cFormat ='Other ##### possibilities'
										* MDYYY  Centuries 100..999
										* DMYYY
										* YYYMD
										* YYYDM
									endif
								endif
							endif
						endif
					endif
				endif
			endif
		endif
	case len(m.cDate) =6 and val(m.cDate) <=999999
		* We will assume 19th century
		cFormat ='MMDDYY'  &&       100000..999999
		cYear =substr(m.cDate,5,2)
		cMonth=substr(m.cDate,1,2)
		cDay  =substr(m.cDate,3,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='DDMMYY'
			cMonth=substr(m.cDate,3,2)
			cDay  =substr(m.cDate,1,2)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
				cMDY ='DONE'
			else
				cFormat ='YYMMDD'
				cYear =substr(m.cDate,1,2)
				cMonth=substr(m.cDate,3,2)
				cDay  =substr(m.cDate,5,2)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
					cMDY ='DONE'
				else
					cFormat ='YYDDMM'
					cMonth=substr(m.cDate,5,2)
					cDay  =substr(m.cDate,3,2)
					if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
						cMDY ='DONE'
					else
						cFormat ='MDYYYY'
						cYear =substr(m.cDate,3,4)
						cMonth=substr(m.cDate,1,1)
						cDay  =substr(m.cDate,2,1)
						if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000  and cMDY ='MDY'
							cMDY ='DONE'
						else
							cFormat ='DMYYYY'
							cYear =substr(m.cDate,3,4)
							cMonth=substr(m.cDate,2,1)
							cDay  =substr(m.cDate,1,1)
							if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000
								cMDY ='DONE'
							else
								cFormat ='YYYYMD'
								cYear =substr(m.cDate,1,4)
								cMonth=substr(m.cDate,5,1)
								cDay  =substr(m.cDate,6,1)
								if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
									cMDY ='DONE'
								else
									cFormat ='Other ###### possibilities'
									* MDDYYY & Centries 100..999
									* MMDYYY
									* DDMYYY
									* DMMYYY
									* YYYMDD
									* YYYMMD
								endif
							endif
						endif
					endif
				endif
			endif
		endif
	case len(m.cDate) =7 and val(m.cDate) <=9999999
		cFormat ='MDDYYYY'  &&     1000000..9999999'
		cYear =substr(m.cDate,4,4)
		cMonth=substr(m.cDate,1,1)
		cDay  =substr(m.cDate,2,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000 and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='MMDYYYY'
			cMonth=substr(m.cDate,1,2)
			cDay  =substr(m.cDate,3,1)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000 and cMDY ='MDY'
				cMDY ='DONE'
			else
				cFormat ='DDMYYYY'
				cMonth=substr(m.cDate,3,1)
				cDay  =substr(m.cDate,1,2)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000
					cMDY ='DONE'
				else
					cFormat ='DMMYYYY'
					cMonth=substr(m.cDate,2,2)
					cDay  =substr(m.cDate,1,1)
					if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000
						cMDY ='DONE'
					else
	 					cFormat ='YYYYMDD'
	 					cYear =substr(m.cDate,1,4)
						cMonth=substr(m.cDate,5,1)
						cDay  =substr(m.cDate,6,2)
						if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) < 3000
							cMDY ='DONE'
						else
							cFormat ='Other ####### possibilities'
							* YYYYMMD
							* MMDDYYY
							* DDMMYYY
							* YYYMMDD 
							* YYYDDMM 
						endif
					endif
				endif
			endif
		endif
	case len(m.cDate) =8 and val(m.cDate) <=99999999
		cFormat ='MMDDYYYY'  &&   10000101..99999999
		cYear =substr(m.cDate,5,4)
		cMonth=substr(m.cDate,1,2)
		cDay  =substr(m.cDate,3,2)
		if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) <3000 and cMDY ='MDY'
			cMDY ='DONE'
		else
			cFormat ='DDMMYYYY'
			cMonth=substr(m.cDate,3,2)
			cDay  =substr(m.cDate,1,2)
			if not empty(ctod(cMonth +'/' +cDay +'/' +cYear)) and val(cYear) <3000
				cMDY ='DONE'
			else
				cFormat ='YYYYMMDD'
				cYear =substr(m.cDate,1,4)
				cMonth=substr(m.cDate,5,2)
				cDay  =substr(m.cDate,7,2)
				if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
					cMDY ='DONE'
				else
					cFormat ='YYYYDDMM'
					cMonth=substr(m.cDate,7,2)
					cDay  =substr(m.cDate,5,2)
					if not empty(ctod(cMonth +'/' +cDay +'/' +cYear))
						cMDY ='DONE'
					else
						cFormat ='Other ######## possiblites'
					endif
				endif
			endif
		endif
	otherwise
		=chr(7)
		cFormat ='Other unknown'
	endcase

* Diagnostic window
*	wait window m.cDate +'=' +cFormat &cWait

* Construct the date
	m.cDate =cMonth +"/" +cDay +"/" +cYear
	dDate =ctod(m.cDate)			&& convert to a date variable

* Finish
	do pCleanup1
	return dDate



procedure pCleanup1
	* Cleanup steps
	set talk &cSetTalk
	return .t.

procedure pWeekDay
	* Sun - Sat
	parameter cWeekDay
	nX =0
	do while nX <7
		nX =nX +1
		dDate =date() +nX
		if upper(cdow(dDate)) =cWeekDay
			exit
		endif
	enddo
	if 'LAST' $ m.cDate
		dDate =dDate -7
	endif
	if 'NEXT' $ m.cDate
		dDate =dDate +7
	endif
	set talk &cSetTalk
	return dDate

procedure pSepConv
	* Convert separators to spaces
	parameter cSep
	nLenSep =len(cSep)
	do while cSep $ m.cDate
		nAt =at(cSep,m.cDate)
		m.cDate =substr(m.cDate,1,nAt-1) +' ' +substr(m.cDate,nAT+nLenSep)
	enddo

procedure pWordNum
	* Replace a word or words with a number string
	parameter cWord,cNum

	nWordAt   =at(cWord,m.cDate)				&& Where cWords starts
	
	nLenWord  =len(cWord)						&& Length of given words

	cWordSuff =substr(m.cDate,nWordAt+nLenWord)	&& After the given word

	nSpace    =at(" ",cWordSuff+" ")			&& position of " " in suff

	nLenword  =nLenWord + nSpace 				&& revised nLenWord

	m.cDate   =stuff(m.cDate,nWordAt,nLenWord,cNum)

	cPrefix =alltrim(substr(m.cDate,1,nWordAt-1))
	cSuffix =alltrim(substr(m.cDate,nWordAt))
	if nWordAt > 1 and val(cPrefix) > 32
		* Year may come before
		m.cDate =cSuffix +cPrefix
	else
		* Year comes after
		m.cDate =cPrefix +cSuffix
	endif
	return m.cDate
	

* To be done
* END FEB and LEAP YEARS