// A small test program to test STATWIN functions. Compile with /a/m/n.

PROCEDURE Main()

   LOCAL nCount, nInKeyCode, nSize := 30000, cDefault := "W/B"

   SETCOLOR ( cDefault )

   CLEAR SCREEN

   @ 24, 20 SAY "PRESS SPACE BAR TO MOVE ON TO NEXT EXAMPLE"

   @ 1, 1 SAY "This is a default window, with a percent bar length of 25,"
   @ 2, 1 SAY "using four characters ->    "

   StatInit ( 4, 10 )

   nInKeyCode := 0

   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount )
      nInKeyCode := INKEY()       //  --------------------------------------
      IF nInKeyCode == 32         //  This secition not normally coded!
         SETCOLOR ( cDefault )    //  Included here only to exit out of loop
         EXIT                     //  before it is finished (and to keep the
      ENDIF                       //  window from being erased.)
   NEXT
   
   @ 11, 1 SAY 'This is a "large" default window, with a percent bar length of 50,'
   @ 12, 1 SAY "using two characters ->  "

   StatInit ( 14, 10, .T. )  // Note: large window flag set
   
   nInKeyCode := 0
   
   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount )
      nInKeyCode := INKEY()
      IF nInKeyCode == 32
         SETCOLOR ( cDefault )
         EXIT
      ENDIF
   NEXT
   
   CLEAR SCREEN

   @ 24, 20 SAY "PRESS SPACE BAR TO MOVE ON TO NEXT EXAMPLE"

   @ 1, 1 SAY 'This is a default window with the "show estimated time" flag set.'

   StatInit ( 4, 10 )

   nInKeyCode := 0

   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount, , .T. )  // Note: estimate flag set
      nInKeyCode := INKEY()
      IF nInKeyCode == 32
         SETCOLOR ( cDefault )
         EXIT
      ENDIF
   NEXT
   
   @ 12, 1 SAY 'This is a "large" window with a header message and the '
   @ 13, 1 SAY '"show estimated time" flag set.'

   StatInit ( 15, 10, .T. )
   
   nInKeyCode := 0
   
   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount, "This space for rent -- We are this far ->", .T. )
      nInKeyCode := INKEY()    // Note above: message string defined
      IF nInKeyCode == 32
         SETCOLOR ( cDefault )
         EXIT
      ENDIF
   NEXT
   
   CLEAR SCREEN

   @ 24, 20 SAY "PRESS SPACE BAR TO MOVE ON TO NEXT EXAMPLE"

   @ 1, 1 SAY 'This is a default window with the user-defined window colors.'

   StatInit ( 4, 10 )

   nInKeyCode := 0

   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount, , , "R/BG" )  
      nInKeyCode := INKEY()
      IF nInKeyCode == 32
         SETCOLOR ( cDefault )
         EXIT
      ENDIF
   NEXT
   
   @ 12, 1 SAY 'This is a "large" window with the same window colors plus user-defined'
   @ 13, 1 SAY 'percent bar template and percent bar "fill" colors.'

   StatInit ( 15, 10, .T. )
   
   nInKeyCode := 0
   
   FOR nCount = 1 TO nSize
      StatWin ( nSize, nCount, , , "R/BG", "W", "RB+/W" )
      nInKeyCode := INKEY()    
      IF nInKeyCode == 32
         SETCOLOR ( cDefault )
         EXIT
      ENDIF
   NEXT

   CLEAR SCREEN

   ? "That pretty much covers all the possible menu types.  For hints on using"
   ? "StatWin, see the STATWIN.PRG header.  For more advanced hints, see the"
   ? "README.TXT file."
   ?
   
RETURN
