* ********************************************************************
*  Program:  STATUS_BAR
* 
*  By:  Don Pitchford	74720,1561
* 		Plano, Tx
* 
* History:
* --------
*    Ver 1  -  Provide a crude thermometer that track the staus.
*    Ver 2  -  Cleaned up the appearance of the window to represent
*              a more realistic window.
* 
* Description:                                            
* ------------
* 	  Generates a simple thermometer in the center of the screen.  
*                                                           
*   			 = STATUS_BAR(<MAX>,<COUNT>,<TITLE>)
*
*     The program creates a window called STATUSBAR.
*
* License Agreement:
* ------------------
*     There are none.  Copy, distribute, resell what ever.  I would be
*     happy to receive any feed back on the program that you can give or
*     any improvements to make the library better..
*
*-----------------------------------------------------------------------------------  
*         Sample code:
*------------------------------------------------------------------------------------
*             set library to status.prg
*             
*             for i = 1 to 1000
*                 = STATUS_BAR(1000,i,"Sample Status Bar")
*             endfor
*
*             clear window statusbar
* **********************************************************************

*-----------------------------------------------------------------------------------------------------
*   Function:  STATUS_BAR
*-----------------------------------------------------------------------------------------------------
function STATUS_BAR
   parameter MAX,TCOUNT,title
   
   m.perc_comp = m.TCOUNT/MAX

IF SET("TALK") = "ON"
	SET TALK OFF
	m.talkstat = "ON"
ELSE
	m.talkstat = "OFF"
ENDIF

IF NOT WEXIST("statusbar") ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.PJX" ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.SCX" ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.MNX" ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.PRG" ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.FRX" ;
	OR UPPER(WTITLE("STATUSBAR")) == "STATUSBAR.QPR"
	DEFINE WINDOW statusbar ;
		AT  0.000, 0.000  ;
		SIZE 5.625,67.286 ;
		FONT "MS Sans Serif", 8 ;
		NOFLOAT ;
		NOCLOSE ;
		NOMINIMIZE ;
		COLOR RGB(,,,192,192,192)
	MOVE WINDOW statusbar CENTER
ENDIF

IF WVISIBLE("statusbar")
	ACTIVATE WINDOW statusbar SAME
ELSE
	ACTIVATE WINDOW statusbar NOSHOW
ENDIF


IF NOT WVISIBLE("statusbar")
	ACTIVATE WINDOW statusbar
	@ 0.500,10 SAY m.title ;
		SIZE 1.000,33.875 ;
		FONT "MS Sans Serif", 10 ;
		PICTURE "@I"

		
	@ 3.000,4.429 TO 4.563,62.858 ;
		PATTERN 1 ;
		PEN 0, 8 ;
		COLOR RGB(255,255,255,,,)
		
		
	@ 3,4.429 to 3,62.858 ;
	    PATTERN 1 ;
	    PEN 0;
	    COLOR RGB (128,128,128,,,)	
	    
	@ 3,4.429 to 4.563,4.429 ;
	    PATTERN 1;
	    PEN 0;
	    COLOR RGB (128,128,128,,,)    
ENDIF

*
*  Determine line size.
*
m.numrep = (m.perc_comp*57.43)+5

*
*  Draw the box.  For different patterns play with the number.
*

	@3.09,4.5 to 4.4,m.numrep pattern 1 pen 2 color RGB(128,128,128,128,128,128)

	*
	* Write the % in the middle of the BAR.  Cannot figure out how
	* to write to the screen without over writting the data.
	*

	if m.perc_comp > .47
		@ 3.1,28 SAY str(round(m.perc_comp*100,0))+"%" ;
			FONT "MS Sans Serif", 10 ;
			Function "T";
			PICTURE "@I";
			color RGB(,,,,,);
			style "T"
	else
		@ 3.1,28 SAY str(round(m.perc_comp*100,0))+"%" ;
			FONT "MS Sans Serif", 10 ;
			Function "T";
			PICTURE "@I";
			color RGB(,,,,,)
	endif
		


IF m.talkstat = "ON"
	SET TALK ON
ENDIF


return m.perc_comp
*------------------------------------------------------------------------------------------------------
*  End Of Function
*------------------------------------------------------------------------------------------------------