;  File: STAMP.ASM     System: Alpha test    Version: 1.00  Date: 02-19-90  ;
 
;-----------------------------------------------------------------------------
; Program adds/updates/removes comment stamp (example above) in first line of
; source code file.  PRG/ASM/C/TXT/PAS extensions supported.
;-----------------------------------------------------------------------------
Code_Seg   SEGMENT
           ASSUME CS:Code_Seg,DS:Code_Seg,ES:Code_Seg
           ORG 100h            ; COM file start
 
LF         EQU   0Ah
PSPLEFT    EQU   80h           ; PSP location for ASCIIZ file name
PSPRIGHT   EQU   0C0h          ; PSP location for ASCIIZ temp file name
 
NO_CHANGE  EQU   1             ; Bit positions in Flags byte--
VER_NUM    EQU   2             ; First five set if corresponding switch
SYS_NAME   EQU   4             ;   found in command-line
VER_DATE   EQU   8
DEL_STAMP  EQU   16
IS_APPEND  EQU   32            ; Flags append--set if stamp not found in file
 
Stamp:     jmp   Start
 
Notice     DB    "(C) Craig Hessel, 1990"       ; Unreferenced
 
SyntaxMsg  =     $
 
DB 13,10
DB 9,"STAMP [d:][path]filename.ext [switches] adds/updates/removes",13,10
DB 9,"first-line system stamp in PRG/ASM/C/TXT/PAS file.  E.g.,",13,10
DB 13,10
DB 9,"FOR %F IN (*.PRG *.ASM) DO STAMP %F /V1.12 /SFoobar /D02-19-90",13,10
DB 13,10
DB 9,"Switch",9,9,      "Description",9,9,         "Default",13,10
DB 9,"------",9,9,      "-----------",9,9,         "-------",13,10
DB 9,"/Sssssssssssss",9,"System name",9,9,         "Old name, or None",13,10
DB 9,"/Vvvvv",9,9,      "Version number",9,9,      "Old number, or 1.00",13,10
DB 9,"/Dmm-dd-yy",9,    "Version date",9,9,        "DOS date",13,10
DB 9,"/N",9,9,          "No change in file date",9,"Set to version date",13,10
DB 9,"/R",9,9,          "Remove stamp",9,9,        "Add/update stamp",13,10
DB 13,10
DB 9,"Use as simple version control utility for systems with many small",13,10
DB 9,"files.  Limit 64K per file.  FOR command sometimes operates on a",13,10
DB 9,"file twice since STAMP creates/renames temp file.  No harm.",0
 
MemErMsg   DB    "Memory problem",0
PrmErMsg   DB    "Bad parameter",0
NamErMsg   DB    "Bad file name:",9,0
ExtErMsg   DB    "Bad extension:",9,0
RemErMsg   DB    "No file stamp:",9,0
RdErMsg    DB    "Read error:",9,0
BigErMsg   DB    "File too big:",9,0
WrtErMsg   DB    "Write error:",0,0
DelErMsg   DB    "Delete error:",9,0
RenErMsg   DB    "Rename error:",9,0
UpdtMsg    DB    "Stamp updated:",9,0
AddMsg     DB    "Stamp added:",9,0
RemMsg     DB    "Stamp removed:",9,0
 
; Table of allowed extensions, each followed by space then left/right word
; delimiters.  Do NOT insert blank extension.  Also advise non-blank
; rightmost delimiter, since some text editors trim blanks.  Requiring
; specific extensions prevents accidental trashing of files.
 
ExtDlmTbl  DB    "PRG ****"
           DB    "ASM ;  ;"
           DB    "C   /**/"
           DB    "TXT [  ]"
           DB    "PAS (**)"
ExtNum     =     ($ - OFFSET ExtDlmTbl) / 8
 
SwList     DB    "NnVvSsDdRr"  ; Reverse order of call list below
SwListLen  =     $ - OFFSET SwList
SwCall     DW    OFFSET SwDel, OFFSET SwDate, OFFSET SwSys, OFFSET SwVer
           DW    OFFSET SwNoChg
 
; Stamp line created here before copy to file buffer.  An old stamp in file
; is assumed if BOF match to first few bytes and if correct line length.
 
LeftDlm    DW    "**"
           DB    " File: "
MatchLen   =     $ - OFFSET LeftDlm
NameFile   DB    "              "
           DB    "System: "
SysOffset  =     $ - OFFSET LeftDlm
System     DB    "None          "
SysLen     =     $ - OFFSET System - 2
           DB    "Version: "
VerOffset  =     $ - OFFSET LeftDlm
Version    DB    "1.00  "
VerLen     =     $ - OFFSET Version - 2
           DB    "Date: "
Date       DB    "01-01-90 "
RightDlm   DW    "**"
CrLf       DB    13,10,0
StampLen   =     $ - OFFSET LeftDlm - 1
FileMax    =     0FFFFh - StampLen
 
Flags      DB    0             ; Miscellaneous flags
BufSeg     DW    ?             ; Segment of 64K file buffer
NameLen    DW    ?             ; Length of file name
ShortLen   DW    ?             ; Length of file name, without drive:path
FileSize   DW    ?             ; Bytes read to buffer
FileDate   DW    ?             ; Packed file date--DOS, supplied, or old
FileTime   DW    6000h         ; Packed file time--noon default
SvYear     DW    ?             ; Temp variables used with /D switch
SvMnDay    DW    ?
 
Start:     mov   bx,PGM_PARA   ; Equate at end -- includes PSP, program,
           mov   ah,4Ah        ;   and stack
           int   21h           ; Resize program memory allocation
           mov   si,OFFSET MemErMsg
           jc    chainup       ; Error?  Abort
 
           mov   sp,OFFSET NewStack
 
           mov   bx,1000h      ; Allocate 64K buffer
           mov   ah,48h
           int   21h
           jc    chainup       ; Allocation error?  Abort
 
           mov   BufSeg,ax     ; Save buffer segment
 
           call  GetDate       ; Copy DOS date to FileDate and Date
           call  SetParm       ; Handle command-line switches
           mov   si,OFFSET PrmErMsg
           jc    chainup       ; Bad parameter?  Abort
 
           call  SetName       ; Make ASCIIZ filename at PSPLEFT
           mov   si,OFFSET SyntaxMsg
chainup:   jc    qwkabort      ; No file name?  Show syntax
 
           call  CopyName      ; Copy to stamp line, less drive:path
           mov   si,OFFSET NamErMsg
           jc    abort         ; Illegal name?  Abort
 
           call  SetDlm        ; Set proper comment delimiters
           mov   si,OFFSET ExtErMsg
           jc    abort         ; Illegal file extension?  Abort
 
           call  SetTemp       ; Set temp file name at PSPRIGHT
           call  Read          ; Read file to buffer
           mov   si,OFFSET RdErMsg
           jc    abort         ; Read error?  Abort
 
           cmp   FileSize,FileMax
           cmc
           mov   si,OFFSET BigErMsg
           jc    abort         ; File too big?  Abort
 
           call  CopyStamp     ; Update buffer, setting append flag, as needed
           mov   si,OFFSET RemErMsg
           jc    abort         ; Remove flagged, but no stamp?  Abort
 
           call  Write         ; Write buffer to temp file
           mov   si,OFFSET WrtErMsg
           jc    abort         ; Write error (e.g., disk full)?  Abort
 
           call  Delete        ; Delete old file
           mov   si,OFFSET DelErMsg
           jc    abort         ; Delete error (e.g., read-only)?  Abort
 
           call  Rename        ; Rename temp file
           mov   si,OFFSET RenErMsg
           jc    abort         ; Rename error?  Abort, else success
 
           mov   si,OFFSET UpdtMsg
           test  BYTE PTR Flags,IS_APPEND
           je    up
 
           mov   si,OFFSET AddMsg
up:        test  BYTE PTR Flags,DEL_STAMP
           je    abort
 
           mov   si,OFFSET RemMsg
abort:     call  DispStr
           mov   si,PSPLEFT
qwkabort:  call  DispStr       ; Carry preserved
           mov   si,OFFSET CrLf
           call  DispStr
           mov   ax,4C00h SHR 1
           rcl   ax,1
           int   21h           ; Exit with errorlevel 1 on error
;-----------------------------------------------------------------------------
; Display null-terminated string at DS:SI, preserving carry.
;-----------------------------------------------------------------------------
DispStr    PROC
           pushf
           jmp   SHORT dstrent
 
dstrloop:  mov   dl,al
           mov   ah,2
           int   21h
dstrent:   lodsb
           test  al,al
           jne   dstrloop
 
           popf
           ret
DispStr    ENDP
;-----------------------------------------------------------------------------
; Set Date and FileDate to DOS date.
;-----------------------------------------------------------------------------
GetDate    PROC
           mov   ah,2Ah        ; Get DOS date
           int   21h           ; CX<--year, DH<--month, DL<--day
 
           call  PackDate
           mov   FileDate,ax
 
           mov   di,OFFSET Date
           mov   al,dh
           call  StoDgts
 
           mov   al,dl
           call  StoDgts
 
           mov   ax,cx
           mov   bl,100
           div   bl
           mov   al,ah
 
StoDgts:   mov   bl,10
           xor   ah,ah
           div   bl            ; AH/AL <-- remainder/quotient
           add   ax,3030h      ; To ASCII digits
           stosw
           inc   di            ; Skip hyphen
           ret
GetDate    ENDP
;-----------------------------------------------------------------------------
; Pack year/month/day CX/DH/DL to AX.
;-----------------------------------------------------------------------------
PackDate   PROC
           mov   ax,cx
           sub   ax,1980
           mov   ah,al
           mov   al,dh
           push  cx
           mov   cl,5
           shl   al,cl
           pop   cx
           rcl   ah,1
           or    al,dl
           ret
PackDate   ENDP
;-----------------------------------------------------------------------------
; Handle switch parameters in PSP.
;-----------------------------------------------------------------------------
SetParm    PROC
           mov   si,PSPLEFT
           lodsb               ; Max bytes to scan
           mov   cl,al
           xor   ch,ch
 
sploop:    jcxz  spout         ; No more bytes to scan?  Out with clear carry
 
           mov   al,'/'        ; Switch flag
           mov   di,si
           repne scasb
           clc
           jne   spout         ; No more switches?  Out with clear carry
 
           mov   si,di
           lodsb               ; Fetch switch letter
           dec   cx
 
           push  cx
           mov   di,OFFSET SwList
           mov   cx,SwListLen
           repne scasb         ; Look for match in switch list
           mov   bx,cx
           pop   cx
           stc                 ; In case error
           jne   spout         ; Illegal switch?  Abort
 
           and   bl,0FEh       ; List contains adjacent upper/lower case
           call  SwCall[bx]    ; SI/CX passed and updated
           jnc   sploop
 
spout:     ret
SetParm    ENDP
;-----------------------------------------------------------------------------
; Handle R switch, returning clear carry.
;-----------------------------------------------------------------------------
SwDel      PROC
           or    Flags,DEL_STAMP
           ret
SwDel      ENDP
;-----------------------------------------------------------------------------
; Handle N switch, returning clear carry.
;-----------------------------------------------------------------------------
SwNoChg    PROC
           or    Flags,NO_CHANGE
           ret
SwNoChg    ENDP
;-----------------------------------------------------------------------------
; Handle V switch, returning clear carry.  Copies version to stamp line.
;-----------------------------------------------------------------------------
SwVer      PROC
           or    Flags,VER_NUM
           mov   dx,VerLen
           mov   di,OFFSET Version
           jmp   SHORT Copy
SwVer      ENDP
;-----------------------------------------------------------------------------
; Handle S switch, returning clear carry.  Copies system to stamp line.
;-----------------------------------------------------------------------------
SwSys      PROC
           or    Flags,SYS_NAME
           mov   dx,SysLen
           mov   di,OFFSET System
 
Copy:      xchg  dx,cx
           sub   dx,cx         ; Anticipate full copy
 
cploop:    lodsb
           cmp   al,'/'        ; Copy until next switch or PSP end
           je    cpnotok
 
           cmp   al,13
           jne   cpok
 
cpnotok:   inc   dx            ; Adjust bytes left in PSP
           dec   si            ; Point back to terminator
           mov   al,' '        ; Space fill destination
cpok:      stosb
           loop  cploop
 
           mov   cx,dx         ; Restore bytes left to CX
           clc                 ; Flag ok
           ret
SwSys      ENDP
;-----------------------------------------------------------------------------
; Handle D switch.
;-----------------------------------------------------------------------------
SwDate     PROC
           or    Flags,VER_DATE
           sub   cx,8
           push  cx            ; Save bytes left in PSP
           jb    sdout         ; Not at least 8 left?  Abort
 
           mov   al,'-'        ; Dummy
           call  GetDgts       ; Get month in AL
           mov   dh,al
           jc    sdout         ; Not two digits?  Abort
 
           lodsb               ; Expected minus sign
           call  GetDgts       ; Get day in AL
           mov   dl,al
           jc    sdout         ; Not minus sign and two digits?  Abort
 
           lodsb               ; Expected minus sign
           call  GetDgts
           mov   cl,al
           jc    sdout         ; Not minus sign and two digits?  Abort
 
           xor   ch,ch
           cmp   cl,80
           jae   swdup
 
           add   cl,100
swdup:     add   cx,1900       ; Date range from 1980-2079 good enough
 
           mov   SvYear,cx
           mov   SvMnday,dx
 
           mov   ah,2Ah
           int   21h           ; Get DOS date
 
           xchg  SvYear,cx
           xchg  SvMnDay,dx
           mov   ah,2Bh        ; Set DOS date to parm value
           int   21h
           shl   al,1          ; AL is 255 if illegal values
           jc    sdout         ; Illegal?  Abort (DOS date unchanged)
 
           call  GetDate       ; Reset Date and FileDate for parm value
 
           mov   cx,SvYear     ; Restore DOS date
           mov   dx,SvMnDay
           mov   ah,2Bh
           int   21h
 
sdout:     pop   cx            ; Restore PSP bytes left
           ret
SwDate     ENDP
;-----------------------------------------------------------------------------
; Test AL for minus sign and word at DS:SI for two digits, advancing DI.  Set
; carry if error, else return number in AL.
;-----------------------------------------------------------------------------
GetDgts    PROC
           cmp   al,'-'
           stc
           jne   gdout         ; Not dash?  Abort
 
           lodsw
           call  ToDcml
           jc    gdout
 
           xchg  ah,al
           call  ToDcml
           jc    gdout
 
           shl   ah,1
           add   al,ah
           shl   ah,1
           shl   ah,1
           add   al,ah         ; Carry is clear
gdout:     ret
GetDgts    ENDP
;-----------------------------------------------------------------------------
; Convert AL to decimal.  Set carry if not digit.
;-----------------------------------------------------------------------------
ToDcml     PROC
           sub   al,48
           jb    tdout
 
           cmp   al,10
           cmc
tdout:     ret
ToDcml     ENDP
;-----------------------------------------------------------------------------
; Left adjust first PSP argument, assumed space delimited, making upper case
; ASCIIZ string.  Set NameLen (excluding null).  Set carry if error or zero.
;-----------------------------------------------------------------------------
SetName    PROC  NEAR
           mov   di,PSPLEFT    ; PSP offset of command argument length
           xor   cx,cx
           xchg  cl,[di]       ; Fetch length, nulling PSP in case abort
           mov   al,' '
           inc   di            ; Skip over null
           push  di
           add   di,cx         ; Point to CR terminator
           stosb               ; Overwrite with space
           pop   di
           inc   cx
           repe  scasb         ; Skip over leading spaces
           je    snabort       ; All spaces?  Abort
 
           dec   di            ; Point back to non-space
           cmp   BYTE PTR [di],'/'      ; Check for switch
           je    snabort       ; Yes?  Then abort
 
           mov   cl,64         ; Maximum filename length plus one
           push  di            ; Save momentarily
           repne scasb         ; Scan until space found (or none)
           pop   si            ; Restore pointer to start of filename
           jne   snabort       ; 64 non-blanks?  Too many--abort
 
           sub   cx,63
           neg   cx            ; Now holds filename length
           mov   di,PSPLEFT
           mov   NameLen,cx
snloop:    lodsb               ; Shift name leftward
 
           cmp   al,'z'
           ja    snup          ; Too high?  Then ahead
 
           cmp   al,'a'
           jb    snup          ; Too low?  Then ahead
 
           sub   al,'a' - 'A'  ; Else lower case, so convert
snup:      stosb               ; Put byte back
           loop  snloop
 
           xor   al,al         ; Make ASCIIZ string
           stosb
           ret
 
snabort:   stc
           ret
SetName    ENDP
;-----------------------------------------------------------------------------
; Copy file name, less drive:path, to comment line.  Set carry on error.
;-----------------------------------------------------------------------------
CopyName   PROC
           mov   di,PSPLEFT
           mov   cx,NameLen
           cmp   BYTE PTR [di+1],':'
           jne   cnnodrv
 
           dec   cx
           dec   cx
           inc   di
           inc   di
cnnodrv:   mov   al,'\'
 
cnloop:    stc                 ; In case error
           jcxz  cnabort       ; Trailing ':' or '\'?  Abort
 
           mov   si,di
           mov   bx,cx
           repne scasb
           je    cnloop        ; Found '\'?  Look for more
 
           cmp   bx,13
           cmc
           jc    cnabort       ; Too long?  Abort
 
           mov   ShortLen,bx
           mov   cx,bx
           mov   di,OFFSET NameFile
           rep   movsb
 
cnabort:   ret
CopyName   ENDP
;-----------------------------------------------------------------------------
; Set comment delimiters for extension.  Set carry on disallowed extension.
;-----------------------------------------------------------------------------
SetDlm     PROC
           mov   di,OFFSET NameFile
           mov   al,'.'
           mov   cx,12
           repne scasb         ; Look for '.' in comment line filename
           jne   sdabort       ; None?  Abort--blank extensions disallowed
 
           mov   bx,di         ; Save pointer to extension
           mov   si,OFFSET ExtDlmTbl
           mov   cl,ExtNum     ; Number of legal extensions
 
sdloop:    push  cx
           push  si
           mov   cl,4
           mov   di,bx
           repe  cmpsb
           pop   si
           pop   cx
           jne   sdup          ; No match?  Continue loop
 
           add   si,4
           lodsw               ; Left delimiter word follows extension
           mov   LeftDlm,ax
           lodsw               ; Right delimiter word next
           mov   RightDlm,ax
           ret                 ; Carry is clear
 
sdup:      add   si,8          ; Advance to next table extension
           loop  sdloop
 
sdabort:   stc                 ; Flag error--no find
           ret
SetDlm     ENDP
;-----------------------------------------------------------------------------
; Ready temp file name at PSPRIGHT.  Extension changed to @s.  SetDlm assures
; at least one character.
;-----------------------------------------------------------------------------
SetTemp    PROC  NEAR
           mov   si,PSPLEFT
           mov   di,PSPRIGHT
           mov   cx,NameLen
           rep   movsb         ; Copy full filename
 
           std
           xor   al,al         ; Null terminator (not copied)
stloop:    stosb
           mov   si,di
stenter:   lodsb               ; Work backward til '.' reached
           cmp   al,'.'
           mov   al,'@'
           jne   stloop
 
           cld                 ; Restore default direction
           ret
SetTemp    ENDP
;-----------------------------------------------------------------------------
; Update stamp with old data, as flagged, then place in buffer, flagging
; append if needed.  Set carry if no old stamp but delete flagged.
;-----------------------------------------------------------------------------
CopyStamp  PROC  NEAR
           mov   es,BufSeg     ; Restore to DS at end
           mov   di,StampLen
           cmp   di,FileSize   ; Check if file too small for existing stamp
           ja    csappend      ; Yes?  Then ahead
 
           mov   cx,MatchLen
           mov   si,OFFSET LeftDlm
           repe  cmpsb         ; Look for a few matching characters at start
           jne   csappend      ; No match at start?  Then ahead
 
           mov   cx,StampLen - MatchLen
           mov   al,LF
           repne scasb         ; Check if line same length
           jne   csappend      ; Line is too long?  Then ahead
           jcxz  csmatch       ; Found LF at right spot?  Call it a match
 
csappend:  xor   di,di         ; Point to start of buffer
           or    BYTE PTR Flags,IS_APPEND
           test  BYTE PTR Flags,DEL_STAMP
           je    cscopy        ; Delete not also flagged?  Then ok
 
           stc                 ; Else flag error
           jmp   SHORT cscopy
 
csmatch:   test  BYTE PTR Flags,SYS_NAME
           jne   csup1         ; System name already supplied?  Ahead
 
           mov   cx,SysLen
           mov   si,StampLen + SysOffset
           mov   di,OFFSET System
           call  SwapMove      ; Swap ES/DS, move data, restore
 
csup1:     test  BYTE PTR Flags,VER_NUM
           jne   csup2         ; Version number already supplied?  Ahead
 
           mov   cx,VerLen
           mov   si,StampLen + VerOffset
           mov   di,OFFSET Version
           call  SwapMove
 
csup2:     mov   di,StampLen
           clc                 ; Flag ok
cscopy:    mov   cx,StampLen
           mov   si,OFFSET LeftDlm
           rep   movsb
           push  ds
           pop   es
           ret
CopyStamp  ENDP
;-----------------------------------------------------------------------------
; Swap ES/DS, do mass move, swap ES/DS.
;-----------------------------------------------------------------------------
SwapMove   PROC  NEAR
           call  SwapEsDs
           rep   movsb
SwapEsDs:  push  ax
           mov   ax,es
           push  ds
           pop   es
           mov   ds,ax
           pop   ax
           ret
SwapMove   ENDP
;-----------------------------------------------------------------------------
; Read file to buffer, setting FileSize and, if flagged, date/time stamps.
; Set carry on error.
;-----------------------------------------------------------------------------
Read       PROC  NEAR
           mov   dx,PSPLEFT    ; ASCIIZ filename at DS:DX
           mov   ax,3D00h      ; Read open
           int   21h
           jc    readout       ; Open error?
 
           mov   bx,ax         ; Handle
 
           test  BYTE PTR Flags,NO_CHANGE
           je    rdup          ; /N flag not present?  Ahead
 
           mov   ax,5700h      ; Else preserve current info
           int   21h           ; Get CX/DX time/date stamp
           jc    rdclose       ; Error?  Out
 
           mov   FileDate,dx   ; Overwrite DOS or version date
           mov   FileTime,cx   ; Overwrite noon
 
rdup:      mov   dx,StampLen
           mov   cx,FileMax
           push  ds
           mov   ds,BufSeg
           mov   ah,3Fh        ; Read up to CX bytes to DS:DX
           int   21h
           pop   ds
           jc    rdclose       ; Error?  Out
 
           mov   FileSize,ax   ; Save count of bytes read
 
rdclose:   call  Close
readout:   ret                 ; Return carry
Read       ENDP
;-----------------------------------------------------------------------------
; Write buffer to temp file.  Set carry on error.
;-----------------------------------------------------------------------------
Write      PROC  NEAR
           mov   dx,PSPRIGHT   ; Temp file
           xor   cx,cx
           mov   ah,3Ch        ; Create open
           int   21h
           jc    writeout      ; Open error?
 
           mov   bx,ax         ; Handle
 
           mov   ax,StampLen
           mov   cx,FileSize
           mov   dx,ax
           test  BYTE PTR Flags,IS_APPEND
           je    wrup1         ; Not append?  Ahead
 
           add   cx,ax         ; Extra length
           sub   dx,ax         ; Backup offset to start of buffer
 
wrup1:     test  BYTE PTR Flags,DEL_STAMP
           je    wrup2         ; Not remove?  Ahead
 
           sub   cx,ax         ; Less length
           add   dx,ax         ; Advance offset past old stamp
 
wrup2:     push  ds
           mov   ds,BufSeg
           mov   ah,40h        ; Write
           int   21h
           pop   ds
           jc    wrclose       ; Error?
 
           cmp   ax,cx         ; Set carry if too few written
           jc    wrclose       ; Disk full?
 
           mov   dx,FileDate
           mov   cx,FileTime
           mov   ax,5701h      ; Set date/time stamps
           int   21h
 
wrclose:   call  Close
           jc    deltemp       ; Problem?  Delete debris
 
writeout:  ret
Write      ENDP
;-----------------------------------------------------------------------------
; Delete input file.  Set carry on error.
;-----------------------------------------------------------------------------
Delete     PROC  NEAR
           mov   dx,PSPLEFT    ; Input file name
           mov   ah,41h        ; Delete
           int   21h
           jnc   dlout         ; Ok?  Ahead
 
deltemp:   mov   dx,PSPRIGHT   ; Else try to delete temp file
           mov   ah,41h
           int   21h
           stc                 ; Flag problem
dlout:     ret
Delete     ENDP
;-----------------------------------------------------------------------------
; Close file, passing set carry through, or setting carry on error.
;-----------------------------------------------------------------------------
Close      PROC  NEAR
           pushf
           mov   ah,3Eh
           int   21h
           pop   ax
           jc    closeout
 
           push  ax
           popf
closeout:  ret
Close      ENDP
;-----------------------------------------------------------------------------
; Rename temp file to input file.  Set carry on error.
;-----------------------------------------------------------------------------
Rename     PROC  NEAR
           mov   dx,PSPRIGHT   ; Source
           mov   di,PSPLEFT    ; Target
           mov   ah,56h        ; Rename
           int   21h
           ret
Rename     ENDP
 
           EVEN
NewStack   =     $ + 100h
PGM_PARA   =     (OFFSET NewStack - OFFSET Stamp + 10Fh) / 16
 
Code_Seg   ENDS
           END Stamp
