* program  : sq()
* version  : dBASE IV 1.1
* created  : 5/11/91
* modified : 5/11/91
* author   : James Chen
* note     : another dBASE IV UDF
*            global search and replace for string
*
* syntax:
*
*       SQ(<field>, <search string>, <replacement string>)
*
* example:
*
*       . x = 'ruf, bow wow ruf ruf'
*       . y = sq(x, 'ruf', 'meow')
*       . ? y
*       meow, bow wow meow meow
*
* replace all occurence of 'ruf' with 'meow'
* 
*       . replace all name with sq(name, '*', '')
*
* which take out all occurence of '*' from the field called 'name'
* or replace all occurence of '*' with ''
*
*       . replace all number with sq(number, ' ', '0') for val(number)#0
*
* replace all occurence of ' ' with '0' in the 'number' character field
* (will skip the ones that have have just '0' or spaces in them) 
*

FUNCTION sq
PARAMETER string, search_str, replace_str

SET TALK OFF

ret_str = string

DO WHILE .T.
   
   pos = AT(search_str, ret_str)
   
   IF pos = 0
      EXIT
   ENDIF
   
   ret_str = STUFF(ret_str, pos, LEN(search_str), replace_str)
   
ENDDO

SET TALK ON

RETURN ret_str
