****************************************
* Program Name...: SPIRAL.PRG
* Last Updated...: 04/08/94 by Stephen J. Heider, CIS 71572,3231
* First Created..: 03/31/94 by lee bert@aol.com
* Compiler.......: FoxPro 2.5, should work with FoxPro 2.0.
* Description....: Displays random spirals.  Can be used as a screen saver.
*                  To exit, press any key.
* Requirements...: Works with any computer FoxPro can run on, but works best
*                  with faster computers.
* Notes..........: My complements to Lee Bert for the original program. Good job!
* Example........: DO spiral
* Modifications..:
*    04/08/94 SJH  Optimized code for speed, added more random variables,
*                  cleaned up the code, added comments, restore previous
*                  screen on exit.
*

PRIVATE ALL LIKE l*

* Change system settings:
ll_talk_on = (SET('talk') = 'ON')
SET TALK OFF
ll_echo_on = (SET('echo') = 'ON')
SET ECHO OFF
ll_curs_on = (SET('cursor') = 'ON')
SET CURSOR OFF
ll_esca_on = (SET('escape') = 'ON')
SET ESCAPE OFF

* Set video mode for 386/486 w/VGA in standard mode:
IF 'VGA' $ SYS(2006) AND ('80386' $ SYS(17) OR '80486' $ SYS(17)) AND ;
   SROWS() = 25 AND SCOLS()= 80
  SET DISPLAY TO VGA50
  * Note: To keep the program from automatically switching video modes,
  *       comment out the 'SET DISPLAY TO VGA50' line only.
  ll_switch_video = .T.
ELSE
  ll_switch_video = .F.
ENDIF

* Define and activate window:
lc_window = SYS(2015)  && unique name.
DEFINE WINDOW (lc_window) ;
       FROM 0,0 TO SROWS()-1,SCOLS()-1 ;
       NONE ;
       COLOR N/N
ACTIVATE WINDOW (lc_window)

* Set variables:
ln_wrows = WROWS()-1                   && total rows.
ln_wcols = WCOLS()-1                   && total columns.
ll_extvideo = (WROWS() > 49)           && extended video mode?
ln_ctr_col = l_random(0,ln_wcols)      && center column.
ln_ctr_row = l_random(0,ln_wrows)      && center row.
ln_angle = 0                           && angle.
ln_ang_step = .7                       && angle step rate.
ln_radius = 0                          && radius.
ln_rad_step = .01                      && radius step rate.
ln_spiral = 0                          && spiral number.
ll_quit = .F.                          && quit when .T. (when a key is pressed).

CLEAR TYPE                             && clear keyboard buffer.

* Outer loop:
DO WHILE NOT ll_quit

  * Set variables:
  lc_char = CHR(l_random(1,31))        && character to display.
  ln_rad_step = ln_rad_step + .01      && increment radius step rate.
  IF MOD(ln_rad_step,5) = 0
    ln_rad_step = .01                  && reset radius step rate.
  ENDIF
  ln_angle = ln_angle + l_random(1,9)  && increment angle.
  ln_rad_step = ln_rad_step * -1       && reverse direction.
  ln_spiral = ln_spiral + 1            && increment spiral number.
  ln_asp_ratio = (ln_wrows/ln_wcols) * (l_random(1,5) + .4)  && aspect ratio for spirals.
  STORE 0 TO ln_loop1,ln_loop2         && reset loop counters.

  * Inner loop:
  DO WHILE ln_loop2 < 100

    * Check for keystroke:
    IF INKEY() <> 0
      ll_quit = .T.
      EXIT
    ENDIF

    * Set variables:
    ln_radius = ln_radius + ln_rad_step                && increment radius.
    ln_angle = ln_angle + ln_ang_step                  && increment angle.
    ln_row = ln_ctr_row + (COS(ln_angle) * ln_radius * ln_asp_ratio)  && set row.
    ln_col = ln_ctr_col + (SIN(ln_angle) * ln_radius)  && set column.

    * Display character if coordinates are on screen:
    IF BETWEEN(ln_row,0,ln_wrows) AND BETWEEN(ln_col,0,ln_wcols)
      @ln_row,ln_col SAY lc_char
      ln_loop2 = 1
    ELSE
      ln_loop2 = ln_loop2 + 1
      LOOP
    ENDIF

    * Change color:
    IF ln_loop1 = 100
      ln_loop1 = 1
      IF ln_spiral < 4
        DO l_setcolor WITH ll_extvideo
      ENDIF
      LOOP
    ENDIF

    ln_loop1 = ln_loop1 + 1


    *  * If you need to slow it down:
    *  ln_timeout = SECONDS() + .005
    *  DO WHILE BETWEEN(ln_timeout,SECONDS(),86400)
    *    * Note: 86400 = total seconds in a day.  This handles the
    *    *       situation where the program is run over midnight.
    *  ENDDO

  ENDDO  && inner loop.


  * Change color:
  DO CASE
  CASE ln_spiral < 3
    ln_ctr_col = l_random(0,ln_wcols)    && set center column.
    ln_ctr_row = l_random(0,ln_wrows)    && set center row.
    ln_ang_step = ln_ang_step + .1       && increment angle step rate.
    SET COLOR TO N/N                     && change color to all black.
    CLEAR                                && clear screen.
    LOOP
  CASE ln_spiral = 3
    DO l_setcolor WITH ll_extvideo       && change colors.
    LOOP
  OTHERWISE
    DO l_setcolor WITH ll_extvideo       && change colors.
    ln_rad_step = ln_rad_step * -1       && reverse direction.
    IF ln_spiral > 4
      STORE 0 TO ln_radius,ln_spiral     && reset radius and spiral number.
      ln_ctr_col = l_random(0,ln_wcols)  && set center column.
      ln_ctr_row = l_random(0,ln_wrows)  && set center row.
      ln_ang_step = ln_ang_step + .1     && increment angle step rate.
    ENDIF
    LOOP
  ENDCASE

ENDDO  && outer loop.


* Reset previous settings:
IF ll_talk_on
  SET TALK ON
ENDIF
IF ll_echo_on
  SET ECHO ON
ENDIF
IF ll_curs_on
  SET CURSOR ON
ENDIF
IF ll_esca_on
  SET ESCAPE ON
ENDIF
DEACTIVATE WINDOW (lc_window)
RELEASE WINDOW (lc_window)
IF ll_switch_video
  SET DISPLAY TO VGA25
ENDIF

RETURN





************************
* Procedures/Functions *
************************




FUNCTION l_random
PARAMETERS pn_bottom,pn_top
* Return a random number between pn_bottom and pn_top.
RETURN INT((pn_top - pn_bottom + 1) * RAND() + pn_bottom)




PROCEDURE l_setcolor
PARAMETERS pl_extvideo
* Set random colors.
PRIVATE ln_option,lc_fcolor,lc_bcolor,lc_color

* Set foreground color:
ln_option = l_random(1,9)
DO CASE
CASE ln_option = 1
  lc_fcolor = 'X'
CASE ln_option = 2
  lc_fcolor = 'B'
CASE ln_option = 3
  lc_fcolor = 'GR'
CASE ln_option = 4
  lc_fcolor = 'BG'
CASE ln_option = 5
  lc_fcolor = 'G'
CASE ln_option = 6
  lc_fcolor = 'RB'
CASE ln_option = 7
  lc_fcolor = 'R'
CASE ln_option = 8
  lc_fcolor = 'W'
OTHERWISE
  lc_fcolor = 'GR+'
ENDCASE

* Set background color:
IF pl_extvideo
  ln_option = l_random(1,30)
  DO CASE
  CASE ln_option = 1
    lc_bcolor = 'R'
  CASE ln_option = 2
    lc_bcolor = 'RB'
  CASE ln_option = 3
    lc_bcolor = 'GR+'
  CASE ln_option = 4
    lc_bcolor = 'R-'
  CASE ln_option = 5
    lc_bcolor = 'GR'
  CASE ln_option = 6
    lc_bcolor = 'B'
  CASE ln_option = 7
    lc_bcolor = 'R'
  CASE ln_option = 8
    lc_bcolor = 'BG'
  CASE ln_option = 9
    lc_bcolor = 'G'
  OTHERWISE
    lc_bcolor = 'N'
  ENDCASE
ELSE
  lc_bcolor = 'N'
ENDIF

* Set the color:
lc_color = lc_fcolor + IIF(l_random(1,3) = 1, '+', '') + '/' +;
           lc_bcolor + IIF(pl_extvideo AND l_random(1,5) = 1, '+', '')
SET COLOR TO &lc_color
RETURN





*EOF
