*  Program:  SPINNERS.PRG
*  Author:  Robert Borter, Jr. - CIS # 71530,363
*  Notice:  (C) 1991 - 1992 MicroSearch Associates & Robert Borter Designs
*           Tools that are "developer friendly"!

*  Notes:  SAA/CUA style controls.
*  Author retains all rights.
*  Some of the routines first appeared in the Pinter NewsLetter and
*  are included in TEMPEST 2.0, the FoxPro 2.x template system.
*  See SPINNERS.DOC file for more information.

*  Contact MicroSearch for information on FoxPro 
*  products-- 3/4/2 (Utilites) & TEMPEST 2.0 (Templates)

*  MicroSearch Associates         Phone: (904)-694-4294
*  520 SE 44th Avenue               FAX: (904)-694-1869
*  Ocala, FL  34471

SET TALK OFF
SET PROCEDURE TO SPINNERS

* ---Create memvars

* ---Make elements of character array same legnth AND have
*    the GET PICT option the same size as array elements.
DECLARE MonthArray[12]
MonthArray[1] = "January  "
MonthArray[2] = "February "
MonthArray[3] = "March    "
MonthArray[4] = "April    "
MonthArray[5] = "May      "
MonthArray[6] = "June     "
MonthArray[7] = "July     "
MonthArray[8] = "August   "
MonthArray[9] = "September"
MonthArray[10] = "October  "
MonthArray[11] = "November "
MonthArray[12] = "December "

* ---Pad out memvar to largest element in array 
*    or use SIZE option in GET command.
m.CharMonth = PADR(CMONTH(DATE()),9)

DECLARE FileArray[13]
* ---Default export options
FileArray[1] = "DBF"
FileArray[2] = "FOXPLUS"
FileArray[3] = "DELIMITED WITH TAB"
FileArray[4] = "DELIMITED WITH BLANK"
FileArray[5] = "DIF"
FileArray[6] = "MOD"
FileArray[7] = "SDF"
FileArray[8] = "SYLK"
FileArray[9] = "WK1"
FileArray[10] = "WKS"
FileArray[11] = "WR1"
FileArray[12] = "WRK"
FileArray[13] = "XLS"

m.FileType = "DBF"
m.NumberVar   = 45.65
m.DateVar = DATE()
m.DnArrow = CHR(31)
m.UpArrow = CHR(30)
m.PromptBox = CHR(31)  
m.Action = 0

* ---Create entry window
DEFINE WINDOW BUTTONS FROM 6,13 TO 17,67 FLOAT SHADOW ;
  TITLE " SAA/CUA Style Controls " ;
  FOOTER " (C) 1991-1992 MicroSearch "
ACTIVATE WINDOW BUTTONS

* ---Number test
* ---Draw some boxes
@ 1,4 TO 3,14
@ 1,14 TO 3,16
@ 1,16 TO 3,18
@ 1,14 SAY ""
@ 3,14 SAY ""

@ 2,5 GET m.NumberVar PICT "999999.99" ;
  VALID NSButton(.05,"m.NumberVar")
@ 2,15 GET m.DnArrow ;
    WHEN NMouseDn(.05,"m.NumberVar",2,15) color n/w,n/w
@ 2,17 GET m.UpArrow ;
    WHEN NMouseUp(.05,"m.NumberVar",2,17) color n/w,n/w

* ---Character test
* ---Draw some boxes
@ 4,4 TO 6,14
@ 4,14 TO 6,16
@ 4,16 TO 6,18
@ 4,14 SAY ""
@ 6,14 SAY ""

@ 5,5 GET m.CharMonth PICT "!XXXXXXXX" ;
  VALID CSButton("MonthArray","m.CharMonth")
@ 5,15 GET m.DnArrow ;
    WHEN CMouseDn("MonthArray","m.CharMonth",5,15) color n/w,n/w
@ 5,17 GET m.UpArrow ;
    WHEN CMouseUp("MonthArray","m.CharMonth",5,17) color n/w,n/w


* ---DropBox    

* ---Draw some boxes
@ 1,24 TO 3,46
@ 1,46 TO 3,48
@ 1,46 SAY ""
@ 3,46 SAY ""

@ 2,25 GET m.FileType ;
	SIZE 1,20 ;
	DEFAULT " " ;
	VALID DropBox(2,25,@FileArray)
@ 2,47 GET m.PromptBox ;
	SIZE 1,1 ;
	DEFAULT " " ;
	WHEN MouseTouch(2,47,26,"m.FileType","FileArray") color n/w,n/w


* ---Date test - can use same routines as number!
*    Just change picture and variable name.
*    We will use a split arrow  sytle.
* ---Draw some boxes
@ 4,26 TO 6,35
@ 4,24 TO 6,26
@ 4,35 TO 6,37

@ 4,26 SAY ""
@ 6,26 SAY ""
@ 4,35 SAY ""
@ 6,35 SAY ""

@ 5,27 GET m.DateVar PICT "99/99/99" ;
    VALID NSButton(1,"m.DateVar")
@ 5,25 GET m.DnArrow ;
    WHEN NMouseDn(1,"m.DateVar",5,25) color n/w,n/w
@ 5,36 GET m.UpArrow ;
    WHEN NMouseUp(1,"m.DateVar",5,36) color n/w,n/w

@ 8,15 GET m.Action ;
	PICTURE "@*HN  \<Ok; \<Cancel  " ;
	SIZE 1,11,1 ;
	DEFAULT 1 ;
	VALID GoodBye()

READ CYCLE

CLEAR
DO Notice

RETURN


* ---Procedures

FUNCTION CSButton
  PARA Para1, Para2
  *  Array to check, Field name
  *  Usage: CSButton("MonthArray","m.CharMonth")
  *   Note: Entry field should have formatting to avoid 
  *         up/low case problems. 
  ObjNum = _CUROBJ
  * ---Check for Key pressed
  DO CASE
    CASE LASTKEY() = 13 OR LASTKEY() = 9 OR LASTKEY() = 15 OR ;
      LASTKEY() = 18 OR LASTKEY() = 3 OR LASTKEY() = 51
      * ---ENTER, TAB, Shifted Tab PRESSED, PGUP, PGDN, VALIDATE ENTRY
      Index  = ASCAN(&Para1,&Para2)  && Search   
      IF Index = 0
        * ---FIND SOMETHING CLOSE. Sort of like a soft seek
        FirstChar = SUBSTR( &Para2.,1,1 )
        Index  = ASCAN(&Para1,FirstChar)  && Search   
        IF Index = 0
          ArrayElement = ALLTRIM(Para1)+"[1]"
        ELSE
          ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        ENDIF
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum
        RETURN .T.
      ELSE
        * ---ENTRY OK
        ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        RETURN .T.
      ENDIF
    CASE LASTKEY() = 5 
      * ---UPARROW
      Index  = ASCAN(&Para1,&Para2)  && Search   
      IF Index = 0
        * ---FIND SOMETHING CLOSE. Sort of like a soft seek
        FirstChar = SUBSTR( &Para2.,1,1 )
        Index  = ASCAN(&Para1,FirstChar)  && Search   
        IF Index = 0
          ArrayElement = ALLTRIM(Para1)+"[1]"
        ELSE
          ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        ENDIF
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum
        RETURN .T.
      ELSE
        * ---Ok move up one
        ArrayLen = ALEN( &Para1 )
        ArrayElement = ALLTRIM(Para1)+"["+STR(MAX(INDEX-1,1),5,0)+"]"
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum
        RETURN .T.
      ENDIF
    CASE LASTKEY() = 24
      * ---DOWNARROW
      Index  = ASCAN(&Para1,&Para2)  && Search   
      IF Index = 0
        * ---FIND SOMETHING CLOSE. Sort of like a soft seek
        FirstChar = SUBSTR( &Para2.,1,1 )
        Index  = ASCAN(&Para1,FirstChar)  && Search   
        IF Index = 0
          ArrayElement = ALLTRIM(Para1)+"[1]"
        ELSE
          ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        ENDIF
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum
        RETURN .T.
      ELSE
        * ---Ok move down one
        ArrayLen = ALEN( &Para1 )
        ArrayElement = ALLTRIM(Para1)+"["+STR(MIN(INDEX+1,ArrayLen),5,0)+"]"
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum
        RETURN .T.
      ENDIF
  ENDCASE
RETURN  

FUNCTION CMouseDn
  PARA Para1, Para2, Para3, Para4
  * Para1 & Para2 = Array to check, Field name
  * Para3 & Para4 = position of arrow box
  ObjNum = _CUROBJ
  * ---CLEAR LASTKEY()
  KEYBOARD "{SPACEBAR}"
  = INKEY(0)
  IF MROW() = Para3 AND MCOL() = Para4
      Index  = ASCAN(&Para1,&Para2)  && Search   
      IF Index = 0
        * ---FIND SOMETHING CLOSE. Sort of like a soft seek
        FirstChar = SUBSTR( &Para2.,1,1 )
        Index  = ASCAN(&Para1,FirstChar)  && Search   
        IF Index = 0
          ArrayElement = ALLTRIM(Para1)+"[1]"
        ELSE
          ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        ENDIF
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum -1
        RETURN .T.
      ELSE
        * ---Ok move down one
        ArrayLen = ALEN( &Para1 )
        ArrayElement = ALLTRIM(Para1)+"["+STR(MIN(INDEX+1,ArrayLen),5,0)+"]"
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum -1
        RETURN .T.
      ENDIF
  ENDIF
RETURN .F.  

FUNCTION CMouseUp
  PARA Para1, Para2, Para3, Para4
  * Para1 & Para2 = Array to check, Field name
  * Para3 & Para4 = position of arrow box
  ObjNum = _CUROBJ
  * ---CLEAR LASTKEY()
  KEYBOARD "{SPACEBAR}"
  = INKEY(0)
  IF MROW() = Para3 AND MCOL() = Para4
      Index  = ASCAN(&Para1,&Para2)  && Search   
      IF Index = 0
        * ---FIND SOMETHING CLOSE. Sort of like a soft seek
        FirstChar = SUBSTR( &Para2.,1,1 )
        Index  = ASCAN(&Para1,FirstChar)  && Search   
        IF Index = 0
          ArrayElement = ALLTRIM(Para1)+"[1]"
        ELSE
          ArrayElement = ALLTRIM(Para1)+"["+STR(INDEX,5,0)+"]"
        ENDIF
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum -2
        RETURN .T.
      ELSE
        * ---Ok move up one
        ArrayLen = ALEN( &Para1 )
        ArrayElement = ALLTRIM(Para1)+"["+STR(MAX(INDEX-1,1),5,0)+"]"
        STORE &ArrayElement TO &Para2
        SHOW GET &Para2
        _CUROBJ = ObjNum -2
        RETURN .T.
      ENDIF
   ENDIF
RETURN .F.

FUNCTION NSButton
  PARA Para1, Para2
  *  Increment amount, Field name
  *  Usage: NSButton(.05,"m.NumberVar")
  *   Note: The routine will accept any number but it can be
  *         easily modified to accept only certain ranges etc...
  ObjNum = _CUROBJ
  * ---Check for Key pressed
  DO CASE
    CASE LASTKEY() = 13 OR LASTKEY() = 9 OR LASTKEY() = 15 OR ;
      LASTKEY() = 18 OR LASTKEY() = 3 OR LASTKEY() = 51
      * ---ENTER, TAB, Shifted Tab PRESSED, PGUP, PGDN, VALIDATE ENTRY
      * ---We will accept any number
    CASE LASTKEY() = 5 
      * ---UPARROW
      STORE &Para2 + Para1 TO &Para2
      SHOW GET &Para2
      _CUROBJ = ObjNum
      RETURN .T.
    CASE LASTKEY() = 24
      * ---DOWNARROW
      STORE &Para2 - Para1 TO &Para2
      SHOW GET &Para2
      _CUROBJ = ObjNum
      RETURN .T.
  ENDCASE
RETURN  

FUNCTION NMouseUp
  PARA Para1, Para2, Para3, Para4
  * Para1 & Para2 = Amount to add, Field name
  * Para3 & Para4 = position of arrow box
  ObjNum = _CUROBJ
  * ---CLEAR LASTKEY()
  KEYBOARD "{SPACEBAR}"
  = INKEY(0)
  IF MROW() = Para3 AND MCOL() = Para4
    * ---UPARROW
    STORE &Para2 + Para1 TO &Para2
    SHOW GET &Para2
    _CUROBJ = ObjNum -2
    RETURN .T.
  ENDIF
RETURN .F.

FUNCTION NMouseDn
  PARA Para1, Para2, Para3, Para4
  * Para1 & Para2 = Amount to add, Field name
  * Para3 & Para4 = position of arrow box
  ObjNum = _CUROBJ
  * ---CLEAR LASTKEY()
  KEYBOARD "{SPACEBAR}"
  = INKEY(0)
  IF MROW() = Para3 AND MCOL() = Para4
    STORE &Para2 - Para1 TO &Para2
    SHOW GET &Para2
    _CUROBJ = ObjNum -1
    RETURN .T.
  ENDIF
RETURN .F.


FUNCTION DropBox
 Para Para1, Para2, ArrayList, Memvar
  IF PARAMETERS() < 4
    GetName  = VARREAD()
  ELSE
    GetName = Memvar
  ENDIF    
  GetValue = &GetName
  m.pos  = ASCAN( ArrayList, GetValue )  && Search
  * ---Validation if not found or Down arrow pressed
  IF m.pos != 0  AND LASTKEY() # 24
	* --- Value found
	RETURN .T.   
  ENDIF  
  DEFINE POPUP GenPop FROM Para1+1,Para2 SCROLL
  FOR i = 1 TO ALEN( ArrayList )
    DEFINE BAR i OF GenPop PROMPT ArrayList[i]
  NEXT
  ON SELECTION POPUP GenPop Deactivate popup
 DO WHILE .T.
  ACTIVATE POPUP GenPop
  * ---This will allow you to keep an unvalidated entry if you want
  *    otherwise remove 
  * ---Test Esc or Tab!
  DO CASE
    * ---Key Exceptions
    CASE LASTKEY() = 13
      * --Selection made.
      STORE Prompt() TO &GetName
    CASE LASTKEY() = 27
      * ---Esc, leave alone or loop!  
      LOOP
    CASE LASTKEY() = 9
      * ---Same for the tab!
      LOOP
    CASE LASTKEY() = 22
      * ---TRAP INS Key if you would like to add to database
    OTHERWISE
      LOOP
  ENDCASE
  SHOW GET &GetName
  EXIT
  ENDDO
RETURN

FUNCTION MouseTouch
  Para  Para1, Para2, Para3, Para4, Para5
  * Para1 & Para1 = position of arrow box
  * Para3         = column of get field
  * Para 4        = Get field name
  * Para 5        = ArrayName
  IF MROW() = Para1 AND MCOL() = Para2
    * ---Set LASTKEY() to a downarrow so that list is triggered!
    KEYBOARD "{DNARROW}"
    =INKEY(0)
    * ---Pass position, array and field name
    ArrayName = "@"+Para5
    =DropBox(Para1,Para3,&ArrayName,Para4)
    KEYBOARD "{TAB}"
    RETURN .T.
  ENDIF
RETURN .F.

FUNCTION GoodBye     &&  m.Action VALID
DO CASE
  CASE m.Action = 1
    * ---Save changes? and exit
    CLEAR READ
  CASE m.Action = 2
    CLEAR READ
ENDCASE

PROCEDURE Notice
  ?
  ? "       Contact MicroSearch for information on "
  ? "            additional FoxPro products: "
  ? "     3/4/2 (Utilites) & TEMPEST 2.0 (Templates)"
  ?
  ? "MicroSearch Associates         Phone: (904)-694-4294"
  ? "520 SE 44th Avenue               FAX: (904)-694-1869"
  ? "Ocala, FL  34471               CIS #: 71530,363"
  ?
  ? "                Robert Borter Designs"
RETURN

