private dDate1,dDate2,dDate3
private all like lk*

push key clear
* setup lastkey() traps with names instead of numbers
ikPgUp = 18
ikPgDn = 3
ikPlus = 43
ikMinus = 45
ikTab = 9
ikShTab = 15
store date() to dDate1,dDate2,dDate3
do spdate1.spr
pop key

**********************************************************************
* change date when a spinner control is hit
**********************************************************************
procedure SChgDate
parameter pUD, pRow,pHeight,pCol,pWidth
private cDateFld,nTotHits,nTime,nInc,nRow,nCol

nRow = mrow()
nCol = mcol()
if pUD = 'U'
	cDateFld = objvar(_curobj - 1)
	nInc = 1
else
	cDateFld = objvar(_curobj - 2)
	nInc = - 1
endif
nWait = .4				&& adjust to suit your needs
nTotHits = 0
do case
case _dos or _unix
	lOk = mdown() and mrow()=nRow and mcol() = nCol
case _mac or _windows
	lOk = mdown() and ;
		  between(mrow(),pRow,pRow+pHeight) and ;
		  between(mcol(),pCol,pCol+pWidth)
otherwise
	lOk = .F.
endcase
do while lOk
	&CDateFld = &CDateFld + nInc
	show get &CDateFld
	nTime = seconds()
	do while seconds()-nTime < nWait		&& wait a little
	enddo
	nTotHits = nTotHits + 1
	do case
	case _dos or _unix
		lOk = mdown() and mrow()=nRow and mcol() = nCol
	case _mac or _windows
		lOk = mdown() and ;
			  between(mrow(),pRow,pRow+pHeight) and ;
			  between(mcol(),pCol,pCol+pWidth)
	otherwise
		lOk = .F.
	endcase
* optional code:  the longer they hold down mouse, the faster the change
	if nTotHits % 3 = 0 and nWait > 0
		nWait = nWait - .1
	endif	
enddo
_curobj=objnum(&cDateFld)
return
*********************************************************************
* next is the on key label routine called when user hits 1 of 4 hot keys
* while in a date field
****************************************************************
procedure ChgDate
parameter pDateVar
private nType

nType = set('type')		&& store the current typeahead setting
set typeahead to 0		&& prevent recursive call to OKL routine
do case
case lastkey() = ikPlus
	&pDateVar = &pDateVar + 1
case lastkey() = ikMinus
	&pDateVar = &pDateVar - 1
case lastkey() = ikPgup
	&pDateVar = gomonth(&pDateVar,1)
case lastkey() = ikPgDn
	&pDateVar = gomonth(&pDateVar,-1)
endcase
show get &pDateVar

clear typeahead
set typeahead to (nType)		&& restore typeahead setting
return

***********************************************
* procedure to make certain keys hot for dates
***********************************************
procedure DateKeys
parameter pHot
private nType

if pHot
	on key label + do ChgDate with objvar()
	on key label - do ChgDate with objvar() 
	on key label pgup do ChgDate with objvar()
	on key label pgdn do ChgDate with objvar()
else
	on key label +
	on key label -
	on key label pgup
	on key label pgdn
	if lastkey() = ikTab		&& skip the spinner buttons
		_curobj = _curobj + 3
	endif
endif
return
***********************************************
