*  Program...........: CDXAUDIT.PRG
*  Author............: Stephen A. Sawyer
*  Project...........: Utilities Library
*  Created...........: 06/10/94  15:29:59
*  Copyright.........: (c) KarCal Company, Inc., 1994
*) Description.......: CDX Tag Auditor
*)                   : Creates a table, CDXAUDIT storing
*)                   : all compound index tags on each
*)                   : file in the subdirectory specified,
*)                   : as well as all the necessary expression
*)                   : information needed to re-create all the
*)                   : indexes
*  Calling Samples...: DO CDXAUDIT WITH "C:\PROJECT\DATA"
*  Parameter List....: pcDbfDir - Directory containing
*  ..................: 	DBF files to be audited
*  ..................: pcSysDir - (optional) Directory containing
*  ..................: 	system files - CDXAUDIT.DBF and
*  ..................:  DBFLIST.DBF
*               Calls: JUSTPATH()         
*                    : NOEXT()            
*                    : GENTEMP()          
*                    : YNALERT()          
*  Major change list.: 
PARAMETERS pcDbfDir,pcSysDir
IF PARAMETERS() = 0
	?? CHR(7)
	WAIT "Must supply directory in which DBF's are stored" WINDOW
	RETURN
ELSE
	IF RIGHT(pcDbfDir,1) # "\"
		lcDbfDir=pcDbfDir + "\"
	ELSE
		lcDbfDir=pcDbfDir
	ENDIF ( RIGHT(pcDbfDir,1) # "\" )
	IF PARAMETERS() = 2
		IF RIGHT(pcSysDir,1) # "\"
			lcSysDir = pcSysDir + "\"
		ELSE
			lcSysDir =pcSysDir
		ENDIF
	ELSE
		lcSysDir = lcDbfDir
	ENDIF
	IF ! (LEFT(lcDbfDir,LEN(lcDbfDir)-1) $ SET("PATH"))
		SET PATH TO (SET("PATH") + ";" + lcDbfDir)
	ENDIF
	IF ! (LEFT(lcSysDir,LEN(lcSysDir)-1) $ SET("PATH"))
		SET PATH TO (SET("PATH") + ";" + lcSysDir)
	ENDIF
ENDIF ( PARAMETERS() = 0 )

DO NOTIFY WITH "Auditing structural compound index tags..."
PRIVATE laDbfLst, lnDbfs, laCdx,lcDbfDir,lcDbfMask,lnTagCount, ;
	lnTag, lcForExpr, lnIdxd, luThis, luNext, lnMaxExpr, lnMaxFor, ;
	lcAudFile, lcAudBak, lcAudCdx, llAudChgd,lcAddFile,lcForExp, ;
	lcRelExp,lnAddDbfs,lnIdxd,lnRecords
lcOldTalk=SET("TALK")
SET TALK OFF
lcDbfMask=lcDbfDir + "*.DBF"
*****************************************************************
* Construct a list of all dbf files located in the specified directory, stored to the
* array laDbfLst
*****************************************************************
=ADIR(laDbfLst,lcDbfMask)
lnDbfs=ALEN(laDbfLst,1)
IF lnDbfs = 0
	?? CHR(7)
	WAIT "No databases found during CDX file auditing" WINDOW
	RETURN
ENDIF ( lnDbfs = 0 )
*****************************************************************
* Set up an array to hold the index tags and their specifications
*****************************************************************
DIMENSION laCdx[1,7]
lnTagCount=0
lcOldDel=SET("DELETED")
SET DELETED OFF
IF "2.6" $ VERSION()
	llTwoSix=.T.
ELSE
	llTwoSix=.F.
ENDIF
FOR i=1 TO lnDbfs
	WAIT "Auditing " + TRIM(laDbfLst[i,1]) WINDOW NOWAIT
	USE (laDbfLst[i,1])
	lnTag=1
	*************************************************************
	* Examine each compound structural index tag
	*************************************************************
	DO WHILE ! EMPTY(TAG(lnTag))
		SET ORDER TO
		IF  ! llTwoSix
			*********************************************************
			* Count records before setting the index the the current 
			* tag - this is used to check to see if the current tag is 
			* indexed UNIQUE needed only in FoxPro versions prior to 2.6
			*********************************************************
			IF EMPTY(SYS(2021,lnTag))
				lnRecords=RECCOUNT()
			ELSE
				lcForExp=SYS(2021,lnTag)
				COUNT FOR &lcForExp TO lnRecords
			ENDIF ( EMPTY(SYS(2021,lnTag)) )
		ENDIF
		**********************************************************
		* Set order to the current tag
		**********************************************************
		SET ORDER TO lnTag
		**********************************************************
		* Count the indexed records - if less than lnRecords determined 
		* above, tag must be indexed  UNIQUE - SEE DOCUMENTATION!!
		* the UNIQUE() function in FoxPro 2.6 and later makes this
		* "counting" unnecessary
		**********************************************************
		IF ! llTwoSix
			COUNT TO lnIdxd
			IF lnIdxd < lnRecords
				llUnique=.T.
			ELSE
				llUnique = .F.
			ENDIF
		ELSE
			llUnique = UNIQUE(lnTag)
		ENDIF
		GOTO TOP
		***********************************************************
		* Check to see if the records are in ascending 
		* or descending order
		***********************************************************
		IF ! llTwoSix
			luThis=EVALUATE(KEY(lnTag))
			SCAN WHILE luThis=EVALUATE(KEY(lnTag))
			ENDSCAN
			luNext=EVALUATE(KEY(lnTag))
			IF luThis > luNext
				llDescending=.T.
			ELSE
				llDescending=.F.
			ENDIF
		ELSE
			llDescending=DESCENDING(lnTag)
		ENDIF
		lnTagCount=lnTagCount+1
		IF ALEN(laCdx,1) < lnTagCount
			DIMENSION laCdx[lnTagCount,7]
		ENDIF ( ALEN(laCdx,1) < lnTagCount )
		***********************************************************
		* Store all the index tag specs to the laCdx array
		***********************************************************
		laCdx[lnTagCount,1] = laDbfLst[i,1]	&& DBF filename
		laCdx[lnTagCount,2] = KEY(lnTag)	&& Index Expression
		laCdx[lnTagCount,3] = TAG(lnTag)	&& Tag Name
		laCdx[lnTagCount,4] = IIF(!EMPTY(SYS(2021,lnTag)),SYS(2021,lntag),"")	&& "FOR" clause
		laCdx[lnTagCount,5] = llUnique		&& UNIQUE?
		laCdx[lnTagCount,6] = llDescending 	&& DESCENDing?
		laCdx[lnTagCount,7] = lnTag			&& Tag number
		lnTag=lnTag+1
	ENDDO ( ! EMPTY(TAG(lnTag)) )
ENDFOR ( i )
SET DELETED &lcOldDel
CLOSE DATA
*****************************************************************
* Determine the maximum length of index expressions and FOR clauses
*****************************************************************
lnMaxExpr=1
lnMaxFor=1
FOR i=1 TO ALEN(laCdx,1)
	lnMaxExpr=MAX(lnMaxExpr,LEN(laCdx[i,2]))
	lnMaxFor=MAX(lnMaxFor,LEN(laCdx[i,4]))
ENDFOR ( i )
*****************************************************************
* Save the index information to a cursor
*****************************************************************
CREATE CURSOR cdxstru ;
	(dbfname C(12), expr C(lnMaxExpr), TAG C(10), FOR C(lnMaxFor), UNIQUE L, DESCEND L, tagno N(2))
APPEND FROM ARRAY laCdx
INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
*****************************************************************
* If CDXAUDIT.DBF file exists, check to see if it matches the new information
* in the CDXSTRU cursor
*****************************************************************
IF FILE("CDXAUDIT.DBF")
	SELECT 0
	USE cdxaudit ORDER TAG name_tag
	lcRelExp= KEY(1)
	SET RELATION TO &lcRelExp INTO cdxstru
	llAudChgd=.F.
	SCAN
		IF EVALUATE(KEY(1,"CDXSTRU")) = EVALUATE(KEY(1,"CDXAUDIT")) ;
				AND TRIM(cdxstru.expr) == TRIM(cdxaudit.expr) ;
				AND TRIM(cdxstru.for) == TRIM(cdxaudit.for) ;
				AND cdxstru.unique=cdxaudit.unique ;
				AND cdxstru.descend=cdxaudit.descend
			llAudChgd=.T.
			EXIT
		ENDIF ( EVALUATE(KEY(1,"CDXSTRU")) = EVALUATE(KEY(1,"CDXAUDIT")) ; )
	ENDSCAN
	IF llAudChgd
		*********************************************************
		* If something has changed (new or changed tags, new databases etc.)
		* then rename the existing CDXAUDIT.DBF to CDXAUDIT.BAK
		* and save the current CDXSTRU cursor as CDXAUDIT.DBF
		*****************************************************************
		WAIT "Creating NEW CDXAUDIT File..." WINDOW NOWAIT
		lcAudFile=FULLPATH("CDXAUDIT.DBF")
		lcAudBak=JUSTPATH(lcAudFile) + "\" + noext(lcaudfile) + ".BAK"
		lcAudCdx=JUSTPATH(lcAudFile) + "\" + noext(lcaudfile) + ".CDX"
		SELECT cdxaudit
		USE
		IF FILE(lcAudBak)
			ERASE (lcAudBak)
		ENDIF ( FILE(lcAudBak) )
		RENAME &lcAudFile TO &lcAudBak
		ERASE lcAudCdx
		SELECT cdxstru
		COPY TO (lcAudFile)
		SELECT 0
		USE (lcAudFile)
		INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
		INDEX ON dbfname TAG dbfname UNIQUE
		WAIT CLEAR
	ENDIF ( llAudChgd )
ELSE
	WAIT "Creating CDXAUDIT File..." WINDOW NOWAIT
	lcAudFile = lcSysDir + "CDXAUDIT"
	COPY TO (lcAudFile)
	SELECT 0
	USE (lcAudFile)
	INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
	INDEX ON dbfname TAG dbfname UNIQUE
	WAIT CLEAR
ENDIF ( FILE("CDXAUDIT.DBF") )
SELECT cdxstru
USE
*****************************************************************
* Check to see if there are any "new" databases in CDXAUDIT.DBF that should
* be added to DBFLIST.DBF
*****************************************************************
SELECT cdxaudit
SELECT 0
USE dbflist
SET ORDER TO TAG dbfname
SELECT cdxaudit
SET RELATION TO dbfname INTO dbflist
SCAN
	IF ! dbflist.cdx
		SELECT dbflist
		REPLACE dbflist.cdx WITH .T.
		SELECT cdxaudit
	ENDIF ( ! dbflist.cdx )
ENDSCAN
SELECT dbflist
SET FILTER TO dbflist.cdx
SELECT cdxaudit
COUNT FOR EOF("DBFLIST") TO lnAddDbfs
IF lnAddDbfs > 0
	lcAddFile=GENTEMP()
	COPY FIELDS dbfname TO (lcAddFile) FOR EOF("DBFLIST")
	SET RELATION OFF INTO dbflist
	USE (lcAddFile) ALIAS AddFiles
	SCAN
		IF ynalert("Add " + TRIM(AddFiles.dbfname) + " to Database List?")
			SCATTER MEMVAR
			SELECT dbflist
			APPEND BLANK
			GATHER MEMVAR
			REPLACE dbflist.cdx WITH .T.
			IF ynalert("Allow packing of " + TRIM(AddFiles.dbfname))
				REPLACE dbflist.pack WITH .T.
			ENDIF ynalert("Allow packing of " + TRIM(AddFiles.dbfname))
			IF ynalert("Sort by first key field?",2)
				REPLACE dbflist.sort WITH .T.
			ENDIF
			SELECT AddFiles
		ENDIF ynalert("Add " + TRIM(AddFiles.dbfname) + " to Database List?")
	ENDSCAN
	SELECT AddFiles
	USE
	ERASE (lcAddFile)
ENDIF ( lnAddDbfs > 0 )
CLOSE DATA
USE dbflist
SELECT 0
USE cdxaudit ORDER TAG dbfname
SELECT dbflist
SET RELATION TO dbfname INTO cdxaudit
REPLACE CDX WITH .F. FOR EOF("cdxaudit")
CLOSE DATA
SET TALK &lcOldTalk
WAIT CLEAR
DO notify
*: EOF: CDXAUDIT.PRG
