****************************************************************************
* SENDFORM.PRG - Used to send a file to the printer.   v1.01
*                Originally written to send HP-Macro files to
*                laser printers.  Written by Cory A. Jaeger
*       SYNTAX -  =SENDFORM("filename")   where filename
*                is the file you want sent to printer.
*
* FREE!!! - I wrote this program for my own use and am releasing
*           it into puplic domain on the following conditions.
*         - If you use it, PLEASE let me know.  (It's nice to know that
*           others find your work useful.)  CIS - 73424,536.
*         - A thank-you gift of $1 would be appreciated if you find that
*           you are frequently using this code either un-modified or
*           as a base for other code.  (HOWEVER, IT IS NOT REQUIRED!)
*         - I must get credit for this code if used in any publication.
*         - My name must not be removed from the comments of this code
*           as the original writer.
*         - If you release any updated/revised version, you must add
*           to these comments.  Include your name and a summary
*           of what you have fixed/added.  (Please, send me a copy of
*           the updated code.)
*
*
*   PARAMETERS - m.form - (Character) Name of file to be sent.
*
****************************************************************************
PARAMETERS m.form
PRIVATE m.fhand, m.fsize, m.fsent, m.pct, m.opct, m.buffer, m.bcount
PRIVATE m.answr, cur_talk, cur_print
* Save original SET TALK settings
IF SET("TALK") = "ON"
   SET TALK OFF
   cur_talk="ON"
ELSE
   cur_talk="OFF"
ENDIF

* Save original SET PRINT setting
cur_print=SET("PRINT")
SET PRINT OFF

IF EMPTY(m.form)                                 && If no filename passed.
   m.form="SYNTAX-ERROR"                         && Will generate an error later.
ENDIF

m.answr="T"
DO WHILE UPPER(m.answr)<>"S"                     && Keep trying until user says stop.
   m.fhand=FOPEN(m.form)                         && Open file.
   IF m.fhand=-1                                 && IF open failed.
      ??CHR(7)                                   && Beep
      WAIT WINDOW "Can not access form: "+m.form+CHR(13)+;
         "Most likely, someone else is sending the form right now."+CHR(13)+;
         CHR(13)+;
         "Do you want to Try again or Stop?  (T/s)?" TO m.answr
   ELSE
      m.answr="S"                                && Stop trying if form opens ok.
   ENDIF
ENDDO
IF m.fhand<>-1                                   && If file open was successful..
   IF PRINTSTATUS()                              && Make sure printer is ready.
      m.fsize=FSEEK(m.fhand,0,2)                 && Get file size (For progress)
      =FSEEK(m.fhand,0)                          && Set pointer to beginning.
      m.opct=101
      m.fsent=0                                  && Bytes sent to printer.
      DO progress WITH 0,"Sending Form to Printer" && display thermometer
      DO WHILE !FEOF(m.fhand)                    && Continue till end of file is reached.
         m.buffer=FREAD(m.fhand,2048)            && Read approx 2k of data
         m.bcount=LEN(m.buffer)                  && How much was actually read?
         m.buffer=STRTRAN(m.buffer,"{","{123}")  && Prevent ??? translation from messing things up.
         ??? m.buffer                            && Send data to printer.
         m.fsent=m.fsent+m.bcount                && Update bytes sent.
         m.pct=INT(m.fsent/m.fsize*100)          && Calculate % completed.
         IF m.pct<>m.opct                        && If different % than last call to PROGRESS.PRG
            m.opct=m.pct
            DO progress WITH m.pct, "Sending Form to Printer" && Update thermom.
         ENDIF
      ENDDO
      DO progress WITH 100,"Done"                && Be sure themom. shows 100% and "Done"
      ??CHR(7)
      =INKEY(2)                                  && Let user have time to see 100%
      DO progress WITH -1                        && Remove progress bar.
   ELSE
      ??CHR(7)+CHR(7)
      WAIT WINDOW "Printer NOT ready."
   ENDIF
ENDIF
=FCLOSE(m.fhand)                                 && Close the print file (form)
SET PRINT &cur_print                             && Restore old SET PRINT setting
SET TALK &cur_talk                               && Restore old SET TALK setting
RETURN

